/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.Messages;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.ProjectExplorerNodeWalkerWithIProgress;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.ReverseSelectedNodeVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dialog.ReverseCodeDialog;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.exception.JavaReverseException;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.handlers.AbstractExecuteInJobHandler;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.utils.QualifiedNamesFromIJavaElementCollector;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;

public class JavaCodeReverseInJobHandler
extends AbstractExecuteInJobHandler
implements IHandler {
    private static String DefaultGenerationModeleName = "";
    protected ReverseSelectedNodeVisitor.Parameters parameters;
    private ITreeSelection recordedSelection;
    private int selectedParser = 0;

    @Override
    String getJobName() {
        return "Reverse Java Code";
    }

    @Override
    protected boolean doPrepareExecute(ExecutionEvent event) {
        Model modelRoot;
        UmlModel umlModel;
        try {
            umlModel = this.getUmlModel();
            modelRoot = (Model)umlModel.lookupRoot();
        }
        catch (NotFoundException e) {
            Shell shell = this.getShell();
            Status errorStatus = new Status(4, "org.eclipse.papyrus.infra.core", Messages.ReverseCodeHandler_NoModelError_Title);
            ErrorDialog.openError((Shell)shell, (String)"", (String)Messages.ReverseCodeHandler_NoModelError_Message, (IStatus)errorStatus);
            return false;
        }
        catch (ServiceException e) {
            Shell shell = this.getShell();
            Status errorStatus = new Status(4, "org.eclipse.papyrus.infra.core", Messages.ReverseCodeHandler_NoPapyrusEditor_Title);
            ErrorDialog.openError((Shell)shell, (String)"", (String)Messages.ReverseCodeHandler_NoPapyrusEditor_Message, (IStatus)errorStatus);
            return false;
        }
        String modelUid = this.getModelUid(umlModel.getResource());
        Shell shell = this.getShell();
        ReverseCodeDialog dialog = this.getDialog(shell, modelUid);
        int res = dialog.open();
        if (res == 1) {
            return false;
        }
        this.parameters = new ReverseSelectedNodeVisitor.Parameters();
        this.parameters.setSearchPaths(Arrays.asList(dialog.getSearchPath()));
        this.parameters.setUmlRootPackage((Package)modelRoot);
        this.parameters.setPackageName(this.getPackageName(dialog));
        this.selectedParser = dialog.getSelectedParserIndex();
        this.parameters.setCreationPaths(dialog.getCreationPaths());
        ISelection selection = this.getCurrentSelection();
        if (!(selection instanceof ITreeSelection)) {
            Status errorStatus = new Status(4, "org.eclipse.papyrus.infra.core", Messages.ReverseCodeHandler_WrongSelectionType_Title);
            ErrorDialog.openError((Shell)shell, (String)"", (String)Messages.ReverseCodeHandler_WrongSelectionType_Message, (IStatus)errorStatus);
            return false;
        }
        this.recordedSelection = (ITreeSelection)selection;
        QualifiedNamesFromIJavaElementCollector collector = new QualifiedNamesFromIJavaElementCollector(false, true, false);
        List<String> qualifiedNamesInProjects = collector.getQualifiedNamesFromSelection((ISelection)this.recordedSelection);
        this.parameters.setQualifiedNamesInProjects(qualifiedNamesInProjects);
        return true;
    }

    @Override
    protected void doExecuteTransactionInJob(IProgressMonitor monitor) {
        System.err.println("Transaction and job called !");
        switch (this.selectedParser) {
            case 0: 
            case 1: {
                ReverseSelectedNodeVisitor visitor = new ReverseSelectedNodeVisitor(this.parameters);
                ProjectExplorerNodeWalkerWithIProgress reverseWalker = new ProjectExplorerNodeWalkerWithIProgress(visitor);
                reverseWalker.visit(this.recordedSelection.toList(), monitor);
                break;
            }
            case 2: {
                System.err.println("Use JDT parser (todo)");
                return;
            }
        }
    }

    private String getModelUid(Resource umlResource) {
        String modelUid = umlResource.getURI().toPlatformString(true);
        if (modelUid == null) {
            modelUid = umlResource.getURI().path();
        }
        return modelUid;
    }

    protected ReverseCodeDialog getDialog(Shell shell, String modelUid) {
        String selectedProjectName;
        try {
            selectedProjectName = this.getSelectedProjectName();
        }
        catch (JavaReverseException e) {
            selectedProjectName = "";
        }
        return new ReverseCodeDialog(shell, modelUid, selectedProjectName, null);
    }

    protected String getPackageName(ReverseCodeDialog dialog) {
        String generationPackageName = dialog.getValue();
        if (generationPackageName == null || generationPackageName.length() == 0) {
            generationPackageName = DefaultGenerationModeleName;
        }
        return generationPackageName;
    }
}

