/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts.CustomFullStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CrossFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.DimensioningArrowFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullStateFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullStateInvariantVerticalLineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.GeneralOrderingHorizontalFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.SmallSquareFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.VerticalMarkFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.layouts.FillLayout;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineTimelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.StateDefinitionEditPart;
import org.eclipse.uml2.uml.StateInvariant;

public class CustomFullLifelineTimelineCompartmentEditPartCN
extends FullLifelineTimelineCompartmentEditPartCN {
    public CustomFullLifelineTimelineCompartmentEditPartCN(View view) {
        super(view);
    }

    @Override
    public IFigure createFigure() {
        ResizableCompartmentFigure figure = (ResizableCompartmentFigure)super.createFigure();
        figure.setBorder(null);
        figure.getScrollPane().setBorder(null);
        figure.setLayoutManager((LayoutManager)new FillLayout());
        figure.getContentPane().setLayoutManager((LayoutManager)new FreeFormLayoutEx(){

            public void layout(IFigure container) {
                EditPartViewer viewer = CustomFullLifelineTimelineCompartmentEditPartCN.this.getRoot().getViewer();
                IFigure parent = container.getParent();
                if (parent instanceof FreeformViewport) {
                    FreeformViewport freeformViewport = (FreeformViewport)parent;
                    if (!(freeformViewport.getLayoutManager() instanceof FillLayout)) {
                        freeformViewport.setLayoutManager((LayoutManager)new FillLayout());
                    }
                    freeformViewport.setViewLocation(0, 0);
                }
                Rectangle clientArea = container.getParent().getClientArea();
                List children = container.getChildren();
                Rectangle[] constraints = new Rectangle[children.size()];
                int i = 0;
                while (i < children.size()) {
                    constraints[i] = (Rectangle)this.getConstraint((IFigure)children.get(i));
                    ++i;
                }
                CustomFullLifelineTimelineCompartmentEditPartCN.layoutOccurrenceSpecificationsAndStateInvariants(viewer, clientArea, children, constraints);
                CustomFullLifelineTimelineCompartmentEditPartCN.layoutVerticalLinesAndTimeElements(children, clientArea, constraints);
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
        return figure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ((ResizableCompartmentFigure)this.getFigure()).getScrollPane().setScrollBarVisibility(0);
        this.refreshBounds();
    }

    public boolean isSelectable() {
        return false;
    }

    public Command getCommand(Request request) {
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            if ("connection start".equals(request.getType())) {
                if (createConnectionRequest.getTargetEditPart() instanceof FullLifelineTimelineCompartmentEditPartCN) {
                    createConnectionRequest.setTargetEditPart(this.getParent());
                }
                return this.getParent().getCommand(request);
            }
            if ("connection end".equals(request.getType())) {
                if (createConnectionRequest.getSourceEditPart() instanceof FullLifelineTimelineCompartmentEditPartCN) {
                    createConnectionRequest.setSourceEditPart(this.getParent());
                }
                return this.getParent().getCommand(request);
            }
        }
        return super.getCommand(request);
    }

    protected static void layoutOccurrenceSpecificationsAndStateInvariants(EditPartViewer viewer, Rectangle clientArea, List<? extends IFigure> figures, Rectangle[] constraints) {
        int x = clientArea.x;
        int y = -1;
        int prevY = -1;
        Rectangle nextConstraint = null;
        IFigure nextFigure = null;
        IFigure nextChildFigure = null;
        int i = 0;
        while (i < figures.size()) {
            IFigure figure = figures.get(i);
            FullStateFigure stateInvariantFigure = (FullStateFigure)FigureUtils.findChildFigureInstance((IFigure)figure, FullStateFigure.class);
            SmallSquareFigure smallSquareFigure = (SmallSquareFigure)FigureUtils.findChildFigureInstance((IFigure)figure, SmallSquareFigure.class);
            CrossFigure crossFigure = (CrossFigure)FigureUtils.findChildFigureInstance((IFigure)figure, CrossFigure.class);
            if (stateInvariantFigure != null || smallSquareFigure != null || crossFigure != null) {
                Rectangle constraint = constraints[i];
                nextConstraint = null;
                nextFigure = null;
                int j = i + 1;
                while (j < figures.size()) {
                    IFigure f = figures.get(j);
                    nextChildFigure = FigureUtils.findChildFigureInstance((IFigure)f, FullStateFigure.class);
                    if (nextChildFigure == null) {
                        nextChildFigure = FigureUtils.findChildFigureInstance((IFigure)f, SmallSquareFigure.class);
                    }
                    if (nextChildFigure == null) {
                        nextChildFigure = FigureUtils.findChildFigureInstance((IFigure)f, CrossFigure.class);
                    }
                    if (nextChildFigure != null) {
                        nextConstraint = constraints[j];
                        nextFigure = f;
                        break;
                    }
                    ++j;
                }
                PapyrusNodeFigure occurrenceFigure = null;
                if (smallSquareFigure != null) {
                    occurrenceFigure = smallSquareFigure;
                } else if (crossFigure != null) {
                    occurrenceFigure = crossFigure;
                }
                if (occurrenceFigure != null) {
                    int occurrenceY;
                    if (y == -1) {
                        if (nextChildFigure instanceof FullStateFigure) {
                            occurrenceY = CustomFullLifelineTimelineCompartmentEditPartCN.computeVerticalPosition(nextFigure, viewer);
                        } else {
                            Activator.log.warn("The Lifeline starts by an OccurrenceSpecification not followed by a StateInvariant");
                            occurrenceY = 10;
                        }
                    } else {
                        occurrenceY = y;
                    }
                    Dimension preferredSize = occurrenceFigure.getPreferredSize();
                    figure.setBounds(new Rectangle(constraint.x, occurrenceY - preferredSize.height / 2, preferredSize.width, preferredSize.height));
                    x = constraint.x + preferredSize.width;
                }
                if (stateInvariantFigure != null) {
                    int computedY = CustomFullLifelineTimelineCompartmentEditPartCN.computeVerticalPosition(figure, viewer);
                    stateInvariantFigure.setPosY(computedY);
                    prevY = y == -1 ? computedY : y;
                    y = computedY;
                    int width = nextConstraint != null ? nextConstraint.x - x : clientArea.width - x;
                    if (prevY == y) {
                        figure.setBounds(new Rectangle(x, y - 5, width, 10));
                    } else {
                        figure.setBounds(new Rectangle(x - 2 - 1, y - 5, width + 2 + 1, 10));
                    }
                    x += width;
                }
            }
            ++i;
        }
    }

    private static int computeVerticalPosition(IFigure stateInvariantFigure, EditPartViewer viewer) {
        Map visualPartMap = viewer.getVisualPartMap();
        CustomFullStateInvariantEditPartCN stateInvariantEditPart = (CustomFullStateInvariantEditPartCN)((Object)visualPartMap.get(stateInvariantFigure));
        View stateInvariantView = (View)stateInvariantEditPart.getModel();
        StateInvariant stateInvariant = (StateInvariant)stateInvariantView.getElement();
        String id = StateInvariantUtils.getStateInvariantId(stateInvariant);
        if (id == null) {
            Activator.log.error("null id for a StateInvariant", (Throwable)new Exception());
            return -1;
        }
        View lifelineView = StateDefinitionUtils.getParentLifelineView(stateInvariantView);
        View stateDefinition = StateDefinitionUtils.getStateDefinitionViewWithId(id, lifelineView);
        if (stateDefinition == null) {
            Activator.log.error("No StateDefinition found for the StateInvariant (id = " + id + ")", (Throwable)new Exception());
            return -1;
        }
        StateDefinitionEditPart stateDefinitionEditPart = (StateDefinitionEditPart)((Object)viewer.getEditPartRegistry().get(stateDefinition));
        IFigure stateDefinitionFigure = stateDefinitionEditPart.getFigure();
        Rectangle bounds = stateDefinitionFigure.getBounds();
        int parentY = stateDefinitionFigure.getParent().getClientArea().y;
        return bounds.y + bounds.height / 2 - parentY;
    }

    protected static void layoutVerticalLinesAndTimeElements(List<? extends IFigure> figures, Rectangle clientArea, Rectangle[] constraints) {
        IFigure previousFigure = null;
        IFigure nextFigure = null;
        int i = 0;
        while (i < figures.size()) {
            IFigure figure = figures.get(i);
            FullStateInvariantVerticalLineFigure verticalLineFigure = (FullStateInvariantVerticalLineFigure)FigureUtils.findChildFigureInstance((IFigure)figure, FullStateInvariantVerticalLineFigure.class);
            VerticalMarkFigure verticalMarkFigure = (VerticalMarkFigure)FigureUtils.findChildFigureInstance((IFigure)figure, VerticalMarkFigure.class);
            DimensioningArrowFigure dimensioningArrowFigure = (DimensioningArrowFigure)FigureUtils.findChildFigureInstance((IFigure)figure, DimensioningArrowFigure.class);
            GeneralOrderingHorizontalFigure generalOrderingHorizontalFigure = (GeneralOrderingHorizontalFigure)FigureUtils.findChildFigureInstance((IFigure)figure, GeneralOrderingHorizontalFigure.class);
            nextFigure = null;
            if (i < figures.size() - 1) {
                nextFigure = figures.get(i + 1);
            }
            Rectangle constraint = constraints[i];
            if (verticalLineFigure != null) {
                boolean showVerticalLine = false;
                if (nextFigure != null && previousFigure != null) {
                    Rectangle prev = previousFigure.getBounds();
                    int y = prev.y + prev.height / 2;
                    int x = prev.x + prev.width / 2;
                    Rectangle next = nextFigure.getBounds();
                    int y2 = next.y + next.height / 2;
                    int y1 = y;
                    int sign = (int)Math.signum(y2 - y1);
                    y1 += sign * (previousFigure.getBounds().height / 2);
                    if (y != y2) {
                        showVerticalLine = true;
                    }
                    int verticalLineBoxWidth = 10;
                    figure.setBounds(new Rectangle(x - 5, Math.min(y1, y2), 10, Math.abs(y2 - y1)));
                } else {
                    Activator.log.warn("VerticalLine not between two Figures");
                }
                figure.setVisible(showVerticalLine);
            } else if (verticalMarkFigure != null) {
                Dimension size = verticalMarkFigure.getPreferredSize();
                figure.setBounds(new Rectangle(constraint.x, constraint.y, size.width, size.height));
            } else if (dimensioningArrowFigure != null) {
                Dimension size = dimensioningArrowFigure.getPreferredSize();
                if (constraint.width == Integer.MAX_VALUE) {
                    figure.setBounds(new Rectangle(constraint.x, constraint.y, clientArea.width - constraint.x, size.height));
                } else {
                    figure.setBounds(new Rectangle(constraint.x, constraint.y, constraint.width, size.height));
                }
            } else if (generalOrderingHorizontalFigure != null) {
                Dimension size = generalOrderingHorizontalFigure.getPreferredSize();
                figure.setBounds(new Rectangle(constraint.x, constraint.y, constraint.width, size.height));
            }
            previousFigure = figure;
            ++i;
        }
    }
}

