/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 418466, 451350, 485756
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Typed Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.TypedElementImpl#getType <em>Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class TypedElementImpl
		extends NamedElementImpl
		implements TypedElement {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypedElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.TYPED_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getType() {
		return (Type) eDynamicGet(UMLPackage.TYPED_ELEMENT__TYPE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.TYPED_ELEMENT__TYPE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type basicGetType() {
		return (Type) eDynamicGet(UMLPackage.TYPED_ELEMENT__TYPE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.TYPED_ELEMENT__TYPE, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(Type newType) {
		eDynamicSet(UMLPackage.TYPED_ELEMENT__TYPE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.TYPED_ELEMENT__TYPE, newType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.TYPED_ELEMENT__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.TYPED_ELEMENT__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.TYPED_ELEMENT__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.TYPED_ELEMENT__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.TYPED_ELEMENT__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.TYPED_ELEMENT__NAME:
			return getName();
		case UMLPackage.TYPED_ELEMENT__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.TYPED_ELEMENT__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.TYPED_ELEMENT__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.TYPED_ELEMENT__VISIBILITY:
			return getVisibility();
		case UMLPackage.TYPED_ELEMENT__TYPE:
			if (resolve)
				return getType();
			return basicGetType();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.TYPED_ELEMENT__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.TYPED_ELEMENT__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.TYPED_ELEMENT__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.TYPED_ELEMENT__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.TYPED_ELEMENT__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.TYPED_ELEMENT__TYPE:
			setType((Type) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.TYPED_ELEMENT__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.TYPED_ELEMENT__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.TYPED_ELEMENT__NAME:
			unsetName();
			return;
		case UMLPackage.TYPED_ELEMENT__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.TYPED_ELEMENT__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.TYPED_ELEMENT__TYPE:
			setType((Type) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.TYPED_ELEMENT__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.TYPED_ELEMENT__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.TYPED_ELEMENT__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.TYPED_ELEMENT__OWNER:
			return isSetOwner();
		case UMLPackage.TYPED_ELEMENT__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.TYPED_ELEMENT__NAME:
			return isSetName();
		case UMLPackage.TYPED_ELEMENT__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.TYPED_ELEMENT__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.TYPED_ELEMENT__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.TYPED_ELEMENT__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.TYPED_ELEMENT__TYPE:
			return basicGetType() != null;
		}
		return eDynamicIsSet(featureID);
	}

} //TypedElementImpl
