/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 297216, 418466, 451350, 485756
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.OccurrenceSpecificationOperations;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Occurrence Specification</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.OccurrenceSpecificationImpl#getToAfters <em>To After</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.OccurrenceSpecificationImpl#getToBefores <em>To Before</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.OccurrenceSpecificationImpl#getCovereds <em>Covered</em>}</li>
 * </ul>
 *
 * @generated
 */
public class OccurrenceSpecificationImpl
		extends InteractionFragmentImpl
		implements OccurrenceSpecification {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OccurrenceSpecificationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.OCCURRENCE_SPECIFICATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<GeneralOrdering> getToBefores() {
		return (EList<GeneralOrdering>) eDynamicGet(UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.OCCURRENCE_SPECIFICATION__TO_BEFORE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeneralOrdering getToBefore(String name) {
		return getToBefore(name, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeneralOrdering getToBefore(String name, boolean ignoreCase) {
		toBeforeLoop: for (GeneralOrdering toBefore : getToBefores()) {
			if (name != null && !(ignoreCase ? name.equalsIgnoreCase(toBefore.getName()) : name.equals(toBefore.getName())))
				continue toBeforeLoop;
			return toBefore;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<GeneralOrdering> getToAfters() {
		return (EList<GeneralOrdering>) eDynamicGet(UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.OCCURRENCE_SPECIFICATION__TO_AFTER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeneralOrdering getToAfter(String name) {
		return getToAfter(name, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeneralOrdering getToAfter(String name, boolean ignoreCase) {
		toAfterLoop: for (GeneralOrdering toAfter : getToAfters()) {
			if (name != null && !(ignoreCase ? name.equalsIgnoreCase(toAfter.getName()) : name.equals(toAfter.getName())))
				continue toAfterLoop;
			return toAfter;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	@SuppressWarnings("unchecked")
	public EList<Lifeline> getCovereds() {
		return (EList<Lifeline>) eDynamicGet(UMLPackage.OCCURRENCE_SPECIFICATION__COVERED - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.INTERACTION_FRAGMENT__COVERED, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Lifeline getCovered(String name) {
		return getCovered(name, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Lifeline getCovered(String name, boolean ignoreCase) {
		coveredLoop: for (Lifeline covered : getCovereds()) {
			if (name != null && !(ignoreCase ? name.equalsIgnoreCase(covered.getName()) : name.equals(covered.getName())))
				continue coveredLoop;
			return covered;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetCovereds() {
		return !getCovereds().isEmpty();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Lifeline getCovered() {
		return OccurrenceSpecificationOperations.getCovered(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCovered(Lifeline value) {
		OccurrenceSpecificationOperations.setCovered(this, value);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION__EANNOTATIONS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getEAnnotations()).basicAdd(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__COVERED:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getCovereds()).basicAdd(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_OPERAND:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetEnclosingOperand((InteractionOperand) otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_INTERACTION:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetEnclosingInteraction((Interaction) otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getToAfters()).basicAdd(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getToBefores()).basicAdd(otherEnd, msgs);
		}
		return eDynamicInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME_EXPRESSION:
			return basicSetNameExpression(null, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__COVERED:
			return ((InternalEList<?>) getCovereds()).basicRemove(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_OPERAND:
			return basicSetEnclosingOperand(null, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_INTERACTION:
			return basicSetEnclosingInteraction(null, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__GENERAL_ORDERING:
			return ((InternalEList<?>) getGeneralOrderings()).basicRemove(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER:
			return ((InternalEList<?>) getToAfters()).basicRemove(otherEnd, msgs);
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE:
			return ((InternalEList<?>) getToBefores()).basicRemove(otherEnd, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.OCCURRENCE_SPECIFICATION__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME:
			return getName();
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.OCCURRENCE_SPECIFICATION__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.OCCURRENCE_SPECIFICATION__VISIBILITY:
			return getVisibility();
		case UMLPackage.OCCURRENCE_SPECIFICATION__COVERED:
			return getCovereds();
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_OPERAND:
			if (resolve)
				return getEnclosingOperand();
			return basicGetEnclosingOperand();
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_INTERACTION:
			if (resolve)
				return getEnclosingInteraction();
			return basicGetEnclosingInteraction();
		case UMLPackage.OCCURRENCE_SPECIFICATION__GENERAL_ORDERING:
			return getGeneralOrderings();
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER:
			return getToAfters();
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE:
			return getToBefores();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__COVERED:
			getCovereds().clear();
			getCovereds().addAll((Collection<? extends Lifeline>) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_OPERAND:
			setEnclosingOperand((InteractionOperand) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_INTERACTION:
			setEnclosingInteraction((Interaction) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__GENERAL_ORDERING:
			getGeneralOrderings().clear();
			getGeneralOrderings().addAll((Collection<? extends GeneralOrdering>) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER:
			getToAfters().clear();
			getToAfters().addAll((Collection<? extends GeneralOrdering>) newValue);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE:
			getToBefores().clear();
			getToBefores().addAll((Collection<? extends GeneralOrdering>) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME:
			unsetName();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__COVERED:
			getCovereds().clear();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_OPERAND:
			setEnclosingOperand((InteractionOperand) null);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_INTERACTION:
			setEnclosingInteraction((Interaction) null);
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__GENERAL_ORDERING:
			getGeneralOrderings().clear();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER:
			getToAfters().clear();
			return;
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE:
			getToBefores().clear();
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.OCCURRENCE_SPECIFICATION__OWNER:
			return isSetOwner();
		case UMLPackage.OCCURRENCE_SPECIFICATION__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME:
			return isSetName();
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.OCCURRENCE_SPECIFICATION__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.OCCURRENCE_SPECIFICATION__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.OCCURRENCE_SPECIFICATION__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.OCCURRENCE_SPECIFICATION__COVERED:
			return isSetCovereds();
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_OPERAND:
			return basicGetEnclosingOperand() != null;
		case UMLPackage.OCCURRENCE_SPECIFICATION__ENCLOSING_INTERACTION:
			return basicGetEnclosingInteraction() != null;
		case UMLPackage.OCCURRENCE_SPECIFICATION__GENERAL_ORDERING:
			return !getGeneralOrderings().isEmpty();
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_AFTER:
			return !getToAfters().isEmpty();
		case UMLPackage.OCCURRENCE_SPECIFICATION__TO_BEFORE:
			return !getToBefores().isEmpty();
		}
		return eDynamicIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Object eInvoke(int operationID, EList<?> arguments)
			throws InvocationTargetException {
		switch (operationID) {
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_EANNOTATION__STRING:
			return getEAnnotation((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___VALIDATE_HAS_OWNER__DIAGNOSTICCHAIN_MAP:
			return validateHasOwner((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___VALIDATE_NOT_OWN_SELF__DIAGNOSTICCHAIN_MAP:
			return validateNotOwnSelf((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___ADD_KEYWORD__STRING:
			return addKeyword((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___APPLY_STEREOTYPE__STEREOTYPE:
			return applyStereotype((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___CREATE_EANNOTATION__STRING:
			return createEAnnotation((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___DESTROY:
			destroy();
			return null;
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_KEYWORDS:
			return getKeywords();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_APPLICABLE_STEREOTYPE__STRING:
			return getApplicableStereotype((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_APPLICABLE_STEREOTYPES:
			return getApplicableStereotypes();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_APPLIED_STEREOTYPE__STRING:
			return getAppliedStereotype((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_APPLIED_STEREOTYPES:
			return getAppliedStereotypes();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_APPLIED_SUBSTEREOTYPE__STEREOTYPE_STRING:
			return getAppliedSubstereotype((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_APPLIED_SUBSTEREOTYPES__STEREOTYPE:
			return getAppliedSubstereotypes((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_MODEL:
			return getModel();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_NEAREST_PACKAGE:
			return getNearestPackage();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_RELATIONSHIPS:
			return getRelationships();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_RELATIONSHIPS__ECLASS:
			return getRelationships((EClass) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_REQUIRED_STEREOTYPE__STRING:
			return getRequiredStereotype((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_REQUIRED_STEREOTYPES:
			return getRequiredStereotypes();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_SOURCE_DIRECTED_RELATIONSHIPS:
			return getSourceDirectedRelationships();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_SOURCE_DIRECTED_RELATIONSHIPS__ECLASS:
			return getSourceDirectedRelationships((EClass) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_STEREOTYPE_APPLICATION__STEREOTYPE:
			return getStereotypeApplication((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_STEREOTYPE_APPLICATIONS:
			return getStereotypeApplications();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_TARGET_DIRECTED_RELATIONSHIPS:
			return getTargetDirectedRelationships();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_TARGET_DIRECTED_RELATIONSHIPS__ECLASS:
			return getTargetDirectedRelationships((EClass) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_VALUE__STEREOTYPE_STRING:
			return getValue((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___HAS_KEYWORD__STRING:
			return hasKeyword((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___HAS_VALUE__STEREOTYPE_STRING:
			return hasValue((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___IS_STEREOTYPE_APPLICABLE__STEREOTYPE:
			return isStereotypeApplicable((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___IS_STEREOTYPE_APPLIED__STEREOTYPE:
			return isStereotypeApplied((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___IS_STEREOTYPE_REQUIRED__STEREOTYPE:
			return isStereotypeRequired((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___REMOVE_KEYWORD__STRING:
			return removeKeyword((String) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___SET_VALUE__STEREOTYPE_STRING_OBJECT:
			setValue((Stereotype) arguments.get(0), (String) arguments.get(1), arguments.get(2));
			return null;
		case UMLPackage.OCCURRENCE_SPECIFICATION___UNAPPLY_STEREOTYPE__STEREOTYPE:
			return unapplyStereotype((Stereotype) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___ALL_OWNED_ELEMENTS:
			return allOwnedElements();
		case UMLPackage.OCCURRENCE_SPECIFICATION___MUST_BE_OWNED:
			return mustBeOwned();
		case UMLPackage.OCCURRENCE_SPECIFICATION___VALIDATE_VISIBILITY_NEEDS_OWNERSHIP__DIAGNOSTICCHAIN_MAP:
			return validateVisibilityNeedsOwnership((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___VALIDATE_HAS_QUALIFIED_NAME__DIAGNOSTICCHAIN_MAP:
			return validateHasQualifiedName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___VALIDATE_HAS_NO_QUALIFIED_NAME__DIAGNOSTICCHAIN_MAP:
			return validateHasNoQualifiedName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___CREATE_DEPENDENCY__NAMEDELEMENT:
			return createDependency((NamedElement) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___CREATE_USAGE__NAMEDELEMENT:
			return createUsage((NamedElement) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_LABEL:
			return getLabel();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_LABEL__BOOLEAN:
			return getLabel((Boolean) arguments.get(0));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_NAMESPACE:
			return getNamespace();
		case UMLPackage.OCCURRENCE_SPECIFICATION___ALL_NAMESPACES:
			return allNamespaces();
		case UMLPackage.OCCURRENCE_SPECIFICATION___ALL_OWNING_PACKAGES:
			return allOwningPackages();
		case UMLPackage.OCCURRENCE_SPECIFICATION___IS_DISTINGUISHABLE_FROM__NAMEDELEMENT_NAMESPACE:
			return isDistinguishableFrom((NamedElement) arguments.get(0), (Namespace) arguments.get(1));
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.OCCURRENCE_SPECIFICATION___SEPARATOR:
			return separator();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_CLIENT_DEPENDENCIES:
			return getClientDependencies();
		case UMLPackage.OCCURRENCE_SPECIFICATION___GET_COVERED:
			return getCovered();
		case UMLPackage.OCCURRENCE_SPECIFICATION___SET_COVERED__LIFELINE:
			setCovered((Lifeline) arguments.get(0));
			return null;
		}
		return eDynamicInvoke(operationID, arguments);
	}

} //OccurrenceSpecificationImpl
