/*
 * Copyright (c) 2018 CEA and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Eike Stepper - initial API and implementation
 */
package org.eclipse.uml2.uml.cdo.internal;

import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.uml2.uml.UMLPlugin;

/**
 * This is the central singleton for the UML CDO plugin.
 * 
 * @author Eike Stepper
 */
public final class UMLCDOPlugin
		extends EMFPlugin {

	public static final UMLCDOPlugin INSTANCE = new UMLCDOPlugin();

	private static Implementation plugin;

	public UMLCDOPlugin() {
		super(new ResourceLocator[]{UMLPlugin.INSTANCE});
	}

	@Override
	public ResourceLocator getPluginResourceLocator() {
		return plugin;
	}

	public static Implementation getPlugin() {
		return plugin;
	}

	public static class Implementation
			extends EclipsePlugin {

		public Implementation() {
			super();
			plugin = this;
		}
	}

}
