/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.internal.ui.importsources;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.views.CheckoutItemProvider;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.ui.SharedImages;
import org.eclipse.papyrus.cdo.uml.internal.ui.l10n.Messages;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.tools.importsources.AbstractPackageImportSource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class CDOPackageImportSource
extends AbstractPackageImportSource {
    private List<CDOCheckout> availableRepos;
    private CheckoutItemProvider itemProvider;

    public boolean canImportInto(Collection<?> selection) {
        boolean result = super.canImportInto(selection);
        if (result) {
            Package package_ = this.getPackage(selection);
            result = CDOUtils.isCDOObject((EObject)package_);
        }
        return result;
    }

    public void initialize(Collection<?> selection) {
        this.availableRepos = new ArrayList<CDOCheckout>();
        CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckout next = cDOCheckoutArray[n2];
            if (next.isOpen()) {
                this.availableRepos.add(next);
            }
            ++n2;
        }
        this.itemProvider = new CheckoutItemProvider(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
    }

    public void dispose() {
        this.availableRepos = null;
        this.itemProvider = null;
        super.dispose();
    }

    protected IStaticContentProvider createModelHierarchyContentProvider(Map<String, String> extensionFilters) {
        return new CDOContent();
    }

    protected ILabelProvider createModelHierarchyLabelProvider() {
        return new DelegatingLabelProvider((ILabelProvider)this.itemProvider){

            protected Image customGetImage(Object element) {
                Image result = null;
                if (element == CDOPackageImportSource.this) {
                    result = SharedImages.getImage((String)"papyrus_model");
                }
                return result;
            }

            protected String customGetText(Object element) {
                String result = null;
                if (element == CDOPackageImportSource.this) {
                    result = Messages.CDOPackageImportSource_0;
                }
                return result;
            }
        };
    }

    protected CDOResource getCDOResource(Object model) {
        CDOResource result = null;
        if (model instanceof CDOResource) {
            result = (CDOResource)model;
        } else if (model instanceof IAdaptable) {
            result = (CDOResource)((IAdaptable)model).getAdapter(CDOResource.class);
        }
        return result;
    }

    protected void validateSelection(Object model) throws CoreException {
        CDOResource cdo = this.getCDOResource(model);
        if (cdo == null) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.papyrus.cdo.uml.ui", NLS.bind((String)Messages.CDOPackageImportSource_1, (Object)this.getText(model))));
        }
        super.validateSelection(model);
    }

    public List<Package> getPackages(ResourceSet resourceSet, Object model) throws CoreException {
        ArrayList<Package> result;
        if (model instanceof DIModel) {
            result = new ArrayList(3);
            Object[] objectArray = ((DIModel)model).getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                if (next instanceof Resource) {
                    result.addAll(EcoreUtil.getObjectsByType((Collection)((Resource)next).getContents(), (EClassifier)UMLPackage.Literals.PACKAGE));
                }
                ++n2;
            }
        } else {
            result = super.getPackages(resourceSet, (Object)this.getCDOResource(model));
        }
        return result;
    }

    private class CDOContent
    extends StaticContentProvider
    implements ITreeContentProvider {
        private final Ordering<Object> sorter;

        CDOContent() {
            super(CDOPackageImportSource.this.availableRepos.toArray());
            this.sorter = new Ordering<Object>(){

                public int compare(Object left, Object right) {
                    String leftLabel = CDOPackageImportSource.this.getText(left);
                    String rightLabel = CDOPackageImportSource.this.getText(right);
                    return Ordering.natural().compare((Object)leftLabel, (Object)rightLabel);
                }
            };
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            CDOCheckoutManager repoMan = CDOExplorerUtil.getCheckoutManager();
            if (newInput == null) {
                CDOPackageImportSource.this.itemProvider.inputChanged(viewer, (Object)repoMan, null);
                super.inputChanged(viewer, (Object)repoMan, null);
            } else {
                CDOPackageImportSource.this.itemProvider.inputChanged(viewer, null, (Object)repoMan);
                CDOPackageImportSource.this.itemProvider.getElements((Object)repoMan);
                super.inputChanged(viewer, null, (Object)repoMan);
            }
        }

        public Object getParent(Object element) {
            return CDOPackageImportSource.this.itemProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return CDOPackageImportSource.this.itemProvider.hasChildren(element);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = CDOPackageImportSource.this.itemProvider.getChildren(parentElement);
            Arrays.sort(result, this.sorter);
            return result;
        }
    }
}

