/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.search.internal.ui.scope;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.views.search.scope.IScopeProvider;

public class CDOScopeProvider
implements IScopeProvider {
    public Collection<URI> getScope() {
        ArrayList result;
        CDOCheckout[] repos = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        if (repos.length == 0) {
            result = Collections.emptyList();
        } else {
            result = Lists.newArrayListWithCapacity((int)repos.length);
            CDOCheckout[] cDOCheckoutArray = repos;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView view;
                CDOCheckout next = cDOCheckoutArray[n2];
                if (next.isOpen() && (view = next.getView()) != null) {
                    result.add(view.getRootResource().getURI());
                }
                ++n2;
            }
        }
        return result;
    }

    public Collection<URI> getScope(Object selected) {
        List<Object> result;
        EObject obj;
        CDOResourceNode node = (CDOResourceNode)CDOUtils.adapt((Object)selected, CDOResourceNode.class);
        if (node == null && (obj = (EObject)CDOUtils.adapt((Object)selected, EObject.class)) != null) {
            node = (CDOResourceNode)CDOUtils.adapt((Object)obj.eResource(), CDOResource.class);
        }
        if (node == null) {
            result = Collections.emptyList();
        } else {
            URI uri = node.getURI();
            if (!node.isRoot() && node instanceof CDOResource) {
                if (!(uri = uri.trimFileExtension().appendFileExtension("uml")).equals(node.getURI())) {
                    String path = CDOURIUtil.extractResourcePath((URI)uri);
                    if (!node.cdoView().hasResource(path)) {
                        uri = null;
                    }
                }
            } else if (node instanceof CDOResourceFolder && !uri.hasTrailingPathSeparator()) {
                uri = uri.appendSegment("");
            }
            result = uri == null ? Collections.emptyList() : Collections.singletonList(uri);
        }
        return result;
    }
}

