/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.search.internal.ui.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.Activator;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.query.AttributeMatchStrategy;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.ModelElementMatch;
import org.eclipse.papyrus.views.search.scope.IScopeEntry;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class CDOPapyrusQuery
extends AbstractPapyrusQuery {
    private final String searchText;
    private final CDOView view;
    private final CDOQuery query;
    private final PapyrusSearchResult searchResult = new PapyrusSearchResult((AbstractPapyrusQuery)this);
    private final AttributeMatchStrategy attributeMatchStrategy;

    public CDOPapyrusQuery(String searchText, CDOView view, CDOQuery query, AttributeMatchStrategy attributeMatchStrategy) {
        this.searchText = searchText;
        this.view = view;
        this.query = query;
        this.attributeMatchStrategy = attributeMatchStrategy;
        view.addListener(this.createViewClosedListener());
    }

    public String getLabel() {
        return "Papyrus Model Repository Search";
    }

    public String getSearchQueryText() {
        return this.searchText;
    }

    public boolean canRerun() {
        return this.view != null && !this.view.isClosed();
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        IStatus result = Status.OK_STATUS;
        this.searchResult.removeAll();
        if (this.view.getSession().getPackageRegistry().getPackageInfo((EPackage)UMLPackage.eINSTANCE) != null) {
            List queryResult = this.query.getResult(Element.class);
            HashMap scopeEntries = Maps.newHashMap();
            int i = 0;
            while (i < queryResult.size()) {
                try {
                    Element next = (Element)queryResult.get(i);
                    Resource resource = next.eResource();
                    ResourceSet rset = resource.getResourceSet();
                    ServicesRegistry services = ServiceUtilsForResourceSet.getInstance().getServiceRegistry(rset);
                    ScopeEntry scopeEntry = (ScopeEntry)scopeEntries.get(resource.getURI());
                    if (scopeEntry == null) {
                        scopeEntry = new ScopeEntry(resource.getURI(), services);
                        scopeEntries.put(resource.getURI(), scopeEntry);
                    }
                    ModelElementMatch elementMatch = new ModelElementMatch((Object)next, (IScopeEntry)scopeEntry);
                    this.searchResult.addMatch((Match)elementMatch);
                    this.postProcessAttributeMatches(this.searchResult, (AbstractResultEntry)elementMatch, next);
                }
                catch (Exception e) {
                    Activator.log.error("Error retrieving resource result from CDO query.", (Throwable)e);
                }
                ++i;
            }
        }
        return result;
    }

    protected void postProcessAttributeMatches(PapyrusSearchResult searchResult, AbstractResultEntry elementMatch, Element element) {
        ArrayList attributeMatches = Lists.newArrayListWithExpectedSize((int)1);
        this.attributeMatchStrategy.apply(elementMatch, (EObject)element, attributeMatches);
        if (!attributeMatches.isEmpty()) {
            searchResult.addMatches((Match[])Iterables.toArray((Iterable)attributeMatches, Match.class));
        }
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    private IListener createViewClosedListener() {
        return new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                if (CDOPapyrusQuery.this.searchResult != null) {
                    CDOPapyrusQuery.this.searchResult.removeAll();
                }
            }
        };
    }
}

