/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.search.internal.ui.query;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.query.CDOSearchQueryProvider;
import org.eclipse.papyrus.uml.search.ui.query.QueryInfo;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AttributeMatchStrategy {
    protected final Matcher matcher;

    protected AttributeMatchStrategy(QueryInfo info) {
        String pattern = info.isRegularExpression() ? info.getQueryText() : Pattern.quote(info.getQueryText());
        int flags = info.isCaseSensitive() ? 0 : 2;
        this.matcher = Pattern.compile(pattern, flags).matcher("");
    }

    public static AttributeMatchStrategy create(QueryInfo info) {
        AttributeMatchStrategy result = info.isSearchAllStringAttributes() ? new AnyStringAttribute(info) : new NameOnly(info);
        return result;
    }

    public static AttributeMatchStrategy create(QueryInfo info, Multimap<EClass, EAttribute> attributes) {
        return new SpecificAttributes(info, attributes);
    }

    public abstract void apply(AbstractResultEntry var1, EObject var2, Collection<? super AttributeMatch> var3);

    protected void match(String value, EAttribute attribute, AbstractResultEntry parentMatch, EObject element, Collection<? super AttributeMatch> results) {
        this.matcher.reset(value);
        while (this.matcher.find()) {
            results.add((AttributeMatch)new AttributeMatch(parentMatch, this.matcher.start(), this.matcher.end() - this.matcher.start(), (Object)element, (Object)attribute, null));
        }
    }

    private static class AnyStringAttribute
    extends AttributeMatchStrategy {
        AnyStringAttribute(QueryInfo info) {
            super(info);
        }

        @Override
        public void apply(AbstractResultEntry parentMatch, EObject element, Collection<? super AttributeMatch> results) {
            for (EAttribute next : element.eClass().getEAllAttributes()) {
                Object value;
                if (!CDOSearchQueryProvider.isString((ETypedElement)next)) continue;
                if (!next.isMany()) {
                    value = (String)element.eGet((EStructuralFeature)next);
                    if (value == null) continue;
                    this.match((String)value, next, parentMatch, element, results);
                    continue;
                }
                value = (List)element.eGet((EStructuralFeature)next);
                this.match(value.toString(), next, parentMatch, element, results);
            }
        }
    }

    private static class NameOnly
    extends AttributeMatchStrategy {
        NameOnly(QueryInfo info) {
            super(info);
        }

        @Override
        public void apply(AbstractResultEntry parentMatch, EObject element, Collection<? super AttributeMatch> results) {
            String name;
            String string = name = element instanceof NamedElement ? ((NamedElement)element).getName() : null;
            if (name != null) {
                this.match(name, UMLPackage.Literals.NAMED_ELEMENT__NAME, parentMatch, element, results);
            }
        }
    }

    private static class SpecificAttributes
    extends AttributeMatchStrategy {
        private final Multimap<EClass, EAttribute> attributes;
        private final Set<EAttribute> seen = Sets.newHashSet();

        SpecificAttributes(QueryInfo info, Multimap<EClass, EAttribute> attributes) {
            super(info);
            this.attributes = attributes;
        }

        @Override
        public void apply(AbstractResultEntry parentMatch, EObject element, Collection<? super AttributeMatch> results) {
            this.seen.clear();
            this.apply(element.eClass(), parentMatch, element, results);
            for (EClass next : element.eClass().getEAllSuperTypes()) {
                this.apply(next, parentMatch, element, results);
            }
        }

        protected void apply(EClass eclass, AbstractResultEntry parentMatch, EObject element, Collection<? super AttributeMatch> results) {
            if (this.attributes.containsKey((Object)eclass)) {
                Collection attributes = this.attributes.get((Object)eclass);
                if (attributes.isEmpty()) {
                    attributes = eclass.getEAllAttributes();
                }
                for (EAttribute next : attributes) {
                    Object value;
                    if (!this.seen.add(next)) continue;
                    if (!next.isMany()) {
                        value = element.eGet((EStructuralFeature)next);
                        if (value == null) continue;
                        this.match(value.toString(), next, parentMatch, element, results);
                        continue;
                    }
                    value = (List)element.eGet((EStructuralFeature)next);
                    this.match(value.toString(), next, parentMatch, element, results);
                }
            }
        }
    }
}

