/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.cdo.core.exporter.IModelExportMapping;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferMappingListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.ModelTransferListenerAdapter;
import org.eclipse.papyrus.cdo.core.importer.ModelTransferMappingListenerAdapter;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.providers.ModelImportNodeLabelProvider;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelImportWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class ModelExportMappingsPage
extends ModelImportWizardPage {
    private static final String MESSAGE = Messages.ModelExportMappingsPage_0;
    private IModelTransferConfiguration exportConfig;
    private IModelTransferListener exportConfigListener;
    private CDOCheckout checkout;
    private IModelExportMapping mapping;
    private IModelTransferMappingListener mappingListener;
    private TableViewer mappingTable;
    private IContainer initialDestination;

    public ModelExportMappingsPage(EventBus bus) {
        super("mappings", Messages.ModelExportMappingsPage_2, null, bus, MESSAGE);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout());
        this.mappingTable = new TableViewer(result);
        this.mappingTable.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        TableViewerColumn column = new TableViewerColumn(this.mappingTable, 0);
        column.getColumn().setText(Messages.ModelExportMappingsPage_3);
        column.getColumn().setWidth(this.convertWidthInCharsToPixels(30));
        column = new TableViewerColumn(this.mappingTable, 0);
        column.getColumn().setText(Messages.ModelExportMappingsPage_4);
        column.getColumn().setWidth(this.convertWidthInCharsToPixels(45));
        column.setEditingSupport((EditingSupport)new MappingPathEditingSupport((ColumnViewer)this.mappingTable, 1));
        this.mappingTable.getTable().setHeaderVisible(true);
        this.mappingTable.getTable().setLinesVisible(true);
        this.mappingTable.setContentProvider((IContentProvider)new MappingContentProvider());
        this.mappingTable.setLabelProvider((IBaseLabelProvider)new MappingLabelProvider());
        if (this.exportConfig != null) {
            this.mappingTable.setInput((Object)this.exportConfig);
        }
        this.setControl((Control)result);
        this.validatePage();
    }

    public void dispose() {
        if (this.exportConfig != null) {
            this.exportConfig.removeModelTransferListener(this.getImportConfigListener());
        }
        this.exportConfig = null;
        super.dispose();
    }

    @Override
    protected Diagnostic doValidatePage() {
        return this.mapping == null ? Diagnostic.CANCEL_INSTANCE : this.mapping.validate();
    }

    public void setInitialDestination(IContainer container) {
        this.initialDestination = container;
    }

    public IModelExportMapping getMapping() {
        return this.mapping;
    }

    @Subscribe
    public void setConfiguration(IModelTransferConfiguration config) {
        this.exportConfig = config;
        if (config != null) {
            config.addModelTransferListener(this.getImportConfigListener());
        }
        this.setMapping(IModelExportMapping.Factory.DEFAULT.create(config));
        if (this.mappingTable != null) {
            this.mappingTable.setInput((Object)config);
        }
        this.validatePage();
    }

    private IModelTransferListener getImportConfigListener() {
        if (this.exportConfigListener == null) {
            this.exportConfigListener = new ModelTransferListenerAdapter(){

                public void modelsToTransferChanged(IModelTransferConfiguration configuration) {
                    if (ModelExportMappingsPage.this.mappingTable != null && !ModelExportMappingsPage.this.mappingTable.getControl().isDisposed()) {
                        ModelExportMappingsPage.this.mappingTable.refresh();
                    }
                    ModelExportMappingsPage.this.initializeMappings();
                }
            };
        }
        return this.exportConfigListener;
    }

    private void setMapping(IModelExportMapping mapping) {
        if (this.mapping != null) {
            this.mapping.removeModelTransferMappingListener(this.getMappingListener());
        }
        this.mapping = mapping;
        if (this.mapping != null) {
            this.mapping.addModelTransferMappingListener(this.getMappingListener());
            this.mapping.setCheckout(this.checkout);
            this.initializeMappings();
        }
    }

    private void initializeMappings() {
        if (this.initialDestination != null && this.mapping != null) {
            IPath basePath = this.initialDestination.getFullPath();
            for (IModelTransferNode next : this.exportConfig.getModelsToTransfer()) {
                if (this.mapping.getMapping(next) != null) continue;
                this.mapping.mapTo(next, basePath.append(next.getPrimaryResourceURI().lastSegment()));
            }
        }
    }

    private IModelTransferMappingListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new ModelTransferMappingListenerAdapter(){

                public void modelTransferMappingChanged(IModelTransferNode node) {
                    IPath mapping = ModelExportMappingsPage.this.mapping.getMapping(node);
                    if (mapping != null && ModelExportMappingsPage.this.mappingTable != null) {
                        ModelExportMappingsPage.this.mappingTable.refresh();
                    }
                }
            };
        }
        return this.mappingListener;
    }

    @Subscribe
    public void setRepository(CDOCheckout checkout) {
        this.checkout = checkout;
        if (this.mapping != null) {
            this.mapping.setCheckout(checkout);
        }
        this.validatePage();
    }

    private boolean setMapping(IModelTransferNode node, IPath path) {
        if (this.mapping != null && node != null) {
            this.mapping.mapTo(node, path);
        }
        this.validatePage();
        return true;
    }

    private static class MappingContentProvider
    implements IStructuredContentProvider {
        private MappingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((IModelTransferConfiguration)inputElement).getModelsToTransfer().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class MappingLabelProvider
    extends ModelImportNodeLabelProvider
    implements ITableLabelProvider {
        private MappingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 0 ? this.getImage(element) : null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = this.getText(element);
                    break;
                }
                case 1: {
                    IPath path;
                    if (ModelExportMappingsPage.this.mapping != null && (path = ModelExportMappingsPage.this.mapping.getMapping((IModelTransferNode)element)) != null) {
                        result = path.toString();
                    }
                    if (result != null) break;
                    result = "";
                }
            }
            return result;
        }
    }

    private class MappingPathEditingSupport
    extends EditingSupport {
        private DialogCellEditor editor;
        private final int columnIndex;

        MappingPathEditingSupport(ColumnViewer columnViewer, int columnIndex) {
            super(columnViewer);
            this.columnIndex = columnIndex;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.editor == null) {
                this.editor = new DialogCellEditor((Composite)this.getViewer().getControl()){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        ContainerSelectionDialog dlg = new ContainerSelectionDialog(cellEditorWindow.getShell(), null, true, Messages.ModelExportMappingsPage_6);
                        dlg.setTitle(Messages.ModelExportMappingsPage_7);
                        dlg.setHelpAvailable(false);
                        Object[] result = dlg.open() == 0 ? dlg.getResult() : null;
                        return result == null || result.length == 0 ? null : (IPath)result[0];
                    }
                };
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            IPath path = ModelExportMappingsPage.this.mapping.getMapping((IModelTransferNode)element);
            return path == null ? "" : path.removeLastSegments(1).toString();
        }

        protected void setValue(final Object element, Object value) {
            String name;
            IPath newPath;
            IPath iPath = newPath = value instanceof IPath ? (IPath)value : null;
            if (newPath != null && !ModelExportMappingsPage.this.setMapping((IModelTransferNode)element, newPath = newPath.append(name = ((IModelTransferNode)element).getPrimaryResourceURI().lastSegment()))) {
                this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MappingPathEditingSupport.this.getViewer().editElement(element, MappingPathEditingSupport.this.columnIndex);
                    }
                });
            }
        }
    }
}

