/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.base.Suppliers;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.wizards.CheckoutSelectionBlock;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelImportWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CheckoutSelectionPage
extends ModelImportWizardPage {
    private static final String MESSAGE = Messages.CheckoutSelectionPage_0;
    private CheckoutSelectionBlock checkoutSelectionBlock;
    private CDOCheckout checkout;

    public CheckoutSelectionPage(EventBus bus) {
        super("repository", Messages.CheckoutSelectionPage_2, null, bus, MESSAGE);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(1, false));
        new Label(result, 0).setText(Messages.CheckoutSelectionPage_3);
        this.checkoutSelectionBlock = new CheckoutSelectionBlock(this.getEventBus(), Suppliers.ofInstance((Object)this.getContainer())){

            @Override
            protected void selectionChanged() {
                super.selectionChanged();
                CheckoutSelectionPage.this.validatePage();
            }
        };
        this.checkoutSelectionBlock.createControl(result);
        if (this.checkout != null) {
            this.checkoutSelectionBlock.setSelectedCheckout(this.checkout);
        }
        this.setControl((Control)result);
        this.validatePage();
    }

    public void dispose() {
        this.checkoutSelectionBlock.dispose();
        super.dispose();
    }

    @Subscribe
    public void selected(CDOCheckout checkout) {
        this.checkout = checkout;
        if (this.checkoutSelectionBlock != null && this.checkoutSelectionBlock.getSelectedCheckout() != checkout) {
            this.checkoutSelectionBlock.setSelectedCheckout(checkout);
        }
    }

    @Override
    protected Diagnostic doValidatePage() {
        Diagnostic result = Diagnostic.CANCEL_INSTANCE;
        if (this.getSelectedCheckout() != null) {
            result = Diagnostic.OK_INSTANCE;
        }
        return result;
    }

    public CDOCheckout getSelectedCheckout() {
        return this.checkout;
    }
}

