/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.osgi.framework.Bundle;

class ItemProviderFilterRegistry {
    static final ItemProviderFilterRegistry INSTANCE = new ItemProviderFilterRegistry();
    private final Map<String, Filter> filters = Maps.newHashMap();

    private ItemProviderFilterRegistry() {
        new MyRegistryReader().readRegistry();
    }

    public Predicate<Object> createFilter(ILabelProvider labelProvider) {
        return new CompositeFilter(labelProvider);
    }

    final class CompositeFilter
    implements Predicate<Object> {
        private final ILabelProvider labelProvider;
        private final LabelWrapper labelWrapper = new LabelWrapper();

        CompositeFilter(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public boolean apply(Object input) {
            boolean result = true;
            if (!ItemProviderFilterRegistry.this.filters.isEmpty()) {
                this.labelWrapper.object = input;
                this.labelWrapper.label = this.labelProvider.getText(input);
                Iterator<Filter> iter = ItemProviderFilterRegistry.this.filters.values().iterator();
                while (result && iter.hasNext()) {
                    boolean bl = result = !iter.next().apply(this.labelWrapper);
                }
            }
            return result;
        }
    }

    static class ElementFilterFilter
    extends Filter {
        private final Supplier<? extends IElementFilter> filter;
        private boolean enabled = true;

        ElementFilterFilter(String id, Supplier<? extends IElementFilter> filter) {
            super(id);
            this.filter = filter;
        }

        public boolean apply(LabelWrapper input) {
            try {
                return this.enabled && ((IElementFilter)this.filter.get()).filter(input.object);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in element filter. Filter will be disabled.", (Throwable)e);
                this.enabled = false;
                return false;
            }
        }
    }

    static abstract class Filter
    implements Predicate<LabelWrapper> {
        final String id;

        Filter(String id) {
            this.id = id;
        }

        String getID() {
            return this.id;
        }
    }

    static class LabelPatternFilter
    extends Filter {
        private final Pattern pattern;

        LabelPatternFilter(String id, String pattern) {
            super(id);
            this.pattern = Pattern.compile(pattern);
        }

        public boolean apply(LabelWrapper input) {
            return input.label != null && this.pattern.matcher(input.label).find();
        }
    }

    static class LabelPatternFilterWithObjectClass
    extends LabelPatternFilter {
        private final Class<?> objectClass;
        private final boolean adapt;

        LabelPatternFilterWithObjectClass(String id, String pattern, Class<?> objectClass, boolean adapt) {
            super(id, pattern);
            this.objectClass = objectClass;
            this.adapt = adapt;
        }

        @Override
        public boolean apply(LabelWrapper input) {
            return this.adapts(input.object) && super.apply(input);
        }

        private boolean adapts(Object object) {
            return this.adapt ? CDOUtils.adapt((Object)object, this.objectClass) != null : this.objectClass.isInstance(object);
        }
    }

    static final class LabelWrapper {
        Object object;
        String label;

        LabelWrapper() {
        }
    }

    class MyRegistryReader
    extends RegistryReader {
        static final String EXT_PT = "repositoryFilters";
        static final String E_ITEM_PROVIDER_FILTER = "itemProviderFilter";
        static final String A_ID = "id";
        static final String E_LABEL_PATTERN = "labelPattern";
        static final String A_PATTERN = "pattern";
        static final String A_OBJECT_CLASS = "objectClass";
        static final String A_ADAPT = "adapt";
        static final String E_ELEMENT_FILTER = "elementFilter";
        static final String A_CLASS = "class";
        static final String A_SUPPLIER_CLASS = "supplierClass";
        static final String E_PREDICATE = "predicate";
        private String currentID;
        private IConfigurationElement currentConfig;

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.cdo.ui", EXT_PT);
        }

        protected boolean readElement(IConfigurationElement config, boolean add) {
            boolean result = true;
            String name = config.getName();
            if (E_ITEM_PROVIDER_FILTER.equals(name)) {
                String id = config.getAttribute(A_ID);
                if (id == null) {
                    result = false;
                    this.logMissingAttribute(config, A_ID);
                    this.currentID = null;
                    this.currentConfig = null;
                } else if (add) {
                    if (this.currentID != null) {
                        this.logError(this.currentConfig, String.format("Missing specification of filter %s.", this.currentID));
                    }
                    this.currentID = id;
                    this.currentConfig = config;
                } else if (id != null) {
                    this.removeFilter(id);
                }
            } else if (add) {
                if (this.currentID == null) {
                    result = false;
                    this.logError(config, String.format("Too many filter specifications.", new Object[0]));
                } else if (ItemProviderFilterRegistry.this.filters.containsKey(this.currentID)) {
                    result = false;
                    this.logError(config, String.format("Duplicate filter ID \"%s\".  The duplicate is ignored.", this.currentID));
                } else {
                    result = this.createFilter(config);
                }
            }
            return result;
        }

        void removeFilter(String id) {
            ItemProviderFilterRegistry.this.filters.remove(id);
        }

        boolean createFilter(IConfigurationElement config) {
            boolean result = false;
            String name = config.getName();
            if (E_LABEL_PATTERN.equals(name)) {
                result = this.createLabelPatternFilter(config);
            } else if (E_ELEMENT_FILTER.equals(name)) {
                result = this.createElementFilterFilter(config);
            } else if (E_PREDICATE.equals(name)) {
                result = this.createPredicateFilter(config);
            }
            return result;
        }

        private void addFilter(Filter filter) {
            ItemProviderFilterRegistry.this.filters.put(this.currentID, filter);
            this.currentID = null;
            this.currentConfig = null;
        }

        boolean createLabelPatternFilter(IConfigurationElement config) {
            boolean result = true;
            String pattern = config.getAttribute(A_PATTERN);
            if (pattern == null) {
                this.logMissingAttribute(config, A_PATTERN);
                result = false;
            } else {
                Class objectClass = null;
                String className = config.getAttribute(A_OBJECT_CLASS);
                if (className != null) {
                    String bundleID = config.getContributor().getName();
                    try {
                        Bundle bundle = Platform.getBundle((String)bundleID);
                        objectClass = bundle.loadClass(className);
                    }
                    catch (Exception e) {
                        result = false;
                        this.logError(config, String.format("Could not find class \"%s\" in bundle \"%s\".", className, bundleID));
                    }
                }
                if (result) {
                    try {
                        if (objectClass == null) {
                            this.addFilter(new LabelPatternFilter(this.currentID, pattern));
                        } else {
                            boolean adapt = false;
                            String adaptAttr = config.getAttribute(A_ADAPT);
                            if (adaptAttr != null) {
                                adapt = Boolean.parseBoolean(adaptAttr);
                            }
                            this.addFilter(new LabelPatternFilterWithObjectClass(this.currentID, pattern, objectClass, adapt));
                        }
                    }
                    catch (Exception e) {
                        result = false;
                        Activator.log.error((Throwable)e);
                        this.logError(config, String.format("Failed to initialize filter on pattern \"%s\".", pattern));
                    }
                }
            }
            return result;
        }

        boolean createElementFilterFilter(IConfigurationElement config) {
            boolean result = true;
            String className = config.getAttribute(A_CLASS);
            String supplierClassName = config.getAttribute(A_SUPPLIER_CLASS);
            if (className == null && supplierClassName == null) {
                result = false;
                this.logMissingAttribute(config, A_CLASS);
            } else if (className != null) {
                try {
                    Object extension = config.createExecutableExtension(A_CLASS);
                    if (!(extension instanceof IElementFilter)) {
                        result = false;
                        this.logError(config, String.format("Extension is not an IElementFilter: %s", extension.getClass().getName()));
                    }
                    this.addFilter(new ElementFilterFilter(this.currentID, (Supplier<? extends IElementFilter>)Suppliers.ofInstance((Object)((IElementFilter)extension))));
                }
                catch (CoreException e) {
                    result = false;
                    Activator.log.error((Throwable)e);
                }
            } else {
                try {
                    Object extension = config.createExecutableExtension(A_CLASS);
                    if (!(extension instanceof Supplier)) {
                        result = false;
                        this.logError(config, String.format("Extension is not a Supplier<? extends IElementFilter>: %s", extension.getClass().getName()));
                    }
                    Supplier supplier = (Supplier)extension;
                    this.addFilter(new ElementFilterFilter(this.currentID, (Supplier<? extends IElementFilter>)Suppliers.memoize((Supplier)supplier)));
                }
                catch (CoreException e) {
                    result = false;
                    Activator.log.error((Throwable)e);
                }
            }
            return result;
        }

        boolean createPredicateFilter(IConfigurationElement config) {
            boolean result = true;
            String className = config.getAttribute(A_CLASS);
            String supplierClassName = config.getAttribute(A_SUPPLIER_CLASS);
            if (className == null && supplierClassName == null) {
                result = false;
                this.logMissingAttribute(config, A_CLASS);
            } else if (className != null) {
                try {
                    Object extension = config.createExecutableExtension(A_CLASS);
                    if (!(extension instanceof Predicate)) {
                        result = false;
                        this.logError(config, String.format("Extension is not a Predicate<Object>: %s", extension.getClass().getName()));
                    }
                    Predicate predicate = (Predicate)extension;
                    this.addFilter(new PredicateFilter(this.currentID, (Supplier<? extends Predicate<Object>>)Suppliers.ofInstance((Object)predicate)));
                }
                catch (CoreException e) {
                    result = false;
                    Activator.log.error((Throwable)e);
                }
            } else {
                try {
                    Object extension = config.createExecutableExtension(A_CLASS);
                    if (!(extension instanceof Supplier)) {
                        result = false;
                        this.logError(config, String.format("Extension is not a Supplier<? extends Predicate<Object>>: %s", extension.getClass().getName()));
                    }
                    Supplier supplier = (Supplier)extension;
                    this.addFilter(new PredicateFilter(this.currentID, (Supplier<? extends Predicate<Object>>)Suppliers.memoize((Supplier)supplier)));
                }
                catch (CoreException e) {
                    result = false;
                    Activator.log.error((Throwable)e);
                }
            }
            return result;
        }
    }

    static class PredicateFilter
    extends Filter {
        private final Supplier<? extends Predicate<Object>> predicate;
        private boolean enabled = true;

        PredicateFilter(String id, Supplier<? extends Predicate<Object>> predicate) {
            super(id);
            this.predicate = predicate;
        }

        public boolean apply(LabelWrapper input) {
            try {
                return this.enabled && ((Predicate)this.predicate.get()).apply(input.object);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in predicate. Filter will be disabled.", (Throwable)e);
                this.enabled = false;
                return false;
            }
        }
    }
}

