/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.util.CompositeLabelProvider;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.ui.providers.PapyrusLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModelImportNodeLabelProvider
implements ILabelProvider {
    private final ILabelProvider delegate = new CompositeLabelProvider((ILabelProvider)new PapyrusLabelProvider(), new ILabelProvider[]{new WorkbenchLabelProvider()});

    public Image getImage(Object element) {
        Image result = null;
        IModelTransferNode model = this.getModelImportNode(element);
        if (model != null) {
            result = this.delegate.getImage(this.getWorkbenchObject(model));
        }
        return result;
    }

    protected IModelTransferNode getModelImportNode(Object element) {
        return element instanceof IModelTransferNode ? (IModelTransferNode)element : null;
    }

    public String getText(Object element) {
        String result = null;
        IModelTransferNode model = this.getModelImportNode(element);
        if (model != null && (result = this.delegate.getText(this.getWorkbenchObject(model))) == null) {
            result = model.getPrimaryResourceURI().trimFileExtension().lastSegment();
        }
        return result;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegate.removeListener(listener);
    }

    Object getWorkbenchObject(IModelTransferNode element) {
        Object result = element;
        URI uri = element.getPrimaryResourceURI();
        if (CDOUtils.isCDOURI((URI)uri)) {
            uri = URI.createPlatformResourceURI((String)(String.valueOf(uri.authority()) + uri.path()), (boolean)true);
        }
        if (uri.isPlatformResource()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            result = file != null && PapyrusModelHelper.getPapyrusModelFactory().isDi((IResource)file) ? PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(file) : file;
        }
        return result;
    }
}

