/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareModelSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.internal.ui.dnd.CDOResourceURITransferData;
import org.eclipse.papyrus.cdo.internal.ui.editors.DawnEditorAdapter;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusGMFEditorSupport;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.DefaultGraphicalEditorSupport;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IConflictingEditPartFilter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusDiagramEditPart;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class DawnGraphicalEditorSupport
extends DefaultGraphicalEditorSupport {
    private final ServicesRegistry registry;

    public DawnGraphicalEditorSupport(ServicesRegistry registry) {
        this.registry = registry;
    }

    public void initialize(GraphicalEditor editor) {
        if (editor instanceof DiagramDocumentEditor) {
            DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
            CDOView view = this.getCDOView();
            if (view != null) {
                this.initialize(diagramEditor, view);
            }
            this.initializeCDOResourceDropSupport(diagramEditor);
        }
        super.initialize(editor);
    }

    protected void initialize(final DiagramDocumentEditor diagramEditor, CDOView view) {
        DawnEditorAdapter adapter = new DawnEditorAdapter(diagramEditor);
        final PapyrusGMFEditorSupport dawnSupport = new PapyrusGMFEditorSupport(adapter);
        adapter.setEditorSupport((IDawnEditorSupport)dawnSupport);
        adapter.setView(this.getCDOView());
        dawnSupport.setView(adapter.getView());
        UIUtil.later(new Runnable(){

            @Override
            public void run() {
                DiagramEditPart diagramEP = diagramEditor.getDiagramEditPart();
                if (diagramEP instanceof PapyrusDiagramEditPart) {
                    ((PapyrusDiagramEditPart)diagramEP).setConflictingEditPartFilter(DawnGraphicalEditorSupport.this.createConflictingEditPartFilter());
                }
            }
        });
        dawnSupport.registerListeners();
        UIUtil.later(new Runnable(){

            @Override
            public void run() {
                Map<Object, DawnState> remoteLocks = DawnGraphicalEditorSupport.this.getRemoteLocks(diagramEditor);
                if (!remoteLocks.isEmpty()) {
                    dawnSupport.handleRemoteLockChanges(remoteLocks);
                    for (Object next : remoteLocks.keySet()) {
                        EObject element = CDOUtil.getEObject((EObject)((CDOObject)next));
                        View view = DawnDiagramUpdater.findViewByContainer((EObject)element);
                        CDOStateAdapter.setState((Notifier)view, remoteLocks.get(next));
                    }
                }
            }
        });
    }

    CDOView getCDOView() {
        CDOView result = null;
        try {
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            if (modelSet instanceof CDOAwareModelSet) {
                result = ((CDOAwareModelSet)modelSet).getCDOView();
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    private Map<Object, DawnState> getRemoteLocks(DiagramDocumentEditor diagramEditor) {
        HashMap result = Maps.newHashMap();
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram != null) {
            TreeIterator treeIterator = EcoreUtil.getAllProperContents(Collections.singleton(diagram), (boolean)false);
        }
        return result;
    }

    private IConflictingEditPartFilter createConflictingEditPartFilter() {
        return new IConflictingEditPartFilter(){

            public boolean isConflicting(EditPart editPart) {
                Object model = editPart.getModel();
                return model instanceof EObject && DawnConflictHelper.isConflicted((EObject)((EObject)model));
            }
        };
    }

    protected void initializeCDOResourceDropSupport(final DiagramDocumentEditor diagramEditor) {
        UIUtil.later(new Runnable(){

            @Override
            public void run() {
                IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
                viewer.addDropTargetListener(DawnGraphicalEditorSupport.this.createCDOResourceURIDropTargetListener((EditPartViewer)viewer));
            }
        });
    }

    private TransferDropTargetListener createCDOResourceURIDropTargetListener(EditPartViewer viewer) {
        return new DiagramDropTargetListener(viewer, (Transfer)PluginTransfer.getInstance()){

            protected boolean isDataTransfered() {
                return this.getCurrentEvent().data != null;
            }

            protected List<EObject> getObjectsBeingDropped() {
                PluginTransferData ptData;
                Object data;
                List<EObject> result = null;
                CDOResourceURITransferData uriData = null;
                if (PluginTransfer.getInstance().isSupportedType(this.getCurrentEvent().currentDataType) && !DawnGraphicalEditorSupport.this.localTransferHasObjectFromThisRepo() && (data = this.getCurrentEvent().data) instanceof PluginTransferData && "org.eclipse.papyrus.cdo.ui.modelDropAction".equals((ptData = (PluginTransferData)data).getExtensionId())) {
                    uriData = CDOResourceURITransferData.deserialize(ptData.getData());
                }
                result = uriData == null ? Collections.emptyList() : Collections.singletonList(uriData.asEObject());
                return result;
            }
        };
    }

    boolean localTransferHasObjectFromThisRepo() {
        IStructuredSelection sel;
        boolean result = false;
        CDOView view = this.getCDOView();
        if (view != null && (sel = (IStructuredSelection)CDOUtils.tryCast((Object)LocalSelectionTransfer.getTransfer().getSelection(), IStructuredSelection.class)) != null && !sel.isEmpty()) {
            for (EObject next : Iterables.filter((Iterable)sel.toList(), EObject.class)) {
                CDOObject cdo = CDOUtils.getCDOObject((EObject)next);
                if (cdo == null || cdo.cdoView().getSession() != view.getSession()) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

