/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnDefaultElementStylizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateLabelDecorator;
import org.eclipse.papyrus.cdo.ui.SharedImages;
import org.eclipse.swt.graphics.Image;

public class PapyrusElementStylizer
extends DawnDefaultElementStylizer {
    public Image getImage(Object element, DawnState state) {
        return switch (state) {
            case DawnState.LOCKED_LOCALLY -> SharedImages.getImage("self_locked_ovr16");
            case DawnState.LOCKED_REMOTELY -> SharedImages.getImage("other_locked_ovr16");
            case DawnState.CONFLICT -> SharedImages.getImage("conflicted_ovr16");
            default -> super.getImage(element, state);
        };
    }

    public void setDefault(Object element) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.setState(eObject, DawnState.CLEAN);
        }
    }

    public void setConflicted(Object element, int type) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.setState(eObject, DawnState.CONFLICT);
        }
    }

    public void setLocked(Object element, int type) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.setState(eObject, switch (type) {
                case 4 -> DawnState.LOCKED_REMOTELY;
                case 3 -> DawnState.LOCKED_LOCALLY;
                default -> DawnState.LOCKED_REMOTELY;
            });
        }
    }

    protected void setState(EObject object, DawnState state) {
        CDOStateAdapter.setState((Notifier)object, state);
        CDOStateLabelDecorator.fireLabelUpdates();
    }
}

