/*****************************************************************************
 * Copyright (c) 2013, 2017 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.cdo.internal.ui.editors;

import org.eclipse.papyrus.infra.core.services.IServiceFactory;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;


/**
 * This is the DawnGraphicalEditorSupportServiceFactory type. Enjoy.
 */
public class DawnGraphicalEditorSupportServiceFactory
		implements IServiceFactory {

	private ServicesRegistry registry;

	private DawnGraphicalEditorSupport service;

	public DawnGraphicalEditorSupportServiceFactory() {
		super();
	}

	@Override
	public void init(ServicesRegistry servicesRegistry)
			throws ServiceException {

		this.registry = servicesRegistry;
	}

	@Override
	public void startService()
			throws ServiceException {

		// pass
	}

	@Override
	public void disposeService()
			throws ServiceException {

		if (service == null) {
			// TODO clean up?
		}
	}

	@Override
	public Object createServiceInstance()
			throws ServiceException {

		service = new DawnGraphicalEditorSupport(registry);
		return service;
	}

}
