/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.security.internal.ui;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesDisplayHelper;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CDOUserDialog
extends SelectionDialog {
    private Composite propertiesComposite;
    private DisplayEngine displayEngine;
    private Collection<User> users;

    public CDOUserDialog(Shell parentShell, User user) {
        this(parentShell, Collections.singletonList(user));
    }

    public CDOUserDialog(Shell parentShell, Collection<User> users) {
        super(parentShell);
        this.users = users;
    }

    public void create() {
        super.create();
        if (this.getShell().getText() == null || this.getShell().getText().isEmpty()) {
            this.getShell().setText("Edit User");
        }
        this.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CDOUserDialog.this.dispose();
            }
        });
        Composite parent = new Composite(this.getDialogArea(), 0);
        parent.setLayout((Layout)new PropertiesLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPropertiesGroup(parent);
        if (this.users.size() == 1) {
            this.displayElement(this.users.iterator().next());
        } else {
            this.displayElement(this.users);
        }
        this.getShell().pack();
    }

    public Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    protected void createPropertiesGroup(Composite parent) {
        this.propertiesComposite = new Composite(parent, 0);
        PropertiesLayout layout = new PropertiesLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.propertiesComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 500;
        data.widthHint = 1000;
        this.propertiesComposite.setLayoutData((Object)data);
    }

    protected void displayElement(Object object) {
        if (this.displayEngine != null) {
            this.displayEngine.removeSection(this.propertiesComposite);
        }
        if (object instanceof Collection) {
            TreePath[] treePaths = new TreePath[((Collection)object).size()];
            int currentIt = 0;
            for (Object obj : (Collection)object) {
                Object[] objArray = new Object[]{obj};
                treePaths[currentIt++] = new TreePath(objArray);
            }
            TreeSelection treeSelection = new TreeSelection(treePaths);
            this.displayEngine = PropertiesDisplayHelper.display((ConstraintEngine)PropertiesRuntime.getConstraintEngine(), (ISelection)treeSelection, (Composite)this.propertiesComposite);
        } else {
            this.displayEngine = PropertiesDisplayHelper.display((Object)object, (Composite)this.propertiesComposite);
        }
        this.propertiesComposite.layout();
        this.propertiesComposite.getParent().layout();
        this.propertiesComposite.getParent().pack();
        this.getShell().layout();
    }

    public void dispose() {
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
        }
        this.displayEngine = null;
        this.propertiesComposite = null;
    }
}

