/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.security.handlers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.security.internal.ui.CDOUserDialog;
import org.eclipse.papyrus.infra.ui.util.SelectionHelper;
import org.eclipse.swt.widgets.Display;

public class EditUserHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection<User> users = EditUserHandler.getSelectedUsers();
        if (users.size() > 0) {
            new CDOUserDialog(Display.getDefault().getActiveShell(), users).open();
        }
        return null;
    }

    private static Collection<User> getSelectedUsers() {
        HashSet<User> users = new HashSet<User>();
        IStructuredSelection selection = SelectionHelper.getCurrentStructuredSelection();
        for (Object current : selection) {
            if (!(current instanceof User)) continue;
            users.add((User)current);
        }
        return users;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(EditUserHandler.isValidSelection());
    }

    public static boolean isValidSelection() {
        return EditUserHandler.getSelectedUsers().size() > 0;
    }
}

