/*****************************************************************************
 * Copyright (c) 2019 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.cdo.security.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.security.internal.ui.CDOUserDialog;
import org.eclipse.papyrus.infra.ui.util.SelectionHelper;
import org.eclipse.swt.widgets.Display;

public class EditUserHandler extends AbstractHandler {


	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		final Collection<User> users = getSelectedUsers();
		if (users.size() > 0) {
			new CDOUserDialog(Display.getDefault().getActiveShell(), users).open();
		}
		return null;
	}

	/**
	 *
	 * @return
	 *         the list of selected user
	 */
	private static Collection<User> getSelectedUsers() {
		final Collection<User> users = new HashSet<>();
		final IStructuredSelection selection = SelectionHelper.getCurrentStructuredSelection();
		final Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			final Object current = iter.next();
			if (current instanceof User) {
				users.add((User) current);
			}
		}
		return users;
	}


	/**
	 *
	 * @see org.eclipse.core.commands.AbstractHandler#setEnabled(java.lang.Object)
	 *
	 * @param evaluationContext
	 */
	@Override
	public void setEnabled(Object evaluationContext) {
		setBaseEnabled(isValidSelection());
	}

	public static boolean isValidSelection() {
		return getSelectedUsers().size() > 0;
	}


}
