/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.cdo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.compare.CDOCompare;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;

public class UMLCDOMatchEngine
extends CDOCompare.CDOMatchEngine {
    public UMLCDOMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        super(matcher, comparisonFactory);
    }

    public Comparison match(IComparisonScope scope, Monitor monitor) {
        Comparison result = super.match(scope, monitor);
        this.matchUMLBaseElements(scope, result, monitor);
        return result;
    }

    public void matchUMLBaseElements(IComparisonScope scope, Comparison comparison, Monitor monitor) {
        HashSet<EObject> leftElements = new HashSet<EObject>();
        HashSet<EObject> rightElements = new HashSet<EObject>();
        HashSet<EObject> originElements = new HashSet<EObject>();
        Comparison tempComparison = CompareFactory.eINSTANCE.createComparison();
        CDOCompare.CDOMatcher matcher = (CDOCompare.CDOMatcher)this.getEObjectMatcher();
        for (Match match : comparison.getMatches()) {
            this.collectBaseElementAndParents(match, leftElements, rightElements, originElements);
            for (Match subMatch : match.getAllSubmatches()) {
                this.collectBaseElementAndParents(subMatch, leftElements, rightElements, originElements);
            }
            matcher.createMatches(tempComparison, leftElements.iterator(), rightElements.iterator(), originElements.iterator(), monitor);
        }
        if (!tempComparison.getMatches().isEmpty()) {
            this.mergeMatches(comparison, tempComparison);
            scope.getNsURIs().add("http://www.eclipse.org/uml2/5.0.0/UML");
        }
    }

    private void mergeMatches(Comparison receivingComparison, Comparison newComparison) {
        HashMap<Match, EList> matchToReceiver = new HashMap<Match, EList>();
        for (Match match : newComparison.getMatches()) {
            EObject matchRootObject = match.getLeft();
            if (matchRootObject == null) {
                matchRootObject = match.getRight();
            }
            if (matchRootObject == null) {
                matchRootObject = match.getOrigin();
            }
            if (matchRootObject == null) continue;
            EObject parent = this.getParentOf(matchRootObject);
            Match parentMatch = null;
            if (parent != null) {
                parentMatch = receivingComparison.getMatch(parent);
            }
            if (parentMatch != null) {
                matchToReceiver.put(match, parentMatch.getSubmatches());
                continue;
            }
            matchToReceiver.put(match, receivingComparison.getMatches());
        }
        for (Map.Entry entry : matchToReceiver.entrySet()) {
            ((List)entry.getValue()).add((Match)entry.getKey());
        }
    }

    protected EObject getParentOf(EObject eObject) {
        return CDOElement.getParentOf((EObject)eObject);
    }

    private void collectBaseElementAndParents(Match match, Set<EObject> leftElements, Set<EObject> rightElements, Set<EObject> originElements) {
        Comparison comparison = match.getComparison();
        this.addBaseElementAndParents(leftElements, comparison, match.getLeft());
        this.addBaseElementAndParents(rightElements, comparison, match.getRight());
        this.addBaseElementAndParents(originElements, comparison, match.getOrigin());
    }

    private void addBaseElementAndParents(Set<EObject> receivingSetOfElements, Comparison comparison, EObject application) {
        Element baseElement;
        if (application != null && !(application instanceof Element) && (baseElement = UMLCompareUtil.getBaseElement((EObject)application)) != null && comparison.getMatch((EObject)baseElement) == null) {
            receivingSetOfElements.add((EObject)baseElement);
            EObject container = this.getParentOf((EObject)baseElement);
            Match containerMatch = null;
            while (container != null && containerMatch == null) {
                containerMatch = comparison.getMatch(container);
                if (containerMatch == null) {
                    receivingSetOfElements.add(container);
                }
                container = this.getParentOf(container);
            }
        }
    }

    public static class Factory
    extends CDOCompare.CDOMatchEngine.Factory {
        protected CDOCompare.CDOMatchEngine createMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
            return new UMLCDOMatchEngine(matcher, comparisonFactory);
        }
    }
}

