/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.perspectives.debug;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class MokaDebugPerspective
implements IPerspectiveFactory {
    public static final String ID = "org.eclipse.papyrus.moka.ui.debug.perspectives.moka.debug";
    private static final String USER_FEEDBACK_FOLDER = "USER_FEEDBACK_FOLDER";
    private static final String USER_ANIMATION_CONTROL_FOLDER = "USER_ANIMATION_CONTROL_FOLDER";
    private static final String DEBUG_VIEW_FOLDER = "DEBUG_VIEW_FOLDER";
    private static final String DEBUG_VARIABLE_FOLDER = "DEBUG_VARIABLE_FOLDER";
    private static final String DEBUG_OTHER_FOLDER = "DEBUG_OTHER_FOLDER";

    public void createInitialLayout(IPageLayout layout) {
        this.buildProblemReport(layout);
        this.buildAnimationControl(layout);
        this.buildDebugControl(layout);
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
    }

    public void buildDebugControl(IPageLayout relative) {
        IFolderLayout debugViewFolder = relative.createFolder(DEBUG_VIEW_FOLDER, 3, 0.3f, relative.getEditorArea());
        debugViewFolder.addView("org.eclipse.debug.ui.DebugView");
        IFolderLayout debugVariableFolder = relative.createFolder(DEBUG_VARIABLE_FOLDER, 2, 0.4f, DEBUG_VIEW_FOLDER);
        debugVariableFolder.addView("org.eclipse.debug.ui.VariableView");
        IFolderLayout debugOtherFolder = relative.createFolder(DEBUG_OTHER_FOLDER, 2, 0.6f, DEBUG_VARIABLE_FOLDER);
        debugOtherFolder.addView("org.eclipse.debug.ui.BreakpointView");
        debugOtherFolder.addView("org.eclipse.papyrus.moka.ui.tracepoint.view.Tracepoints");
    }

    public void buildProblemReport(IPageLayout relative) {
        IFolderLayout userFeedbackFolder = relative.createFolder(USER_FEEDBACK_FOLDER, 4, 0.8f, relative.getEditorArea());
        userFeedbackFolder.addView("org.eclipse.ui.console.ConsoleView");
        userFeedbackFolder.addView("org.eclipse.ui.views.ProblemView");
    }

    public void buildAnimationControl(IPageLayout relative) {
        IFolderLayout userAnimationControlFolder = relative.createFolder(USER_ANIMATION_CONTROL_FOLDER, 2, 0.6f, USER_FEEDBACK_FOLDER);
        userAnimationControlFolder.addView("org.eclipse.papyrus.moka.ui.views.MokaAnimationView");
    }
}

