/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.breakpoint.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.debug.breakpoint.MokaBreakpoint;
import org.eclipse.papyrus.moka.ui.breakpoint.commands.AbstractTraceAndDebugCommand;

public class ToggleBreakpointActivationCommand
extends AbstractTraceAndDebugCommand {
    public ToggleBreakpointActivationCommand(EObject selectedElement) {
        super("Toggle breakpoint activation", TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement);
    }

    public CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String selectedElementURI = EcoreUtil.getURI((EObject)this.selectedElement).toString();
        if (this.selectedElement != null) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.papyrus.moka.debug");
            MokaBreakpoint alreadyDefinedBreakpoint = null;
            int i = 0;
            while (i < breakpoints.length && alreadyDefinedBreakpoint == null) {
                MokaBreakpoint breakpoint = (MokaBreakpoint)breakpoints[i];
                URI uriOfEObjectOfBreakpoint = breakpoint.getModelElementURI();
                if (uriOfEObjectOfBreakpoint != null && uriOfEObjectOfBreakpoint.toString().equals(selectedElementURI)) {
                    alreadyDefinedBreakpoint = breakpoint;
                }
                ++i;
            }
            if (alreadyDefinedBreakpoint != null) {
                try {
                    boolean enabledOrDisabled = !alreadyDefinedBreakpoint.isEnabled();
                    alreadyDefinedBreakpoint.setEnabled(enabledOrDisabled);
                    DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(alreadyDefinedBreakpoint);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return null;
        }
        return null;
    }
}

