/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.simpleclassifiers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IStructuredValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.values.Value;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class StructuredValue
extends Value
implements IStructuredValue {
    @Override
    public ValueSpecification specify() {
        InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
        InstanceSpecification instance = UMLFactory.eINSTANCE.createInstanceSpecification();
        instanceValue.setType(null);
        instanceValue.setInstance(instance);
        instance.getClassifiers().addAll(this.getTypes());
        List<IFeatureValue> featureValues = this.getFeatureValues();
        int i = 0;
        while (i < featureValues.size()) {
            IFeatureValue featureValue = featureValues.get(i);
            Slot slot = UMLFactory.eINSTANCE.createSlot();
            slot.setDefiningFeature(featureValue.getFeature());
            List values = featureValue.getValues();
            int j = 0;
            while (j < values.size()) {
                IValue value = (IValue)values.get(j);
                slot.getValues().add((Object)value.specify());
                ++j;
            }
            instance.getSlots().add((Object)slot);
            ++i;
        }
        return instanceValue;
    }

    public void addFeatureValues(List<IFeatureValue> oldFeatureValues) {
        List<Classifier> types = this.getTypes();
        int i = 0;
        while (i < types.size()) {
            Classifier type = types.get(i);
            this.addFeatureValuesForType(type, oldFeatureValues);
            ++i;
        }
    }

    public void addFeatureValuesForType(Classifier type, List<IFeatureValue> oldFeatureValues) {
        EList ownedMembers = type.getOwnedMembers();
        int j = 0;
        while (j < ownedMembers.size()) {
            NamedElement ownedMember = (NamedElement)ownedMembers.get(j);
            if (ownedMember instanceof StructuralFeature) {
                this.setFeatureValue((StructuralFeature)ownedMember, this.getValues(ownedMember, oldFeatureValues), 0);
            }
            ++j;
        }
        EList supertypes = type.getGenerals();
        int i = 0;
        while (i < supertypes.size()) {
            Classifier supertype = (Classifier)supertypes.get(i);
            this.addFeatureValuesForType(supertype, oldFeatureValues);
            ++i;
        }
    }

    public void createFeatureValues() {
        this.addFeatureValues(new ArrayList<IFeatureValue>());
    }

    public List<IFeatureValue> getMemberValues() {
        List<IFeatureValue> featureValues = this.getFeatureValues();
        ArrayList<IFeatureValue> memberValues = new ArrayList<IFeatureValue>();
        List<Classifier> types = this.getTypes();
        int i = 0;
        while (i < featureValues.size()) {
            IFeatureValue featureValue = featureValues.get(i);
            Boolean isMember = false;
            int j = 1;
            while (j <= types.size() & isMember == false) {
                Classifier type = types.get(j - 1);
                EList members = type.getMembers();
                int k = 1;
                while (k <= members.size() & isMember == false) {
                    NamedElement member = (NamedElement)members.get(k - 1);
                    isMember = featureValue.getFeature() == member;
                    ++k;
                }
                ++j;
            }
            if (isMember.booleanValue()) {
                memberValues.add(featureValue);
            }
            ++i;
        }
        return memberValues;
    }

    public List<IValue> getValues(NamedElement feature, List<IFeatureValue> featureValues) {
        IFeatureValue foundFeatureValue = null;
        int i = 1;
        while (foundFeatureValue == null & i <= featureValues.size()) {
            IFeatureValue featureValue = featureValues.get(i - 1);
            if (featureValue.getFeature() == feature) {
                foundFeatureValue = featureValue;
            }
            ++i;
        }
        ArrayList<IValue> values = foundFeatureValue == null ? new ArrayList<IValue>() : foundFeatureValue.getValues();
        return values;
    }

    public abstract IFeatureValue getFeatureValue(StructuralFeature var1);

    public abstract void setFeatureValue(StructuralFeature var1, List<IValue> var2, Integer var3);

    public abstract List<IFeatureValue> getFeatureValues();
}

