/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.commonbehavior;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ArrivalSignal;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ClassifierBehaviorInvocationEventAccepter;
import org.eclipse.papyrus.moka.fuml.commonbehavior.GetNextEventStrategy;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IClassifierBehaviorInvocationEventAccepter;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IObjectActivation;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.commonbehavior.InvocationEventOccurrence;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.loci.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.Object_;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLEventDispatchLoopExecution;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLTaskExecutionFactory;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;

public class ObjectActivation
implements IObjectActivation {
    public List<IClassifierBehaviorInvocationEventAccepter> classifierBehaviorInvocations = new ArrayList<IClassifierBehaviorInvocationEventAccepter>();
    public List<IEventAccepter> waitingEventAccepters = new ArrayList<IEventAccepter>();
    public List<IEventOccurrence> eventPool = new ArrayList<IEventOccurrence>();
    public IObject_ object;
    protected IUMLEventDispatchLoopExecution dispatchLoopExecution;

    public void stop() {
        List<IClassifierBehaviorInvocationEventAccepter> classifierBehaviorExecutions = this.classifierBehaviorInvocations;
        int i = 0;
        while (i < classifierBehaviorExecutions.size()) {
            IClassifierBehaviorInvocationEventAccepter classifierBehaviorExecution = classifierBehaviorExecutions.get(i);
            classifierBehaviorExecution.terminate();
            ++i;
        }
    }

    public void register(IEventAccepter accepter) {
        Debug.println("[register] object = " + this.object);
        Debug.println("[register] accepter = " + accepter);
        this.waitingEventAccepters.add(accepter);
    }

    public void unregister(IEventAccepter accepter) {
        Debug.println("[unregister] object = " + this.object);
        Debug.println("[unregister] accepter = " + accepter);
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.waitingEventAccepters.size()) {
            if (this.waitingEventAccepters.get(i - 1) == accepter) {
                this.waitingEventAccepters.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
    }

    public void dispatchNextEvent() {
        if (this.eventPool.size() > 0) {
            IEventOccurrence eventOccurrence = this.getNextEvent();
            Debug.println("[dispatchNextEvent] eventOccurrence = " + eventOccurrence);
            ArrayList<Integer> matchingEventAccepterIndexes = new ArrayList<Integer>();
            List<IEventAccepter> waitingEventAccepters = this.waitingEventAccepters;
            int i = 0;
            while (i < waitingEventAccepters.size()) {
                IEventAccepter eventAccepter = waitingEventAccepters.get(i);
                if (eventAccepter.match(eventOccurrence).booleanValue()) {
                    matchingEventAccepterIndexes.add(i);
                }
                ++i;
            }
            if (matchingEventAccepterIndexes.size() > 0) {
                int j = ((ChoiceStrategy)this.object.getLocus().getFactory().getStrategy("choice")).choose(matchingEventAccepterIndexes.size());
                IEventAccepter selectedEventAccepter = this.waitingEventAccepters.get((Integer)matchingEventAccepterIndexes.get(j - 1));
                int removeAt = (Integer)matchingEventAccepterIndexes.get(j - 1);
                this.waitingEventAccepters.remove(removeAt);
                selectedEventAccepter.accept(eventOccurrence);
            }
        }
    }

    public IEventOccurrence getNextEvent() {
        return ((GetNextEventStrategy)this.object.getLocus().getFactory().getStrategy("getNextEvent")).getNextEvent(this);
    }

    public void send(IEventOccurrence eventOccurrence) {
        this.eventPool.add(eventOccurrence);
        this._send(new ArrivalSignal());
    }

    public void startBehavior(Class classifier, List<IParameterValue> inputs) {
        if (classifier == null) {
            Debug.println("[startBehavior] Starting behavior for all classifiers...");
            List<Class> types = ((Object_)this.object).types;
            for (Class type : types) {
                if (!(type instanceof Behavior | type.getClassifierBehavior() != null)) continue;
                this.startBehavior(type, new ArrayList<IParameterValue>());
            }
        } else {
            Debug.println("[startBehavior] Starting behavior for " + classifier.getName() + "...");
            boolean notYetStarted = true;
            int i = 1;
            while (notYetStarted & i <= this.classifierBehaviorInvocations.size()) {
                notYetStarted = this.classifierBehaviorInvocations.get(i - 1).getExecutedClassifier() != classifier;
                ++i;
            }
            if (notYetStarted) {
                ClassifierBehaviorInvocationEventAccepter newInvocation = new ClassifierBehaviorInvocationEventAccepter();
                newInvocation.setObjectActivation(this);
                this.classifierBehaviorInvocations.add(newInvocation);
                newInvocation.invokeBehavior(classifier, inputs);
                InvocationEventOccurrence eventOccurrence = new InvocationEventOccurrence();
                eventOccurrence.execution = newInvocation.getExecution();
                this.eventPool.add(eventOccurrence);
                this._send(new ArrivalSignal());
            }
        }
    }

    public void _startObjectBehavior() {
        IUMLTaskExecutionFactory taskFactory;
        if (this.dispatchLoopExecution == null && (taskFactory = this.getObject().getLocus().getFactory().getTaskFactory()) != null) {
            this.dispatchLoopExecution = taskFactory.createEventDispatchLoopExecution();
            this.dispatchLoopExecution.setObjectActivation((IObjectActivation)this);
        }
        this.dispatchLoopExecution.newSignalArrival();
    }

    public void notifyEventArrival() {
        this._send(new ArrivalSignal());
    }

    public void _send(ArrivalSignal signal) {
        this._startObjectBehavior();
    }

    public void setObject(IObject_ context) {
        this.object = context;
    }

    public IObject_ getObject() {
        return this.object;
    }

    public List<IClassifierBehaviorInvocationEventAccepter> getClassifierBehaviorInvocations() {
        return this.classifierBehaviorInvocations;
    }

    public List<IEventOccurrence> getEvents() {
        return this.eventPool;
    }

    public List<IEventAccepter> getWaitingEventAccepters() {
        return this.waitingEventAccepters;
    }
}

