/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.markup.emf.template2structure.mapping;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.accessors.IOutputFileAccessor;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.utils.DocumentStructureTemplateUtils;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate;
import org.eclipse.papyrus.model2doc.markup.emf.template2structure.Activator;

public abstract class AbstractMarkdownToHtmlFileMapper<INPUT extends IMarkupToFileBodyPartTemplate>
extends AbstractBodyPartTemplateToStructureMapper<INPUT> {
    protected static final String FILE_EXTENSION = "html";
    private static final String MARKDOWN_FORMAT = "markdown";
    private static final String MD_FORMAT = "md";
    private static final String HTML_FORMAT = "html";
    protected static final String EMPTY_STRING = "";
    protected static final String UNDESCORE = "_";
    private static final Collection<String> SUPPORTED_INPUT_FORMAT = new ArrayList<String>();

    static {
        SUPPORTED_INPUT_FORMAT.add("html");
        SUPPORTED_INPUT_FORMAT.add(MARKDOWN_FORMAT);
        SUPPORTED_INPUT_FORMAT.add(MD_FORMAT);
    }

    public <T> AbstractMarkdownToHtmlFileMapper(EClass inputEClass, Class<T> outputClass) {
        super(inputEClass, outputClass);
    }

    protected boolean doHandlesInput(INPUT eobject) {
        String outputFormat;
        String inputFormat = eobject.getInputFormat() != null ? eobject.getInputFormat().toLowerCase() : EMPTY_STRING;
        String string = outputFormat = eobject.getOutputFomat() != null ? eobject.getOutputFomat().toLowerCase() : EMPTY_STRING;
        return "html".equals(outputFormat) && SUPPORTED_INPUT_FORMAT.contains(inputFormat);
    }

    protected String createHTMLFile(IBodySectionPartTemplate bodyPartTemplate, String markupText, String fileName) {
        DocumentTemplate documentTemplate = DocumentStructureTemplateUtils.getDocumentTemplate((EObject)bodyPartTemplate);
        IDocumentStructureGeneratorConfiguration configuration = documentTemplate.getDocumentStructureGeneratorConfiguration();
        IOutputFileAccessor accessor = configuration.createImageOutputAccessor();
        URI uri = accessor.createOutputFileURI(fileName, "html");
        String filePath = uri.toString();
        if (uri.segmentCount() > 1) {
            URI folderURI = uri.trimSegments(1);
            Path folderPath = new Path(folderURI.toPlatformString(true));
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)folderPath);
            AbstractMarkdownToHtmlFileMapper.createFolders((IContainer)folder);
            try {
                IFile file = folder.getFile(String.valueOf(fileName) + "." + "html");
                if (file.exists()) {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                Parser parser = Parser.builder().build();
                Node document = parser.parse(markupText);
                HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).build();
                String result = renderer.render(document);
                StringBuilder fileContent = new StringBuilder();
                fileContent.append("<!DOCTYPE html>\n");
                fileContent.append("<html>\n");
                fileContent.append("<body>\n");
                fileContent.append("<meta charset=\"UTF-8\">");
                fileContent.append(result);
                fileContent.append("\n");
                fileContent.append("</body>\n");
                fileContent.append("</html>\n");
                file.create((InputStream)new ByteArrayInputStream(fileContent.toString().getBytes()), false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return filePath;
    }

    private static void createFolders(IContainer folder) {
        if (!folder.exists()) {
            try {
                if (!folder.getParent().exists()) {
                    AbstractMarkdownToHtmlFileMapper.createFolders(folder.getParent());
                }
                if (folder instanceof IFolder) {
                    ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                } else if (folder instanceof IProject) {
                    ((IProject)folder).create((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected static final String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }
}

