/**
 * Copyright (c) 2007, 2016, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Florian Noyrit - Initial API and implementation
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.updater.DiagramUpdater;
import xpt.diagram.updater.LinkDescriptor;
import xpt.diagram.updater.NodeDescriptor;
import xpt.diagram.updater.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class DiagramContentInitializer {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private VisualIDRegistry xptVisualIDRegistry;

  @Inject
  private DiagramUpdater xptDiagramUpdater;

  @Inject
  private Activator xptActivator;

  @Inject
  private NodeDescriptor nodeDescriptor;

  @Inject
  private LinkDescriptor linkDescriptor;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _diagramContentInitializerClassName = it.getDiagramContentInitializerClassName();
    _builder.append(_diagramContentInitializerClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence DiagramContentInitializer(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initDiagramContent = this.initDiagramContent(it);
    _builder.append(_initDiagramContent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<GenContainerBase, Boolean> _function = (GenContainerBase container) -> {
        boolean _isSansDomain = container.isSansDomain();
        return Boolean.valueOf((!_isSansDomain));
      };
      Iterable<GenContainerBase> _filter = IterableExtensions.<GenContainerBase>filter(it.getAllContainers(), _function);
      for(final GenContainerBase container : _filter) {
        _builder.append("\t");
        CharSequence _createChildren = this.createChildren(container);
        _builder.append(_createChildren, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createNode = this.createNode(it);
    _builder.append(_createNode, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createLinks = this.createLinks(it);
    _builder.append(_createLinks, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenCompartment>notEmpty(Iterables.<GenCompartment>filter(it.getAllContainers(), GenCompartment.class));
      if (_notEmpty) {
        _builder.append("\t");
        CharSequence _compartment = this.getCompartment(it);
        _builder.append(_compartment, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private java.util.Map myDomain2NotationMap = new java.util.HashMap();");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private java.util.Collection myLinkDescriptors = new java.util.LinkedList();");
    _builder.newLine();
    return _builder;
  }

  public CharSequence initDiagramContent(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void initDiagramContent(org.eclipse.gmf.runtime.notation.Diagram diagram) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t");
    _builder.append(".equals(diagram.getType())) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().logError(\"Incorrect diagram passed as a parameter: \" + diagram.getType());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getDomainDiagramElement(), "diagram.getElement()");
    _builder.append(_NotInstance, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getInstance().logError(\"Incorrect diagram element specified: \" + diagram.getElement() + \" instead of ");
    String _name = it.getDomainDiagramElement().getEcoreClass().getName();
    _builder.append(_name, "\t\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createChildrenMethodName = this.createChildrenMethodName(it);
    _builder.append(_createChildrenMethodName, "\t");
    _builder.append("(diagram);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("createLinks(diagram);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @MetaDef
  public CharSequence createChildrenMethodName(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("create");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("_Children");
    return _builder;
  }

  public CharSequence createChildren(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void ");
    CharSequence _createChildrenMethodName = this.createChildrenMethodName(it);
    _builder.append(_createChildrenMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _collectContainedLinks = this.collectContainedLinks(it);
    _builder.append(_collectContainedLinks, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _hasSemanticChildren = this._utils_qvto.hasSemanticChildren(it);
      if (_hasSemanticChildren) {
        _builder.append("\t");
        _builder.append("java.util.Collection childNodeDescriptors = ");
        CharSequence _semanticChildrenMethodCall = this.xptDiagramUpdater.getSemanticChildrenMethodCall(it);
        _builder.append(_semanticChildrenMethodCall, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("for (java.util.Iterator it = childNodeDescriptors.iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("createNode(view, (");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it.getDiagram().getEditorGen().getDiagramUpdater());
        _builder.append(_qualifiedClassName, "\t\t");
        _builder.append(") it.next());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _createCompartmentsChildren = this.createCompartmentsChildren(it);
    _builder.append(_createCompartmentsChildren, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _collectContainedLinks(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _collectContainedLinks(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("myDomain2NotationMap.put(view.getElement(), view);");
    _builder.newLine();
    _builder.append("myLinkDescriptors.addAll(");
    CharSequence _outgoingLinksMethodCall = this.xptDiagramUpdater.getOutgoingLinksMethodCall(it);
    _builder.append(_outgoingLinksMethodCall);
    _builder.append("(view));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _createCompartmentsChildren(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _createCompartmentsChildren(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment comp : _compartments) {
        CharSequence _callCreateCompartmentChildren = this.callCreateCompartmentChildren(comp);
        _builder.append(_callCreateCompartmentChildren);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  /**
   * Will be called for each compartment of GenNode for GenNode.isSansDomain() == false.
   * if !GenNode.isSansDomain() => !GenCompartment.isSansDomain() so should not check
   * !this.isSansDomain() here.
   */
  public CharSequence callCreateCompartmentChildren(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _createChildrenMethodName = this.createChildrenMethodName(it);
    _builder.append(_createChildrenMethodName);
    _builder.append("(getCompartment(view, ");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID);
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence createNode(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void createNode(org.eclipse.gmf.runtime.notation.View parentView, ");
    CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it.getEditorGen().getDiagramUpdater());
    _builder.append(_qualifiedClassName);
    _builder.append(" nodeDescriptor) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final String nodeType = ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it, "nodeDescriptor.getVisualID()");
    _builder.append(_typeMethodCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Node node = org.eclipse.gmf.runtime.diagram.core.services.ViewService.createNode(parentView, nodeDescriptor.getModelElement(), nodeType, ");
    CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
    _builder.append(_preferenceHintAccess, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("switch (nodeDescriptor.getVisualID()) {");
    _builder.newLine();
    {
      final Function1<GenNode, Boolean> _function = (GenNode node) -> {
        boolean _isSansDomain = node.isSansDomain();
        return Boolean.valueOf((!_isSansDomain));
      };
      Iterable<GenNode> _filter = IterableExtensions.<GenNode>filter(it.getAllNodes(), _function);
      for(final GenNode n : _filter) {
        _builder.append("\t\t");
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(n);
        _builder.append(_visualID, "\t\t");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        CharSequence _createChildrenMethodName = this.createChildrenMethodName(n);
        _builder.append(_createChildrenMethodName, "\t\t\t");
        _builder.append("(node);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * Adopt this code to work with links to links
   */
  public CharSequence createLinks(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void createLinks(org.eclipse.gmf.runtime.notation.Diagram diagram) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (boolean continueLinkCreation = true; continueLinkCreation;) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("continueLinkCreation = false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.Collection additionalDescriptors = new java.util.LinkedList();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator it = myLinkDescriptors.iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(it.getEditorGen().getDiagramUpdater());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(" nextLinkDescriptor = (");
    CharSequence _qualifiedClassName_1 = this.linkDescriptor.qualifiedClassName(it.getEditorGen().getDiagramUpdater());
    _builder.append(_qualifiedClassName_1, "\t\t\t");
    _builder.append(") it.next();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("if (!myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("continue;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final String linkType = ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it, "nextLinkDescriptor.getVisualID()");
    _builder.append(_typeMethodCall, "\t\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Edge edge = org.eclipse.gmf.runtime.diagram.core.services.ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), diagram, linkType, org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.APPEND, true, ");
    CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
    _builder.append(_preferenceHintAccess, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("if (edge != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("edge.setSource((org.eclipse.gmf.runtime.notation.View) myDomain2NotationMap.get(nextLinkDescriptor.getSource()));");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("edge.setTarget((org.eclipse.gmf.runtime.notation.View) myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("it.remove();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (nextLinkDescriptor.getModelElement() != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("continueLinkCreation = true;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("switch (nextLinkDescriptor.getVisualID()) {");
    _builder.newLine();
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink link : _links) {
        {
          GenClass _metaClass = this._utils_qvto.getMetaClass(link);
          boolean _tripleNotEquals = (_metaClass != null);
          if (_tripleNotEquals) {
            _builder.append("\t\t\t\t\t");
            _builder.append("case ");
            CharSequence _visualID = VisualIDRegistry.visualID(link);
            _builder.append(_visualID, "\t\t\t\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t");
            _builder.append("additionalDescriptors.addAll(");
            CharSequence _outgoingLinksMethodCall = this.xptDiagramUpdater.getOutgoingLinksMethodCall(link);
            _builder.append(_outgoingLinksMethodCall, "\t\t\t\t\t");
            _builder.append("(edge));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLinkDescriptors.addAll(additionalDescriptors);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getCompartment(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.notation.Node getCompartment(org.eclipse.gmf.runtime.notation.View node, String visualID) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String type = ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it, "visualID");
    _builder.append(_typeMethodCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = node.getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (nextView instanceof org.eclipse.gmf.runtime.notation.Node && type.equals(nextView.getType())) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.Node) nextView;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence collectContainedLinks(final GenContainerBase it) {
    if (it instanceof GenNode) {
      return _collectContainedLinks((GenNode)it);
    } else if (it != null) {
      return _collectContainedLinks(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence createCompartmentsChildren(final GenContainerBase it) {
    if (it instanceof GenNode) {
      return _createCompartmentsChildren((GenNode)it);
    } else if (it != null) {
      return _createCompartmentsChildren(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
