/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.List;
import org.eclipse.core.runtime.Assert;

public class PasteTreeUtils {
    private PasteTreeUtils() {
    }

    public static final int getDepth(int nbReadCell, int maxDepth, List<Integer> hiddenDepth, boolean hasConfigurationOnDepth0) {
        int nbColumn = (maxDepth + 1) * 2;
        int readColumn = 0;
        int depth = -1;
        int i = 0;
        while (i < nbColumn) {
            if (i % 2 == 0) {
                ++depth;
                if (!hiddenDepth.contains(i / 2)) {
                    ++readColumn;
                }
            } else {
                ++readColumn;
            }
            if (readColumn == nbReadCell) {
                if (!hasConfigurationOnDepth0) {
                    --readColumn;
                    hasConfigurationOnDepth0 = true;
                } else {
                    return depth;
                }
            }
            ++i;
        }
        throw new UnsupportedOperationException("There is an error in this method", null);
    }

    public static final boolean isCategory(int nbReadCell, int maxDepth, List<Integer> hiddenDepth, boolean hasConfigurationOnDepth0) {
        Assert.isTrue((nbReadCell > 0 ? 1 : 0) != 0);
        int nbColumn = (maxDepth + 1) * 2;
        int readColumn = 0;
        int i = 0;
        while (i < nbColumn) {
            boolean isCategory;
            if (i % 2 == 0) {
                if (!hiddenDepth.contains(i / 2)) {
                    isCategory = true;
                    ++readColumn;
                } else {
                    isCategory = false;
                }
            } else {
                ++readColumn;
                isCategory = false;
            }
            if (readColumn == nbReadCell) {
                if (!hasConfigurationOnDepth0) {
                    --readColumn;
                    hasConfigurationOnDepth0 = true;
                } else {
                    return isCategory;
                }
            }
            ++i;
        }
        throw new UnsupportedOperationException("There is an error in this method", null);
    }
}

