/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.databinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.xwt.databinding.Event;
import org.eclipse.xwt.databinding.EventListener;

public class EventManager {
    private static Map<Object, EventManager> managers = new HashMap<Object, EventManager>();
    private Realm realm;
    private Map<String, List<EventListener>> type2listeners = new HashMap<String, List<EventListener>>();

    private EventManager(Object observed, Realm realm) {
        this.realm = realm;
    }

    public static EventManager getEventManager(Object eventTarget, Realm realm) {
        EventManager eventManager = managers.get(eventTarget);
        if (eventManager == null || eventManager.realm != realm) {
            eventManager = new EventManager(eventTarget, realm);
            managers.put(eventTarget, eventManager);
        }
        return eventManager;
    }

    public void dispatchEvent(Event event) {
        String eventType = event.getEventType();
        List<EventListener> listeners = this.type2listeners.get(eventType);
        for (EventListener l : listeners) {
            l.handleEvent(event);
        }
    }

    public void addEventListener(String eventType, EventListener eventListener) {
        List<EventListener> listeners = this.type2listeners.get(eventType);
        if (listeners == null) {
            listeners = new ArrayList<EventListener>();
            this.type2listeners.put(eventType, listeners);
        }
        listeners.add(eventListener);
    }

    public void removeEventListener(String eventType, EventListener eventListener) {
        List<EventListener> listeners = this.type2listeners.get(eventType);
        if (listeners != null) {
            listeners.remove(eventListener);
        }
    }
}

