/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.gef.internal.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.papyrus.infra.ui.editor.CoreMultiDiagramEditor;

public class MultiDiagramEditorGefDelegate
implements Supplier<ActionRegistry> {
    private static final Map<CoreMultiDiagramEditor, MultiDiagramEditorGefDelegate> instances = new HashMap<CoreMultiDiagramEditor, MultiDiagramEditorGefDelegate>();
    private final CoreMultiDiagramEditor editor;
    protected ActionRegistry actionRegistry;
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>(1);

    protected MultiDiagramEditorGefDelegate(CoreMultiDiagramEditor editor) {
        this.editor = editor;
        editor.onClose(this::dispose);
    }

    static MultiDiagramEditorGefDelegate getInstance(CoreMultiDiagramEditor editor) {
        return instances.computeIfAbsent(editor, MultiDiagramEditorGefDelegate::new);
    }

    public void dispose() {
        instances.remove(this.editor);
        this.selectionListeners.clear();
        if (this.actionRegistry != null) {
            this.actionRegistry.dispose();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    @Override
    public ActionRegistry get() {
        return this.getActionRegistry();
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }
}

