/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;

public class PathElement {
    protected final String name;
    protected final Element element;

    public static int getCommonLength(List<PathElement> firstPath, List<PathElement> secondPath) {
        int iMax = Math.min(firstPath.size(), secondPath.size());
        int i = 0;
        while (i < iMax) {
            Element objectElement = firstPath.get((int)i).element;
            Element contextElement = secondPath.get((int)i).element;
            if (!objectElement.equals(contextElement)) {
                return i;
            }
            ++i;
        }
        return iMax;
    }

    public static List<PathElement> getPath(EObject element) {
        ArrayList<PathElement> path = new ArrayList<PathElement>();
        EObject parent = element;
        while (parent != null && !(parent instanceof Namespace)) {
            parent = parent.eContainer();
        }
        while (parent instanceof Namespace) {
            Namespace namespace = (Namespace)parent;
            path.add(0, new PathElement(namespace.getName(), namespace));
            parent = parent.eContainer();
        }
        return path;
    }

    public static List<PathElement> getPath(EObject element, MetamodelManager metamodelManager) {
        ArrayList<PathElement> path = new ArrayList<PathElement>();
        EObject parent = element;
        while (parent != null && !(parent instanceof Namespace)) {
            parent = parent.eContainer();
        }
        while (parent instanceof Namespace && !(parent instanceof Model)) {
            Namespace namespace = (Namespace)parent;
            if (metamodelManager != null) {
                namespace = ((PivotMetamodelManager)metamodelManager).getPrimaryElement(namespace);
            }
            path.add(0, new PathElement(namespace.getName(), namespace));
            parent = parent.eContainer();
        }
        return path;
    }

    public PathElement(String name, Element element) {
        this.name = name;
        this.element = element;
    }

    public final Element getElement() {
        return this.element;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

