/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.LambdaUtils;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.SimpleInstruction;
import org.eclipse.osgi.util.NLS;

public class PushLocalVariable
extends SimpleInstruction {
    private String fName;

    public PushLocalVariable(String name) {
        this.fName = name;
    }

    @Override
    public void execute() throws CoreException {
        IJavaFieldVariable f;
        IJavaVariable[] locals;
        IVariable internalVariable = this.getInternalVariable(this.fName);
        if (internalVariable != null) {
            this.push(internalVariable);
            return;
        }
        IRuntimeContext context = this.getContext();
        IJavaVariable[] iJavaVariableArray = locals = context.getLocals();
        int n = locals.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaVariable local = iJavaVariableArray[n2];
            if (local.getName().equals(this.getName())) {
                this.push(local);
                return;
            }
            ++n2;
        }
        IJavaObject innerThis = context.getThis();
        if (innerThis != null && (f = innerThis.getField("val$" + this.getName(), false)) != null) {
            this.push(f);
            return;
        }
        IVariable variable = LambdaUtils.findLambdaFrameVariable(context, this.getName());
        if (variable != null) {
            this.push(variable);
            return;
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, NLS.bind((String)InstructionsEvaluationMessages.PushLocalVariable_Cannot_find_the_variable____1, (Object[])new String[]{this.fName}), null));
    }

    protected String getName() {
        return this.fName;
    }

    public String toString() {
        return NLS.bind((String)InstructionsEvaluationMessages.PushLocalVariable_push____0___2, (Object[])new String[]{this.getName()});
    }
}

