/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.Slot;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.context.ModelContext;
import org.eclipse.ocl.pivot.internal.context.OperationContext;
import org.eclipse.ocl.pivot.internal.context.PropertyContext;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractCustomizable;
import org.eclipse.ocl.pivot.internal.evaluation.BasicOCLExecutor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.evaluation.PivotModelManager;
import org.eclipse.ocl.pivot.internal.library.ImplementationManager;
import org.eclipse.ocl.pivot.internal.manager.FlowAnalysis;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.resource.ICSI2ASMapping;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.options.PivotValidationOptions;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.values.ObjectValue;

public abstract class AbstractEnvironmentFactory
extends AbstractCustomizable
implements EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension {
    public static final @NonNull TracingOption ENVIRONMENT_FACTORY_ATTACH = new TracingOption("org.eclipse.ocl.pivot", "environmentFactory/attach");
    private boolean traceEvaluation;
    protected final @NonNull ProjectManager projectManager;
    protected final @NonNull ResourceSet externalResourceSet;
    protected final boolean externalResourceSetWasNull;
    private PivotMetamodelManager metamodelManager;
    private final @NonNull CompleteEnvironmentInternal completeEnvironment;
    private final @NonNull StandardLibraryInternal standardLibrary;
    private @Nullable ICSI2ASMapping csi2asMapping;
    private final @NonNull CompleteModelInternal completeModel;
    private IdResolver idResolver;
    private int attachCount = 0;
    private @NonNull Technology technology = ASResourceFactoryRegistry.INSTANCE.getTechnology();
    private Map<Object, StatusCodes.Severity> validationKey2severity = null;
    public static int CONSTRUCTION_COUNT = 0;

    protected AbstractEnvironmentFactory(@NonNull ProjectManager projectManager, @Nullable ResourceSet externalResourceSet) {
        ++CONSTRUCTION_COUNT;
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            PivotStandaloneSetup.doSetup();
        }
        this.projectManager = projectManager;
        if (externalResourceSet != null) {
            this.externalResourceSetWasNull = false;
            this.externalResourceSet = externalResourceSet;
        } else {
            this.externalResourceSetWasNull = true;
            this.externalResourceSet = externalResourceSet = new ResourceSetImpl();
            projectManager.initializeResourceSet(externalResourceSet);
            externalResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            externalResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emof", new EMOFResourceFactoryImpl());
            ASResourceFactoryRegistry.INSTANCE.configureResourceSet(externalResourceSet);
        }
        if (ENVIRONMENT_FACTORY_ATTACH.isActive()) {
            ENVIRONMENT_FACTORY_ATTACH.println("[" + Thread.currentThread().getName() + "] Create(" + this.attachCount + ") " + NameUtil.debugSimpleName(this) + " => " + NameUtil.debugSimpleName(externalResourceSet));
        }
        this.adapt((Notifier)externalResourceSet);
        this.metamodelManager = null;
        this.completeEnvironment = this.createCompleteEnvironment();
        this.standardLibrary = this.completeEnvironment.getOwnedStandardLibrary();
        this.completeModel = this.completeEnvironment.getOwnedCompleteModel();
        PivotUtil.initializeLoadOptionsToSupportSelfReferences(this.getResourceSet());
    }

    public @NonNull EnvironmentFactoryAdapter adapt(@NonNull Notifier notifier) {
        List eAdapters = (List)ClassUtil.nonNullEMF(notifier.eAdapters());
        EnvironmentFactoryAdapter adapter = ClassUtil.getAdapter(EnvironmentFactoryAdapter.class, eAdapters);
        if (adapter != null && adapter.getEnvironmentFactory() != this) {
            adapter = null;
        }
        if (adapter == null) {
            adapter = new EnvironmentFactoryAdapter(this, notifier);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    @Override
    public void addExternal2AS(@NonNull External2AS external2as) {
        Resource resource = external2as.getResource();
        if (resource != null && ClassUtil.isRegistered(resource)) {
            ResourceSet externalResourceSet2 = this.getResourceSet();
            this.projectManager.useGeneratedResource(resource, externalResourceSet2);
        }
        this.getMetamodelManager().addExternal2AS(external2as);
    }

    @Override
    public void addExternalResources(@NonNull ResourceSet resourceSet) {
        Map uriResourceMap;
        ResourceSet externalResourceSet = this.getResourceSet();
        if (externalResourceSet instanceof ResourceSetImpl && (uriResourceMap = ((ResourceSetImpl)externalResourceSet).getURIResourceMap()) != null) {
            Map contextResourceMap;
            for (Resource eResource : resourceSet.getResources()) {
                URI uri = eResource.getURI();
                if (uri == null) continue;
                uriResourceMap.put(uri, eResource);
            }
            if (resourceSet instanceof ResourceSetImpl && (contextResourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap()) != null && contextResourceMap != uriResourceMap) {
                for (URI uri : contextResourceMap.keySet()) {
                    uriResourceMap.put(uri, (Resource)contextResourceMap.get(uri));
                }
            }
        }
    }

    @Override
    public synchronized void attach(Object object) {
        if (this.isDisposed()) {
            if (ENVIRONMENT_FACTORY_ATTACH.isActive()) {
                ENVIRONMENT_FACTORY_ATTACH.println("[" + Thread.currentThread().getName() + "] Attach(" + this.attachCount + ") " + NameUtil.debugSimpleName(this));
            }
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " disposed");
        }
        ++this.attachCount;
        if (ENVIRONMENT_FACTORY_ATTACH.isActive()) {
            ENVIRONMENT_FACTORY_ATTACH.println("[" + Thread.currentThread().getName() + "] Attach(" + (this.attachCount - 1) + ":" + this.attachCount + ") " + NameUtil.debugSimpleName(this));
        }
    }

    protected @Nullable PivotMetamodelManager basicGetMetamodelManager() {
        return this.metamodelManager;
    }

    @Override
    public void configureLoadFirstStrategy() {
        this.configureLoadStrategy(StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
    }

    @Override
    public void configureLoadStrategy(@NonNull ProjectManager.IResourceLoadStrategy packageLoadStrategy, @Nullable ProjectManager.IConflictHandler conflictHandler) {
        ResourceSet externalResourceSet = this.getResourceSet();
        this.projectManager.configure(externalResourceSet, packageLoadStrategy, conflictHandler);
    }

    @Override
    public @NonNull ResourceSetImpl createASResourceSet() {
        ResourceSetImpl asResourceSet = new ResourceSetImpl();
        StandaloneProjectMap.initializeURIResourceMap((ResourceSet)asResourceSet);
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)asResourceSet);
        EPackage.Registry packageRegistry = asResourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
        asResourceSet.eAdapters().add((Object)this.projectManager);
        this.projectManager.initializeResourceSet((ResourceSet)asResourceSet);
        return asResourceSet;
    }

    @Override
    public @NonNull CompleteEnvironmentInternal createCompleteEnvironment() {
        CompleteEnvironmentInternal completeEnvironment = (CompleteEnvironmentInternal)PivotFactory.eINSTANCE.createCompleteEnvironment();
        completeEnvironment.init(this);
        return completeEnvironment;
    }

    @Override
    public @NonNull EvaluationEnvironment createEvaluationEnvironment(@NonNull NamedElement executableObject, @NonNull ModelManager modelManager) {
        ExecutorInternal executor = this.createExecutor(modelManager);
        return executor.initializeEvaluationEnvironment(executableObject);
    }

    @Override
    @Deprecated
    public @NonNull EvaluationEnvironment createEvaluationEnvironment(@NonNull EvaluationEnvironment parent, @NonNull NamedElement executableObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull EvaluationVisitor createEvaluationVisitor(@Nullable Object context, @NonNull ExpressionInOCL expression, @Nullable ModelManager modelManager) {
        if (modelManager == null) {
            modelManager = this.createModelManager(context);
        }
        ExecutorInternal executor = this.createExecutor(modelManager);
        EvaluationEnvironment evaluationEnvironment = executor.initializeEvaluationEnvironment(expression);
        Variable contextVariable = expression.getOwnedContext();
        if (contextVariable != null) {
            IdResolver idResolver = this.getIdResolver();
            Object value = idResolver.boxedValueOf(context);
            evaluationEnvironment.add(contextVariable, value);
        }
        for (Variable parameterVariable : expression.getOwnedParameters()) {
            if (parameterVariable == null) continue;
            evaluationEnvironment.add(parameterVariable, null);
        }
        return executor.getEvaluationVisitor();
    }

    @Override
    public @NonNull EvaluationVisitor createEvaluationVisitor(@NonNull EvaluationEnvironment evaluationEnvironment) {
        ExecutorInternal executor = ((EvaluationEnvironment.EvaluationEnvironmentExtension)evaluationEnvironment).getExecutor();
        return executor.getEvaluationVisitor();
    }

    @Override
    public @NonNull ExecutorInternal createExecutor(@NonNull ModelManager modelManager) {
        return new BasicOCLExecutor(this, modelManager);
    }

    @Override
    public @NonNull FlowAnalysis createFlowAnalysis(@NonNull OCLExpression contextExpression) {
        return new FlowAnalysis(this, contextExpression);
    }

    @Override
    public @NonNull IdResolver createIdResolver() {
        return this.technology.createIdResolver(this);
    }

    @Override
    public @NonNull ImplementationManager createImplementationManager() {
        return new ImplementationManager(this);
    }

    @Override
    public @NonNull PivotMetamodelManager createMetamodelManager() {
        assert (this.metamodelManager == null);
        this.metamodelManager = new PivotMetamodelManager(this, (ResourceSet)this.createASResourceSet());
        assert (this.metamodelManager != null);
        return this.metamodelManager;
    }

    protected @NonNull ModelManager createModelManager() {
        return ModelManager.NULL;
    }

    @Override
    public @NonNull ModelManager createModelManager(@Nullable Object object) {
        if (object instanceof ObjectValue) {
            object = ((ObjectValue)object).getObject();
        }
        if (object instanceof EObject) {
            return new PivotModelManager(this, (EObject)object);
        }
        return ModelManager.NULL;
    }

    @Override
    public @NonNull OCLInternal createOCL() {
        return new OCLInternal(this);
    }

    @Override
    @Deprecated
    public @NonNull ParserContext createParserContext(@Nullable EObject context) throws ParserException {
        ParserContext parserContext;
        if (context instanceof Element && (parserContext = this.createParserContext((Element)context)) != null) {
            return parserContext;
        }
        return new ModelContext(this, null);
    }

    @Override
    public @Nullable ParserContext createParserContext(@NonNull Element element) {
        EObject pivotContainer;
        Element pivotElement = element;
        if (element instanceof ExpressionInOCL) {
            Class pivotType;
            Property asDefiningFeature;
            pivotContainer = pivotElement.eContainer();
            if (pivotContainer instanceof Operation) {
                Operation pivotOperation = (Operation)pivotContainer;
                return new OperationContext((EnvironmentFactory)this, null, pivotOperation, null);
            }
            if (pivotContainer instanceof Property) {
                Property pivotProperty = (Property)pivotContainer;
                return new PropertyContext(this, null, pivotProperty);
            }
            if (pivotContainer instanceof Constraint) {
                EObject pivotContainerContainer = pivotContainer.eContainer();
                if (pivotContainerContainer instanceof Operation) {
                    Type resultType;
                    Operation pivotOperation = (Operation)pivotContainerContainer;
                    String resultName = null;
                    if (pivotOperation.getOwnedPostconditions().contains(pivotContainer) && (resultType = pivotOperation.getType()) != null && !(resultType instanceof VoidType)) {
                        resultName = "result";
                    }
                    return new OperationContext((EnvironmentFactory)this, null, pivotOperation, resultName);
                }
                if (pivotContainerContainer instanceof Class) {
                    Class pivotType2 = (Class)pivotContainerContainer;
                    return new ClassContext(this, null, pivotType2, null);
                }
            }
            if (pivotContainer instanceof Slot && (asDefiningFeature = ((Slot)pivotContainer).getDefiningProperty()) != null && (pivotType = asDefiningFeature.getOwningClass()) != null) {
                return new ClassContext(this, null, pivotType, null);
            }
        }
        if (pivotElement instanceof Constraint && (pivotContainer = pivotElement.eContainer()) instanceof Operation) {
            Type resultType;
            Operation pivotOperation = (Operation)pivotContainer;
            String resultName = null;
            if (pivotOperation.getOwnedPostconditions().contains(pivotElement) && (resultType = pivotOperation.getType()) != null && !(resultType instanceof VoidType)) {
                resultName = "result";
            }
            return new OperationContext((EnvironmentFactory)this, null, pivotOperation, resultName);
        }
        if (pivotElement instanceof Property) {
            return new PropertyContext(this, null, (Property)pivotElement);
        }
        if (pivotElement instanceof Operation) {
            return new OperationContext((EnvironmentFactory)this, null, (Operation)pivotElement, null);
        }
        if (pivotElement instanceof OppositePropertyCallExp) {
            Property referredProperty;
            Property referredOppositeProperty = ((OppositePropertyCallExp)pivotElement).getReferredProperty();
            if (referredOppositeProperty != null && (referredProperty = referredOppositeProperty.getOpposite()) != null) {
                return new PropertyContext(this, null, referredProperty);
            }
        } else if (pivotElement instanceof PropertyCallExp) {
            Property referredProperty = ((PropertyCallExp)pivotElement).getReferredProperty();
            if (referredProperty != null) {
                return new PropertyContext(this, null, referredProperty);
            }
        } else if (pivotElement instanceof OperationCallExp) {
            Operation referredOperation = ((OperationCallExp)pivotElement).getReferredOperation();
            if (referredOperation != null) {
                return new OperationContext((EnvironmentFactory)this, null, referredOperation, null);
            }
        } else if (pivotElement instanceof LoopExp) {
            Iteration referredIteration = ((LoopExp)pivotElement).getReferredIteration();
            if (referredIteration != null) {
                return new OperationContext((EnvironmentFactory)this, null, referredIteration, null);
            }
        } else {
            Element eObject = element;
            while (eObject != null) {
                if (eObject instanceof Class && ((Class)eObject).getOwningPackage() != null) {
                    return new ClassContext(this, null, (Class)eObject, null);
                }
                eObject = eObject.eContainer();
            }
        }
        return null;
    }

    @Override
    public @NonNull TemplateParameterSubstitutionVisitor createTemplateParameterSubstitutionVisitor(@Nullable Type selfType, @Nullable Type selfTypeValue) {
        return new TemplateParameterSubstitutionVisitor(this, selfType, selfTypeValue);
    }

    protected @NonNull HashMap<Object, StatusCodes.Severity> createValidationKey2severityMap() {
        return PivotValidationOptions.createValidationKey2severityMap();
    }

    @Override
    public synchronized void detach(Object zobject) {
        if (ENVIRONMENT_FACTORY_ATTACH.isActive()) {
            ENVIRONMENT_FACTORY_ATTACH.println("[" + Thread.currentThread().getName() + "] Detach(" + this.attachCount + ":" + (this.attachCount - 1) + ") " + NameUtil.debugSimpleName(this));
        }
        if (this.isDisposed()) {
            return;
        }
        if (this.attachCount == 0) {
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " not attached");
        }
        if (--this.attachCount <= 0) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (ENVIRONMENT_FACTORY_ATTACH.isActive()) {
            ENVIRONMENT_FACTORY_ATTACH.println("[" + Thread.currentThread().getName() + "] Dispose(" + this.attachCount + ") " + NameUtil.debugSimpleName(this));
        }
        if (this.isDisposed()) {
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " already disposed");
        }
        this.attachCount = -1;
        this.disposeInternal();
    }

    protected void disposeInternal() {
        boolean isGlobal;
        assert (this.isDisposed());
        boolean bl = isGlobal = this == GlobalEnvironmentFactory.basicGetInstance();
        if (this.metamodelManager != null) {
            this.metamodelManager.dispose();
            this.metamodelManager = null;
        }
        EList externalResourceSetAdapters = this.externalResourceSet.eAdapters();
        if (this.externalResourceSetWasNull || isGlobal) {
            this.projectManager.unload(this.externalResourceSet);
            externalResourceSetAdapters.remove((Object)this.projectManager);
            this.externalResourceSet.setPackageRegistry(null);
            this.externalResourceSet.setResourceFactoryRegistry(null);
            this.externalResourceSet.setURIConverter(null);
            if (this.externalResourceSet instanceof ResourceSetImpl) {
                ((ResourceSetImpl)this.externalResourceSet).setURIResourceMap(null);
            }
            for (Resource resource : new ArrayList(this.externalResourceSet.getResources())) {
                if (Thread.currentThread().getContextClassLoader() == null) {
                    if (!resource.getContents().isEmpty()) {
                        resource.getContents().clear();
                    }
                    resource.getErrors().clear();
                    resource.getWarnings().clear();
                } else {
                    resource.unload();
                }
                resource.eAdapters().clear();
            }
            externalResourceSetAdapters.clear();
        } else {
            for (Adapter adapter : externalResourceSetAdapters) {
                if (!(adapter instanceof EnvironmentFactoryAdapter) || ((EnvironmentFactoryAdapter)adapter).getEnvironmentFactory() != this) continue;
                externalResourceSetAdapters.remove((Object)adapter);
                break;
            }
        }
        if (this.idResolver != null) {
            this.idResolver.dispose();
            this.idResolver = null;
        }
        if (this.csi2asMapping != null) {
            this.csi2asMapping.dispose();
            this.csi2asMapping = null;
        }
    }

    @Override
    public @Nullable Class getASClass(@NonNull String className) {
        return this.getMetamodelManager().getASClass(className);
    }

    @Override
    public <T extends Element> @Nullable T getASOf(@NonNull java.lang.Class<T> pivotClass, @Nullable EObject eObject) throws ParserException {
        if (eObject != null) {
            EcoreASResourceFactory bestHelper;
            Resource eResource = eObject.eResource();
            ASResourceFactory aSResourceFactory = bestHelper = eResource != null ? ASResourceFactoryRegistry.INSTANCE.getASResourceFactory(eResource) : EcoreASResourceFactory.getInstance();
            if (bestHelper != null) {
                return bestHelper.getASElement(this, pivotClass, eObject);
            }
        }
        return null;
    }

    @Override
    public <T> @Nullable T getAdapter(java.lang.Class<T> adapterType) {
        @Nullable AbstractEnvironmentFactory result = adapterType.isAssignableFrom(this.getClass()) ? this : null;
        return (T)result;
    }

    protected @NonNull Class getClassifier(@NonNull Object context) {
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        Class dClass = this.getIdResolver().getStaticTypeOfValue(null, context);
        return metamodelManager.getPrimaryClass(dClass);
    }

    @Override
    public @NonNull CompleteEnvironmentInternal getCompleteEnvironment() {
        return this.completeEnvironment;
    }

    @Override
    public @NonNull CompleteModelInternal getCompleteModel() {
        return this.completeModel;
    }

    @Override
    public @Nullable ICSI2ASMapping getCSI2ASMapping() {
        return this.csi2asMapping;
    }

    @Override
    public @Nullable String getDoSetupName(@NonNull URI uri) {
        String fileExtension = uri.fileExtension();
        if ("essentialocl".equals(fileExtension)) {
            return "EssentialOCLStandaloneSetup.doSetup()";
        }
        if ("ocl".equals(fileExtension)) {
            return "CompleteOCLStandaloneSetup.doSetup()";
        }
        if ("oclinecore".equals(fileExtension)) {
            return "OCLinEcoreStandaloneSetup.doSetup()";
        }
        if ("oclstdlib".equals(fileExtension)) {
            return "OCLstdlibStandaloneSetup.doSetup()";
        }
        return null;
    }

    @Override
    public @NonNull IdResolver getIdResolver() {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2;
    }

    @Override
    public @NonNull PivotMetamodelManager getMetamodelManager() {
        PivotMetamodelManager metamodelManager2 = this.metamodelManager;
        if (metamodelManager2 == null) {
            this.metamodelManager = metamodelManager2 = this.createMetamodelManager();
        }
        return metamodelManager2;
    }

    @Override
    protected @Nullable EnvironmentFactoryInternal getParent() {
        return null;
    }

    @Override
    public @NonNull ProjectManager getProjectManager() {
        return this.projectManager;
    }

    @Override
    public @NonNull ResourceSet getResourceSet() {
        return this.externalResourceSet;
    }

    @Override
    public @Nullable StatusCodes.Severity getSeverity(@Nullable Object validationKey) {
        Map<Object, StatusCodes.Severity> validationKey2severity2 = this.validationKey2severity;
        if (validationKey2severity2 == null) {
            this.validationKey2severity = validationKey2severity2 = this.createValidationKey2severityMap();
        }
        return validationKey2severity2.get(validationKey);
    }

    @Override
    public @NonNull StandardLibraryInternal getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    public @NonNull Technology getTechnology() {
        return this.technology;
    }

    @Override
    public boolean isDisposed() {
        return this.attachCount < 0;
    }

    @Override
    public boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    @Override
    public EPackage loadEPackage(@NonNull EPackage ePackage) {
        return this.externalResourceSet.getPackageRegistry().getEPackage(ePackage.getNsURI());
    }

    @Override
    public @Nullable Element loadResource(@NonNull Resource resource, @Nullable URI uri) throws ParserException {
        ASResourceFactory bestFactory = ASResourceFactoryRegistry.INSTANCE.getASResourceFactory(resource);
        if (bestFactory != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && resourceSet != this.externalResourceSet) {
                this.addExternalResources(resourceSet);
            }
            return bestFactory.importFromResource(this, resource, uri);
        }
        throw new ParserException("Cannot create pivot from '" + uri + "'");
    }

    @Override
    public @NonNull ExpressionInOCL parseSpecification(@NonNull LanguageExpression specification) throws ParserException {
        EObject contextElement = ClassUtil.nonNullState(specification.eContainer());
        if (specification instanceof ExpressionInOCL && ((ExpressionInOCL)specification).getOwnedBody() != null) {
            return (ExpressionInOCL)specification;
        }
        String expression = specification.getBody();
        if (expression == null) {
            throw new ParserException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, NameUtil.qualifiedNameFor(contextElement), PivotUtilInternal.getSpecificationRole(specification));
        }
        ParserContext parserContext = this.createParserContext(specification);
        if (parserContext == null) {
            throw new ParserException(PivotMessagesInternal.UnknownContextType_ERROR_, NameUtil.qualifiedNameFor(contextElement), PivotUtilInternal.getSpecificationRole(specification));
        }
        parserContext.setRootElement(specification);
        return parserContext.parse(contextElement, expression);
    }

    public void resetSeverities() {
        this.validationKey2severity = null;
    }

    @Override
    public void setCSI2ASMapping(ICSI2ASMapping csi2asMapping) {
        this.csi2asMapping = csi2asMapping;
    }

    @Override
    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
    }

    @Override
    public void setProject(@Nullable IProject project) {
    }

    @Override
    public void setSafeNavigationValidationSeverity(@NonNull StatusCodes.Severity severity) {
        for (EOperation key : PivotValidationOptions.safeValidationOperation2severityOption.keySet()) {
            if (key == null) continue;
            this.setSeverity(key, severity);
        }
    }

    @Override
    public synchronized @Nullable StatusCodes.Severity setSeverity(Object validationKey, @Nullable StatusCodes.Severity severity) {
        Map<Object, StatusCodes.Severity> validationKey2severity2 = this.validationKey2severity;
        if (validationKey2severity2 == null) {
            this.validationKey2severity = validationKey2severity2 = this.createValidationKey2severityMap();
        }
        return validationKey2severity2.put(validationKey, severity);
    }
}

