/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractShowHideAction;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideElementsRequest;
import org.eclipse.papyrus.uml.diagram.common.util.CompartmentUtils;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class ShowHideContentsAction
extends AbstractShowHideAction
implements IActionDelegate,
IWorkbenchWindowActionDelegate {
    private static int INCREMENT = 10;

    public ShowHideContentsAction() {
        this(Messages.ShowHideContentsAction_Title, Messages.ShowHideContentsAction_Message, "Show/Hide Classifier Contents Policy");
    }

    public ShowHideContentsAction(String title, String message, String editPolicyKey) {
        super(title, message, editPolicyKey);
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).size() > 1) {
            action.setEnabled(false);
            return;
        }
        super.selectionChanged(action, selection);
    }

    @Override
    protected void initAction() {
        super.initAction();
        for (IGraphicalEditPart current : this.selectedElements) {
            Port port;
            Type type;
            EObject element = ((View)current.getModel()).getElement();
            if (element instanceof Classifier || element instanceof InstanceSpecification) {
                this.representations.add(new RootEditPartRepresentation(current, element));
            }
            if (!(element instanceof Port) || !((type = (port = (Port)element).getType()) instanceof Classifier) && !(type instanceof InstanceSpecification)) continue;
            RootEditPartRepresentation e = new RootEditPartRepresentation(current, element);
            this.representations.add(e);
        }
        this.setContentProvider(new ContentProvider());
    }

    @Override
    protected List<Object> getInput() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.representations);
        return list;
    }

    @Override
    protected Command getActionCommand() {
        ShowHideElementsRequest req = null;
        CompoundCommand completeCmd = new CompoundCommand("Show/Hide Inherited Elements Command");
        for (AbstractShowHideAction.EditPartRepresentation current : this.viewsToDestroy) {
            IGraphicalEditPart ep = current.getRepresentedEditPart();
            if (ep != null) {
                Command cmd;
                req = new ShowHideElementsRequest((EditPart)ep);
                EditPart parent = ep.getParent();
                if (parent instanceof CompartmentEditPart) {
                    parent = parent.getParent();
                }
                if ((cmd = parent.getCommand((Request)req)) == null || !cmd.canExecute()) continue;
                completeCmd.add(cmd);
                continue;
            }
            Activator.log.error("the edit part for this representation " + current + " should not be null", null);
        }
        Point propertyLocation = new Point();
        Point portLocation = new Point(-10, -2 * INCREMENT + 1);
        for (AbstractShowHideAction.EditPartRepresentation rep : this.viewsToCreate) {
            if (!(rep instanceof OptionalEditPartRepresentation)) continue;
            OptionalEditPartRepresentation optRep = (OptionalEditPartRepresentation)rep;
            IGraphicalEditPart ep = optRep.getParentRepresentation().getParentRepresentation().getRepresentedEditPart();
            View compartmentView = optRep.getParentRepresentation().getRepresentedEditPart().getNotationView();
            if (compartmentView == null) continue;
            req = new ShowHideElementsRequest(compartmentView, optRep.getSemanticElement());
            if (this.isXYLayout(compartmentView, (EditPart)ep)) {
                propertyLocation.x += INCREMENT;
                propertyLocation.y += INCREMENT;
                req.setLocation(new Point(propertyLocation));
            } else if (this.isAffixedChildNode((EditPart)ep, optRep.getSemanticElement())) {
                portLocation.y += INCREMENT;
                Point initialPosition = this.getInitialPortLocation((EditPart)ep, optRep.getSemanticElement());
                if (initialPosition != null) {
                    req.setLocation(initialPosition);
                } else {
                    req.setLocation(new Point(portLocation));
                }
            }
            Command cmd = ep.getCommand((Request)req);
            if (cmd == null || !cmd.canExecute()) continue;
            completeCmd.add(cmd);
        }
        return completeCmd;
    }

    public Point getInitialPortLocation(EditPart partEditPart, EObject port) {
        return null;
    }

    protected boolean isAffixedChildNode(EditPart ep, EObject child) {
        CreateViewRequest.ViewDescriptor viewDescriptor;
        TransactionalEditingDomain domain = ((IGraphicalEditPart)ep).getEditingDomain();
        CreateCommand cmd = new CreateCommand(domain, viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(child), Node.class, null, -1, false, ((IGraphicalEditPart)ep).getDiagramPreferencesHint()), (View)ep.getModel());
        return cmd.canExecute();
    }

    protected boolean isXYLayout(View compartment, EditPart ep) {
        List children = ep.getChildren();
        for (Object current : children) {
            EditPolicy editpolicy;
            if (!(current instanceof EditPart) || ((EditPart)current).getModel() != compartment || (editpolicy = ((EditPart)current).getEditPolicy((Object)"LayoutEditPolicy")) == null) continue;
            return true;
        }
        return false;
    }

    protected List<EditPart> getChildrenEditPart(EditPart ep) {
        ArrayList<EditPart> children = new ArrayList<EditPart>();
        List tmp = ep.getChildren();
        for (Object current : tmp) {
            if (current instanceof ITextAwareEditPart) continue;
            if (current instanceof CompartmentEditPart) {
                children.addAll(((CompartmentEditPart)current).getChildren());
                continue;
            }
            children.add((EditPart)current);
        }
        return children;
    }

    protected View getCompartmentForCreation(EditPart editPart, EObject child) {
        if (this.isAffixedChildNode(editPart, child)) {
            return (View)editPart.getModel();
        }
        TransactionalEditingDomain domain = ((IGraphicalEditPart)editPart).getEditingDomain();
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(child), Node.class, null, -1, false, ((IGraphicalEditPart)editPart).getDiagramPreferencesHint());
        EList visibleCompartments = ((IGraphicalEditPart)editPart).getNotationView().getVisibleChildren();
        for (View currentComp : visibleCompartments) {
            CreateCommand cmd = new CreateCommand(domain, viewDescriptor, currentComp);
            if (!cmd.canExecute()) continue;
            return currentComp;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildShowHideElementsList(Object[] results) {
        void var3_4;
        super.buildShowHideElementsList(results);
        ArrayList<Object> result = new ArrayList<Object>();
        boolean bl = false;
        while (var3_4 < results.length) {
            if (!(results[var3_4] instanceof RootEditPartRepresentation) && !(results[var3_4] instanceof CompartmentEditPartRepresentation)) {
                result.add(results[var3_4]);
            }
            ++var3_4;
        }
        for (Object e : result) {
            if (this.initialSelection.contains(e) || !(e instanceof AbstractShowHideAction.EditPartRepresentation)) continue;
            this.viewsToCreate.add((AbstractShowHideAction.EditPartRepresentation)e);
        }
        for (Object e : this.initialSelection) {
            if (result.contains(e) || !(e instanceof AbstractShowHideAction.EditPartRepresentation)) continue;
            this.viewsToDestroy.add((AbstractShowHideAction.EditPartRepresentation)e);
        }
    }

    protected AbstractShowHideAction.EditPartRepresentation findEditPartRepresentation(Object element) {
        for (AbstractShowHideAction.EditPartRepresentation current : this.representations) {
            if (current.getPossibleElement().contains(element)) {
                return current;
            }
            EList views = current.getRepresentedEditPart().getNotationView().getChildren();
            if (!views.contains(element)) continue;
            return current;
        }
        return null;
    }

    protected class AffixedChildrenEditPartRepresentation
    extends CompartmentEditPartRepresentation {
        public AffixedChildrenEditPartRepresentation(EObject element, AbstractShowHideAction.EditPartRepresentation parentRepresentation) {
            super(null, element, parentRepresentation);
        }

        @Override
        protected boolean canContain(Element element) {
            TransactionalEditingDomain domain = this.getParentRepresentation().getRepresentedEditPart().getEditingDomain();
            CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)element), Node.class, null, -1, false, this.getParentRepresentation().getRepresentedEditPart().getDiagramPreferencesHint());
            CreateCommand cmd = new CreateCommand(domain, viewDescriptor, this.getParentRepresentation().getRepresentedEditPart().getNotationView());
            return cmd.canExecute();
        }

        @Override
        public IGraphicalEditPart getRepresentedEditPart() {
            return this.getParentRepresentation().getRepresentedEditPart();
        }

        @Override
        public String getLabel() {
            return "Border Items";
        }

        @Override
        protected void initRepresentation() {
            this.initialSelection = new ArrayList();
            this.elementsToSelect = new ArrayList();
            block0: for (Element nextMember : this.collectMembers()) {
                if (!this.canContain(nextMember)) continue;
                OptionalEditPartRepresentation editPartRepresentation = new OptionalEditPartRepresentation(null, nextMember, this);
                this.elementsToSelect.add(editPartRepresentation);
                EList childrenView = this.getParentRepresentation().getRepresentedEditPart().getNotationView().getVisibleChildren();
                for (Object object : childrenView) {
                    if (!(object instanceof View) || ((View)object).getElement() != nextMember) continue;
                    this.initialSelection.add(editPartRepresentation);
                    for (Object o : this.getParentRepresentation().getRepresentedEditPart().getChildren()) {
                        if (!(o instanceof IGraphicalEditPart) || !((View)object).equals(((IGraphicalEditPart)o).getNotationView())) continue;
                        editPartRepresentation.setRepresentedEditPart((IGraphicalEditPart)o);
                        continue block0;
                    }
                    continue block0;
                }
            }
        }
    }

    protected class CompartmentEditPartRepresentation
    extends AbstractShowHideAction.EditPartRepresentation {
        public CompartmentEditPartRepresentation(IResizableCompartmentEditPart compartmentEditPart, EObject element, AbstractShowHideAction.EditPartRepresentation parentRepresentation) {
            super(ShowHideContentsAction.this, (IGraphicalEditPart)compartmentEditPart, element, parentRepresentation);
        }

        @Override
        public String getLabel() {
            if (this.getRepresentedEditPart() instanceof IResizableCompartmentEditPart) {
                return ((IResizableCompartmentEditPart)this.getRepresentedEditPart()).getCompartmentName();
            }
            return super.getLabel();
        }

        protected List<Element> collectMembers() {
            if (this.getSemanticElement() instanceof Classifier) {
                return new ArrayList<Element>((Collection<Element>)((Classifier)this.getSemanticElement()).getMembers());
            }
            if (this.getSemanticElement() instanceof InstanceSpecification) {
                return new ArrayList<Element>((Collection<Element>)((InstanceSpecification)this.getSemanticElement()).getSlots());
            }
            return Collections.emptyList();
        }

        @Override
        protected void initRepresentation() {
            super.initRepresentation();
            block0: for (Element nextMember : this.collectMembers()) {
                if (!this.canContain(nextMember)) continue;
                OptionalEditPartRepresentation editPartRepresentation = new OptionalEditPartRepresentation(null, nextMember, this);
                this.elementsToSelect.add(editPartRepresentation);
                EList childrenView = this.getRepresentedEditPart().getNotationView().getVisibleChildren();
                for (Object object : childrenView) {
                    if (!(object instanceof View) || ((View)object).getElement() != nextMember) continue;
                    this.initialSelection.add(editPartRepresentation);
                    for (Object o : this.getRepresentedEditPart().getChildren()) {
                        if (!(o instanceof IGraphicalEditPart) || !((View)object).equals(((IGraphicalEditPart)o).getNotationView())) continue;
                        editPartRepresentation.setRepresentedEditPart((IGraphicalEditPart)o);
                    }
                    continue block0;
                }
            }
        }

        protected boolean canContain(Element element) {
            TransactionalEditingDomain domain = this.getRepresentedEditPart().getEditingDomain();
            CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)element), Node.class, null, -1, false, this.getRepresentedEditPart().getDiagramPreferencesHint());
            CreateCommand cmd = new CreateCommand(domain, viewDescriptor, this.getRepresentedEditPart().getNotationView());
            return cmd.canExecute();
        }
    }

    public class ContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractShowHideAction.EditPartRepresentation) {
                return ((AbstractShowHideAction.EditPartRepresentation)parentElement).getPossibleElement().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractShowHideAction.EditPartRepresentation) {
                AbstractShowHideAction.EditPartRepresentation editPartRepresentation = (AbstractShowHideAction.EditPartRepresentation)element;
                return editPartRepresentation.getParentRepresentation();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }
    }

    public class CustomComparator
    implements Comparator<Object> {
        private List<String> classesList;

        public CustomComparator(List<NamedElement> elements) {
            this.buildList(elements);
        }

        public void buildList(List<NamedElement> elements) {
            this.classesList = new ArrayList<String>();
            for (NamedElement namedElement : elements) {
                this.classesList.add(new String(namedElement.getClass().getSimpleName()));
            }
            Collections.sort(this.classesList);
        }

        @Override
        public int compare(Object o1, Object o2) {
            String name1 = o1.getClass().getSimpleName();
            String name2 = o2.getClass().getSimpleName();
            int index1 = this.classesList.indexOf(name1);
            int index2 = this.classesList.indexOf(name2);
            int classIndex = this.classesList.indexOf("ClassImpl");
            if (index1 == index2 && index1 == classIndex) {
                boolean metaclassO1 = Util.isMetaclass((Type)o1);
                boolean metaclassO2 = Util.isMetaclass((Type)o2);
                if (metaclassO1 && !metaclassO2) {
                    return 1;
                }
                if (!metaclassO1 && metaclassO2) {
                    return -1;
                }
                return 0;
            }
            if (index1 == -1) {
                Activator.log.debug("The class " + name1 + " is unknown by " + this.getClass());
                return -1;
            }
            if (index1 == index2) {
                return 0;
            }
            if (index1 > index2) {
                return 1;
            }
            if (index1 < index2) {
                return -1;
            }
            return 0;
        }
    }

    protected class OptionalEditPartRepresentation
    extends AbstractShowHideAction.EditPartRepresentation {
        public OptionalEditPartRepresentation(IGraphicalEditPart representedEditPart, Element element, CompartmentEditPartRepresentation parentRepresentation) {
            super(ShowHideContentsAction.this, representedEditPart, (EObject)element, parentRepresentation);
        }

        @Override
        public CompartmentEditPartRepresentation getParentRepresentation() {
            return (CompartmentEditPartRepresentation)super.getParentRepresentation();
        }
    }

    protected class PortAffixedChildrenEditPartRepresentation
    extends AffixedChildrenEditPartRepresentation {
        public PortAffixedChildrenEditPartRepresentation(EObject element, AbstractShowHideAction.EditPartRepresentation parentRepresentation) {
            super(element, parentRepresentation);
        }

        @Override
        protected List<Element> collectMembers() {
            Port port;
            Type type;
            ArrayList<Element> res = new ArrayList<Element>();
            EObject semanticElement = this.getSemanticElement();
            if (semanticElement instanceof Port && (type = (port = (Port)semanticElement).getType()) != null && type instanceof Classifier) {
                EList allAttributes = ((Classifier)type).getAllAttributes();
                for (Element element : allAttributes) {
                    if (!(element instanceof Port)) continue;
                    res.add(element);
                }
                return res;
            }
            return Collections.emptyList();
        }

        @Override
        protected boolean canContain(Element element) {
            TransactionalEditingDomain domain = this.getParentRepresentation().getRepresentedEditPart().getEditingDomain();
            CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)element), Node.class, "Port_Shape", -1, false, this.getParentRepresentation().getRepresentedEditPart().getDiagramPreferencesHint());
            CreateCommand cmd = new CreateCommand(domain, viewDescriptor, this.getParentRepresentation().getRepresentedEditPart().getNotationView());
            return cmd.canExecute();
        }
    }

    protected class RootEditPartRepresentation
    extends AbstractShowHideAction.EditPartRepresentation {
        public RootEditPartRepresentation(IGraphicalEditPart representedEditPart, EObject element) {
            super(ShowHideContentsAction.this, representedEditPart, element);
        }

        @Override
        protected void initRepresentation() {
            super.initRepresentation();
            IGraphicalEditPart representedEditPart = this.getRepresentedEditPart();
            List<IResizableCompartmentEditPart> compartmentEditParts = CompartmentUtils.getAllCompartmentsEditPart((EditPart)representedEditPart, false);
            for (IResizableCompartmentEditPart currentEditPart : compartmentEditParts) {
                CompartmentEditPartRepresentation representation = new CompartmentEditPartRepresentation(currentEditPart, this.getSemanticElement(), (AbstractShowHideAction.EditPartRepresentation)this);
                this.elementsToSelect.add(representation);
            }
            EditPolicy policy = representedEditPart.getEditPolicy((Object)"affixed node alignment editpolicy");
            if (policy != null) {
                AffixedChildrenEditPartRepresentation representation = this.getSemanticElement() instanceof Port ? new PortAffixedChildrenEditPartRepresentation(this.getSemanticElement(), this) : new AffixedChildrenEditPartRepresentation(this.getSemanticElement(), this);
                this.elementsToSelect.add(representation);
            }
        }
    }
}

