/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.formatting;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FormattingService {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;
    @Inject
    private IIndentationInformation indentationInformation;

    public List<? extends TextEdit> format(Document document, XtextResource resource, DocumentFormattingParams params, CancelIndicator cancelIndicator) {
        boolean offset = false;
        int length = document.getContents().length();
        if (length == 0 || resource.getContents().isEmpty()) {
            return CollectionLiterals.emptyList();
        }
        boolean _hasFormatOverride = OverrideChecker.hasFormatOverride(this.getClass());
        if (_hasFormatOverride) {
            return this.format(resource, document, 0, length);
        }
        return this.format(resource, document, 0, length, params.getOptions());
    }

    public List<? extends TextEdit> format(Document document, XtextResource resource, DocumentRangeFormattingParams params, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getRange().getStart());
        int _offSet = document.getOffSet(params.getRange().getEnd());
        int length = _offSet - offset;
        boolean _hasFormatOverride = OverrideChecker.hasFormatOverride(this.getClass());
        if (_hasFormatOverride) {
            return this.format(resource, document, offset, length);
        }
        return this.format(resource, document, offset, length, params.getOptions());
    }

    @Deprecated
    public List<TextEdit> format(XtextResource resource, Document document, int offset, int length) {
        return this.format(resource, document, offset, length, null);
    }

    public List<TextEdit> format(XtextResource resource, Document document, int offset, int length, FormattingOptions options) {
        boolean _isInsertSpaces;
        String indent = this.indentationInformation.getIndentString();
        if (options != null && (_isInsertSpaces = options.isInsertSpaces())) {
            indent = Strings.padEnd((String)"", (int)options.getTabSize(), (char)' ');
        }
        if (this.formatter2Provider != null) {
            MapBasedPreferenceValues preferences = new MapBasedPreferenceValues();
            preferences.put("indentation", indent);
            TextRegion _textRegion = new TextRegion(offset, length);
            List<ITextReplacement> replacements = this.format2(resource, (ITextRegion)_textRegion, (ITypedPreferenceValues)preferences);
            Functions.Function1 _function = r -> this.toTextEdit(document, r.getReplacementText(), r.getOffset(), r.getLength());
            return IterableExtensions.toList((Iterable)ListExtensions.map(replacements, (Functions.Function1)_function));
        }
        return CollectionLiterals.newArrayList();
    }

    protected TextEdit toTextEdit(Document document, String formattedText, int startOffset, int length) {
        TextEdit _textEdit = new TextEdit();
        Procedures.Procedure1 _function = it -> {
            it.setNewText(formattedText);
            Range _range = new Range();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setStart(document.getPosition(startOffset));
                it_1.setEnd(document.getPosition(startOffset + length));
            };
            Range _doubleArrow = (Range)ObjectExtensions.operator_doubleArrow((Object)_range, (Procedures.Procedure1)_function_1);
            it.setRange(_doubleArrow);
        };
        return (TextEdit)ObjectExtensions.operator_doubleArrow((Object)_textEdit, (Procedures.Procedure1)_function);
    }

    protected List<ITextReplacement> format2(XtextResource resource, ITextRegion selection, ITypedPreferenceValues preferences) {
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setAllowIdentityEdits(false);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        if (selection != null) {
            request.setRegions(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ITextRegion[]{selection})));
        }
        if (preferences != null) {
            request.setPreferences(preferences);
        }
        ITextRegionAccess regionAccess = this.regionBuilder.forNodeModel(resource).create();
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        return replacements;
    }

    private static class OverrideChecker {
        private static final Map<Class<?>, Boolean> CLASSES_WITH_OVERRIDES = new ConcurrentHashMap();

        private OverrideChecker() {
        }

        public static boolean hasFormatOverride(Class<? extends FormattingService> formattingServiceClass) {
            Boolean result = CLASSES_WITH_OVERRIDES.get(formattingServiceClass);
            if (result == null) {
                try {
                    result = Boolean.FALSE;
                    for (Class<? extends FormattingService> theClass = formattingServiceClass; !result.booleanValue() && theClass != FormattingService.class; theClass = theClass.getSuperclass()) {
                        try {
                            theClass.getDeclaredMethod("format", XtextResource.class, Document.class, Integer.TYPE, Integer.TYPE);
                            result = Boolean.TRUE;
                            continue;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof NoSuchMethodException) continue;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        result = Boolean.TRUE;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                CLASSES_WITH_OVERRIDES.put(formattingServiceClass, result);
            }
            return result;
        }
    }
}

