/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/ 
 * 
 *  SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.validation.rules.modelelements;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.sysml14.modelelements.Expose;
import org.eclipse.papyrus.sysml14.modelelements.View;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * 7.3.2.3 Expose [1] The client must be an element stereotyped by View.
 * FIXME : the norm is incorrect there may be many client, the rule will apply to all clients
 *  
 */
public class ExposeClientStereotypedByViewModelConstraint extends AbstractModelConstraint {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.
	 * emf.validation.IValidationContext)
	 */
	@Override
	public IStatus validate(IValidationContext context) {
		Expose expose = (Expose) context.getTarget();
		Dependency dependency = expose.getBase_Dependency();
		if (dependency != null) {
			EList<NamedElement> clients = dependency.getClients();
			for (NamedElement namedElement : clients) {
				if (UMLUtil.getStereotypeApplication(namedElement, View.class) == null) {
					return context.createFailureStatus(context.getTarget());
				}				
			}
		}
		return context.createSuccessStatus();
	}
}
