/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CellTextAlignment implements Enumerator
{
    TOP_LEFT(1, "TOP_LEFT", "TOP_LEFT"),
    TOP_CENTER(2, "TOP_CENTER", "TOP_CENTER"),
    TOP_RIGHT(3, "TOP_RIGHT", "TOP_RIGHT"),
    MIDDLE_LEFT(4, "MIDDLE_LEFT", "MIDDLE_LEFT"),
    MIDDLE_CENTER(5, "MIDDLE_CENTER", "MIDDLE_CENTER"),
    MIDDLE_RIGHT(6, "MIDDLE_RIGHT", "MIDDLE_RIGHT"),
    BOTTOM_LEFT(7, "BOTTOM_LEFT", "BOTTOM_LEFT"),
    BOTTOM_CENTER(8, "BOTTOM_CENTER", "BOTTOM_CENTER"),
    BOTTOM_RIGHT(9, "BOTTOM_RIGHT", "BOTTOM_RIGHT");

    public static final int TOP_LEFT_VALUE = 1;
    public static final int TOP_CENTER_VALUE = 2;
    public static final int TOP_RIGHT_VALUE = 3;
    public static final int MIDDLE_LEFT_VALUE = 4;
    public static final int MIDDLE_CENTER_VALUE = 5;
    public static final int MIDDLE_RIGHT_VALUE = 6;
    public static final int BOTTOM_LEFT_VALUE = 7;
    public static final int BOTTOM_CENTER_VALUE = 8;
    public static final int BOTTOM_RIGHT_VALUE = 9;
    private static final CellTextAlignment[] VALUES_ARRAY;
    public static final List<CellTextAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CellTextAlignment[]{TOP_LEFT, TOP_CENTER, TOP_RIGHT, MIDDLE_LEFT, MIDDLE_CENTER, MIDDLE_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER, BOTTOM_RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CellTextAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CellTextAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CellTextAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CellTextAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CellTextAlignment get(int value) {
        switch (value) {
            case 1: {
                return TOP_LEFT;
            }
            case 2: {
                return TOP_CENTER;
            }
            case 3: {
                return TOP_RIGHT;
            }
            case 4: {
                return MIDDLE_LEFT;
            }
            case 5: {
                return MIDDLE_CENTER;
            }
            case 6: {
                return MIDDLE_RIGHT;
            }
            case 7: {
                return BOTTOM_LEFT;
            }
            case 8: {
                return BOTTOM_CENTER;
            }
            case 9: {
                return BOTTOM_RIGHT;
            }
        }
        return null;
    }

    private CellTextAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

