/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.architecture.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.gmfdiag.style.StyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.uml.diagram.common.commands.AbstractModelConversionCommand;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.StructuredClassifier;

public class UMLModelConversionCommand
extends AbstractModelConversionCommand {
    public void doConvertModel(ModelSet modelSet) {
        Resource notationResource = NotationUtils.getNotationResource((ModelSet)modelSet);
        if (notationResource != null) {
            for (EObject eObject : notationResource.getContents()) {
                if (eObject instanceof Diagram) {
                    this.convertDiagram((Diagram)eObject);
                    continue;
                }
                if (!(eObject instanceof Table)) continue;
                this.convertTable((Table)eObject);
            }
        }
    }

    protected void convertDiagram(Diagram diagram) {
        PapyrusDiagram kind;
        String diagramKindId = null;
        PapyrusDiagramStyle pvs = DiagramUtils.getPapyrusDiagramStyle((Diagram)diagram);
        if (pvs != null) {
            diagramKindId = pvs.getDiagramKindId();
        }
        if (diagramKindId != null && (kind = this.getDiagramKindById(diagramKindId)) != null && "org.eclipse.papyrus.infra.services.edit.TypeContext".equals(kind.getLanguage().getId())) {
            return;
        }
        PapyrusDiagram diagramKind = null;
        if ("PapyrusUMLActivityDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.activity");
        } else if ("PapyrusUMLClassDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.class");
        } else if ("PapyrusUMLCommunicationDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.communication");
        } else if ("PapyrusUMLComponentDiagram".equals(diagram.getType())) {
            if (diagram.getElement() instanceof Component) {
                diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.component.root.component");
            } else if (diagram.getElement() instanceof Package) {
                diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.component.root.package");
            }
        } else if ("CompositeStructure".equals(diagram.getType())) {
            if (diagram.getElement() instanceof StructuredClassifier) {
                diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.compositeStructure.root.structuredClassifier");
            } else if (diagram.getElement() instanceof Package) {
                diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.compositeStructure.root.package");
            }
        } else if ("PapyrusUMLDeploymentDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.deployment");
        } else if ("PapyrusUMLInteractionOverviewDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.interactionOverview");
        } else if ("PapyrusUMLProfileDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.profile");
        } else if ("PapyrusUMLSequenceDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.sequence");
        } else if ("PapyrusUMLStateMachineDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.stateMachine");
        } else if ("PapyrusUMLTimingDiagram".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.timing");
        } else if ("UseCase".equals(diagram.getType())) {
            diagramKind = this.getDiagramKindById("org.eclipse.papyrus.uml.diagram.useCase");
        }
        if (diagramKind != null) {
            if (pvs == null) {
                pvs = StyleFactory.eINSTANCE.createPapyrusDiagramStyle();
                pvs.setOwner(diagram.getElement());
                diagram.getStyles().add((Object)pvs);
            }
            pvs.setDiagramKindId(diagramKind.getId());
        }
    }

    protected void convertTable(Table table) {
        PapyrusTable kind;
        String tableKindId = table.getTableKindId();
        if (tableKindId != null && (kind = this.getTableKindById(tableKindId)) != null && "org.eclipse.papyrus.infra.services.edit.TypeContext".equals(kind.getLanguage().getId())) {
            return;
        }
        kind = this.getTableKindById("org.eclipse.papyrus.uml.table.generic");
        if (kind != null) {
            table.setTableKindId(kind.getId());
            table.setTableConfiguration(kind.getConfiguration());
        }
    }

    private PapyrusDiagram getDiagramKindById(String id) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        RepresentationKind kind = manager.getRepresentationKindById(id);
        return kind instanceof PapyrusDiagram ? (PapyrusDiagram)kind : null;
    }

    private PapyrusTable getTableKindById(String id) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        RepresentationKind kind = manager.getRepresentationKindById(id);
        return kind instanceof PapyrusTable ? (PapyrusTable)kind : null;
    }
}

