/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.formatting2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegions;

public abstract class AbstractCSSFormatter
extends AbstractFormatter2 {
    protected List<ITextReplacement> postProcess(IFormattableDocument document, List<ITextReplacement> replacements) {
        ArrayList expected = Lists.newArrayList();
        IHiddenRegion current = this.getTextRegionAccess().regionForRootEObject().getPreviousHiddenRegion();
        while (current != null) {
            if (current.isUndefined()) {
                expected.addAll(current.getMergedSpaces());
            }
            current = current.getNextHiddenRegion();
        }
        if (expected.isEmpty()) {
            return replacements;
        }
        List missing = TextRegions.difference((Iterable)expected, replacements);
        if (missing.isEmpty()) {
            return replacements;
        }
        ArrayList result = Lists.newArrayList(replacements);
        for (ITextSegment seg : missing) {
            IHiddenRegion h = null;
            if (seg instanceof IHiddenRegion) {
                h = (IHiddenRegion)seg;
            }
            if (seg instanceof IHiddenRegionPart) {
                h = ((IHiddenRegionPart)seg).getHiddenRegion();
            }
            if (h != null && (h.getNextSemanticRegion() == null || h.getPreviousSemanticRegion() == null)) {
                result.add(seg.replaceWith(""));
                continue;
            }
            result.add(seg.replaceWith(""));
        }
        return result;
    }
}

