/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.ruler;

import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class SnapToGuidesEx
extends SnapToGuides {
    private int[] verticalGuidesMM;
    private int[] horizontalGuidesMM;

    public SnapToGuidesEx(GraphicalEditPart container) {
        super(container);
    }

    protected double getThreshold() {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this.container.getFigure());
        return mm.DPtoLP((int)super.getThreshold());
    }

    protected int[] getHorizontalGuides() {
        if (this.horizontalGuidesMM == null) {
            int[] guides = super.getHorizontalGuides();
            IMapMode mm = MapModeUtil.getMapMode((IFigure)this.container.getFigure());
            this.horizontalGuidesMM = new int[guides.length];
            int i = 0;
            while (i < guides.length) {
                int guide = guides[i];
                this.horizontalGuidesMM[i] = mm.DPtoLP(guide);
                ++i;
            }
        }
        return this.horizontalGuidesMM;
    }

    protected int[] getVerticalGuides() {
        if (this.verticalGuidesMM == null) {
            int[] guides = super.getVerticalGuides();
            IMapMode mm = MapModeUtil.getMapMode((IFigure)this.container.getFigure());
            this.verticalGuidesMM = new int[guides.length];
            int i = 0;
            while (i < guides.length) {
                int guide = guides[i];
                this.verticalGuidesMM[i] = mm.DPtoLP(guide);
                ++i;
            }
        }
        return this.verticalGuidesMM;
    }

    protected double getCorrectionFor(int[] guides, double value, Map extendedData, boolean vert, int side) {
        boolean increaseOK;
        Integer restrictedDirections = (Integer)extendedData.get("org.eclipse.gmf.runtime.diagram.ui.RestrictedDirections");
        if (restrictedDirections == null || restrictedDirections == 0) {
            return super.getCorrectionFor(guides, value, extendedData, vert, side);
        }
        if (restrictedDirections == 0) {
            return super.getCorrectionFor(guides, value, extendedData, vert, side);
        }
        boolean bl = vert ? (restrictedDirections & 0x10) != 0 : (increaseOK = (restrictedDirections & 4) != 0);
        boolean decreaseOK = vert ? (restrictedDirections & 8) != 0 : (restrictedDirections & 1) != 0;
        int[] filteredGuides = new int[guides.length];
        int count = 0;
        int i = 0;
        while (i < guides.length) {
            if (increaseOK && (double)guides[i] > value || decreaseOK && (double)guides[i] < value) {
                filteredGuides[count++] = guides[i];
            }
            ++i;
        }
        int[] filteredGuides2 = new int[count];
        int i2 = 0;
        while (i2 < count) {
            filteredGuides2[i2] = filteredGuides[i2];
            ++i2;
        }
        return super.getCorrectionFor(filteredGuides2, value, extendedData, vert, side);
    }
}

