/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.util;

import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;

public class CMDataTypeValueHelper {
    protected int idCount = 0;

    public String getValue(CMAttributeDeclaration ad, NamespaceTable namespaceTable) {
        CMDataType dataType;
        String value = null;
        if (this.isXSIType(ad)) {
            List list = this.getQualifiedXSITypes(ad, namespaceTable);
            String string = value = list.size() > 0 ? (String)list.get(0) : null;
        }
        if (value == null && ad.getAttrName().equals("xml:lang")) {
            value = "EN";
        }
        if (value == null && (dataType = ad.getAttrType()) != null) {
            value = this.getValue(dataType);
        }
        return value;
    }

    public String getValue(CMDataType dataType) {
        String dataTypeName;
        String[] values;
        String value = null;
        value = dataType.getImpliedValue();
        if (value == null && (values = dataType.getEnumeratedValues()) != null && values.length > 0) {
            value = values[0];
        }
        if (value == null) {
            value = dataType.generateInstanceValue();
        }
        if (value == null && (dataTypeName = dataType.getDataTypeName()) != null) {
            if (dataTypeName.equals("ID")) {
                value = "idvalue" + this.idCount++;
            } else if (dataTypeName.equals("IDREF") || dataTypeName.equals("IDREFS")) {
                value = "idvalue0";
            }
        }
        return value;
    }

    public boolean isValidEmptyValue(CMAttributeDeclaration ad) {
        String propertyValue;
        boolean result = true;
        CMDataType dataType = ad.getAttrType();
        if (dataType != null && (propertyValue = (String)dataType.getProperty("isValidEmptyValue")) != null && propertyValue.equals("false")) {
            result = false;
        }
        return result;
    }

    public boolean isXSIType(CMAttributeDeclaration ad) {
        String namespaceName;
        CMDocument cmDocument;
        boolean result = false;
        if (ad.getNodeName().equals("type") && (cmDocument = (CMDocument)ad.getProperty("CMDocument")) != null && (namespaceName = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) != null && namespaceName.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            result = true;
        }
        return result;
    }

    public List getQualifiedXSITypes(CMAttributeDeclaration ad, NamespaceTable table) {
        Vector<String> list = new Vector<String>();
        List xsiTypes = (List)ad.getProperty("XSITypes");
        if (xsiTypes != null && xsiTypes.size() > 0) {
            for (String uriQualifiedName : xsiTypes) {
                String[] components = DOMNamespaceHelper.getURIQualifiedNameComponents(uriQualifiedName);
                String prefix = table.getPrefixForURI(components[0] != null ? components[0] : "");
                String typeName = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + components[1] : components[1];
                list.add(typeName);
            }
        }
        return list;
    }
}

