/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.painter.cell.GraphicsUtils;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class BorderPainter {
    protected BorderCell[][] borderCells;
    protected BorderStyle borderStyle;
    protected PaintModeEnum paintMode;

    public BorderPainter(BorderCell[][] borderCells, BorderStyle borderStyle) {
        this(borderCells, borderStyle, PaintModeEnum.ALL);
    }

    public BorderPainter(BorderCell[][] borderCells, BorderStyle borderStyle, PaintModeEnum paintMode) {
        this.borderCells = borderCells;
        this.borderStyle = borderStyle;
        this.paintMode = paintMode;
    }

    public void paintBorder(GC gc) {
        if (this.borderStyle != null) {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(this.borderStyle.getLineStyle()));
            gc.setLineWidth(this.borderStyle.getThickness());
            gc.setForeground(this.borderStyle.getColor());
        }
        int iy = 0;
        while (iy < this.borderCells.length) {
            int ix = 0;
            while (ix < this.borderCells[iy].length) {
                if ((this.paintMode != PaintModeEnum.NO_EXTERNAL_CELLS || ix != 0 && iy != 0 && ix != this.borderCells[iy].length - 1 && iy != this.borderCells.length - 1) && this.isInside(ix, iy)) {
                    if (!(this.paintMode == PaintModeEnum.NO_EXTERNAL_BORDERS && ix <= 0 || this.isInside(ix - 1, iy))) {
                        this.drawLineLeft(gc, ix, iy);
                    }
                    if (!(this.paintMode == PaintModeEnum.NO_EXTERNAL_BORDERS && ix >= this.borderCells[iy].length - 1 || this.isInside(ix + 1, iy))) {
                        this.drawLineRight(gc, ix, iy);
                    }
                    if (!(this.paintMode == PaintModeEnum.NO_EXTERNAL_BORDERS && iy <= 0 || this.isInside(ix, iy - 1))) {
                        this.drawLineTop(gc, ix, iy);
                    }
                    if (!(this.paintMode == PaintModeEnum.NO_EXTERNAL_BORDERS && iy >= this.borderCells.length - 1 || this.isInside(ix, iy + 1))) {
                        this.drawLineBottom(gc, ix, iy);
                    }
                }
                ++ix;
            }
            ++iy;
        }
    }

    protected LineValues getLineValuesLeft(int ix, int iy) {
        int l;
        int y;
        int x = this.borderCells[iy][ix].bounds.x;
        if (this.isValid(ix - 1, iy)) {
            y = Math.max(this.borderCells[iy][ix].bounds.y, this.borderCells[iy][ix - 1].bounds.y);
            l = Math.min(this.borderCells[iy][ix].bounds.y + this.borderCells[iy][ix].bounds.height, this.borderCells[iy][ix - 1].bounds.y + this.borderCells[iy][ix - 1].bounds.height) - y;
        } else {
            y = this.borderCells[iy][ix].bounds.y;
            l = this.borderCells[iy][ix].bounds.height;
        }
        return new LineValues(x, y, l);
    }

    protected LineValues getLineValuesRight(int ix, int iy) {
        int l;
        int y;
        int x = this.borderCells[iy][ix].bounds.x + this.borderCells[iy][ix].bounds.width - 1;
        if (this.isValid(ix + 1, iy)) {
            y = Math.max(this.borderCells[iy][ix].bounds.y, this.borderCells[iy][ix + 1].bounds.y);
            l = Math.min(this.borderCells[iy][ix].bounds.y + this.borderCells[iy][ix].bounds.height, this.borderCells[iy][ix + 1].bounds.y + this.borderCells[iy][ix + 1].bounds.height) - y;
        } else {
            y = this.borderCells[iy][ix].bounds.y;
            l = this.borderCells[iy][ix].bounds.height;
        }
        return new LineValues(x, y, l);
    }

    protected LineValues getLineValuesTop(int ix, int iy) {
        int l;
        int x;
        if (this.isValid(ix, iy - 1)) {
            x = Math.max(this.borderCells[iy][ix].bounds.x, this.borderCells[iy - 1][ix].bounds.x);
            l = Math.min(this.borderCells[iy][ix].bounds.x + this.borderCells[iy][ix].bounds.width, this.borderCells[iy - 1][ix].bounds.x + this.borderCells[iy - 1][ix].bounds.width) - x;
        } else {
            x = this.borderCells[iy][ix].bounds.x;
            l = this.borderCells[iy][ix].bounds.width;
        }
        int y = this.borderCells[iy][ix].bounds.y;
        return new LineValues(x, y, l);
    }

    protected LineValues getLineValuesBottom(int ix, int iy) {
        int l;
        int x;
        if (this.isValid(ix, iy + 1)) {
            x = Math.max(this.borderCells[iy][ix].bounds.x, this.borderCells[iy + 1][ix].bounds.x);
            l = Math.min(this.borderCells[iy][ix].bounds.x + this.borderCells[iy][ix].bounds.width, this.borderCells[iy + 1][ix].bounds.x + this.borderCells[iy + 1][ix].bounds.width) - x;
        } else {
            x = this.borderCells[iy][ix].bounds.x;
            l = this.borderCells[iy][ix].bounds.width;
        }
        int y = this.borderCells[iy][ix].bounds.y + this.borderCells[iy][ix].bounds.height - 1;
        return new LineValues(x, y, l);
    }

    protected void drawLineLeft(GC gc, int ix, int iy) {
        LineValues lineValues = this.getLineValuesLeft(ix, iy);
        int x = lineValues.x;
        int y = lineValues.y;
        int l = lineValues.lenght;
        boolean drawTopCorner = false;
        boolean drawBottomCorner = false;
        BorderStyle.BorderModeEnum borderMode = this.borderStyle.getBorderMode();
        if (!this.isInside(ix, iy - 1)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawTopCorner = true;
            }
        } else if (this.isInside(ix - 1, iy - 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawTopCorner = true;
        }
        if (!this.isInside(ix, iy + 1)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawBottomCorner = true;
            }
        } else if (this.isInside(ix - 1, iy + 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawBottomCorner = true;
        }
        switch (borderMode) {
            case CENTERED: {
                GraphicsUtils.drawLineVertical(gc, x, y, l, drawTopCorner, drawBottomCorner);
                break;
            }
            case EXTERNAL: {
                GraphicsUtils.drawLineVerticalBorderLeft(gc, x, y, l, drawTopCorner, drawBottomCorner);
                break;
            }
            case INTERNAL: {
                GraphicsUtils.drawLineVerticalBorderRight(gc, x, y, l, drawTopCorner, drawBottomCorner);
            }
        }
    }

    protected void drawLineRight(GC gc, int ix, int iy) {
        LineValues lineValues = this.getLineValuesRight(ix, iy);
        int x = lineValues.x;
        int y = lineValues.y;
        int l = lineValues.lenght;
        boolean drawTopCorner = false;
        boolean drawBottomCorner = false;
        BorderStyle.BorderModeEnum borderMode = this.borderStyle.getBorderMode();
        if (!this.isInside(ix, iy - 1)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawTopCorner = true;
            }
        } else if (this.isInside(ix + 1, iy - 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawTopCorner = true;
        }
        if (!this.isInside(ix, iy + 1)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawBottomCorner = true;
            }
        } else if (this.isInside(ix + 1, iy + 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawBottomCorner = true;
        }
        switch (this.borderStyle.getBorderMode()) {
            case CENTERED: {
                GraphicsUtils.drawLineVertical(gc, x, y, l, drawTopCorner, drawBottomCorner);
                break;
            }
            case EXTERNAL: {
                GraphicsUtils.drawLineVerticalBorderRight(gc, x, y, l, drawTopCorner, drawBottomCorner);
                break;
            }
            case INTERNAL: {
                GraphicsUtils.drawLineVerticalBorderLeft(gc, x, y, l, drawTopCorner, drawBottomCorner);
            }
        }
    }

    protected void drawLineTop(GC gc, int ix, int iy) {
        LineValues lineValues = this.getLineValuesTop(ix, iy);
        int x = lineValues.x;
        int y = lineValues.y;
        int l = lineValues.lenght;
        boolean drawLeftCorner = false;
        boolean drawRightCorner = false;
        BorderStyle.BorderModeEnum borderMode = this.borderStyle.getBorderMode();
        if (!this.isInside(ix - 1, iy)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawLeftCorner = true;
            }
        } else if (this.isInside(ix - 1, iy - 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawLeftCorner = true;
        }
        if (!this.isInside(ix + 1, iy)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawRightCorner = true;
            }
        } else if (this.isInside(ix + 1, iy - 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawRightCorner = true;
        }
        switch (borderMode) {
            case CENTERED: {
                GraphicsUtils.drawLineHorizontal(gc, x, y, l, drawLeftCorner, drawRightCorner);
                break;
            }
            case EXTERNAL: {
                GraphicsUtils.drawLineHorizontalBorderTop(gc, x, y, l, drawLeftCorner, drawRightCorner);
                break;
            }
            case INTERNAL: {
                GraphicsUtils.drawLineHorizontalBorderBottom(gc, x, y, l, drawLeftCorner, drawRightCorner);
            }
        }
    }

    protected void drawLineBottom(GC gc, int ix, int iy) {
        LineValues lineValues = this.getLineValuesBottom(ix, iy);
        int x = lineValues.x;
        int y = lineValues.y;
        int l = lineValues.lenght;
        boolean drawLeftCorner = false;
        boolean drawRightCorner = false;
        BorderStyle.BorderModeEnum borderMode = this.borderStyle.getBorderMode();
        if (!this.isInside(ix - 1, iy)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawLeftCorner = true;
            }
        } else if (this.isInside(ix - 1, iy + 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawLeftCorner = true;
        }
        if (!this.isInside(ix + 1, iy)) {
            if (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.EXTERNAL) {
                drawRightCorner = true;
            }
        } else if (this.isInside(ix + 1, iy + 1) && (borderMode == BorderStyle.BorderModeEnum.CENTERED || borderMode == BorderStyle.BorderModeEnum.INTERNAL)) {
            drawRightCorner = true;
        }
        switch (borderMode) {
            case CENTERED: {
                GraphicsUtils.drawLineHorizontal(gc, x, y, l, drawLeftCorner, drawRightCorner);
                break;
            }
            case EXTERNAL: {
                GraphicsUtils.drawLineHorizontalBorderBottom(gc, x, y, l, drawLeftCorner, drawRightCorner);
                break;
            }
            case INTERNAL: {
                GraphicsUtils.drawLineHorizontalBorderTop(gc, x, y, l, drawLeftCorner, drawRightCorner);
            }
        }
    }

    protected boolean isInside(int ix, int iy) {
        if (!this.isValid(ix, iy)) {
            return false;
        }
        return this.borderCells[iy][ix].isInsideBorder;
    }

    protected boolean isValid(int ix, int iy) {
        if (iy < 0) {
            return false;
        }
        if (ix < 0) {
            return false;
        }
        if (iy >= this.borderCells.length) {
            return false;
        }
        if (ix >= this.borderCells[iy].length) {
            return false;
        }
        if (this.borderCells[iy][ix] == null) {
            return false;
        }
        return this.borderCells[iy][ix].bounds != null;
    }

    public static class BorderCell {
        public Rectangle bounds;
        public boolean isInsideBorder;

        public BorderCell(Rectangle bounds) {
            this(bounds, true);
        }

        public BorderCell(Rectangle bounds, boolean isInsideBorder) {
            this.bounds = bounds;
            this.isInsideBorder = isInsideBorder;
        }
    }

    public static class LineValues {
        public int x;
        public int y;
        public int lenght;

        public LineValues(int x, int y, int lenght) {
            this.x = x;
            this.y = y;
            this.lenght = lenght;
        }
    }

    public static enum PaintModeEnum {
        ALL,
        NO_EXTERNAL_CELLS,
        NO_EXTERNAL_BORDERS;

    }
}

