/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.simplifiedui.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RoboticsLabelProvider
extends UMLFilteredLabelProvider {
    public boolean accept(Object element) {
        if (element instanceof IStructuredSelection) {
            return this.accept((IStructuredSelection)element);
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject == null) {
            return false;
        }
        if (eObject instanceof Connector || eObject instanceof Port) {
            return true;
        }
        return eObject instanceof Element && StereotypeUtil.isApplied((Element)((Element)eObject), ComponentService.class);
    }

    public String getText(Object element) {
        EObject eObject;
        String result = element instanceof IStructuredSelection ? this.getText((IStructuredSelection)element) : ((eObject = EMFHelper.getEObject((Object)element)) != null ? this.getText(eObject) : super.getText(element));
        return result;
    }

    protected String getText(EObject element) {
        if (element instanceof Connector) {
            return InteractionUtils.getConnectorLabel((Connector)((Connector)element));
        }
        if (element instanceof Port) {
            return ((Port)element).getName();
        }
        if (element instanceof Element && StereotypeUtil.isApplied((Element)((Element)element), ComponentService.class)) {
            for (EStructuralFeature.Setting setting : UMLUtil.getNonNavigableInverseReferences((EObject)element)) {
                EObject portEObj = setting.getEObject();
                if (!(portEObj instanceof Port)) continue;
                return String.format("CS for %s", ((Port)portEObj).getName());
            }
        }
        return super.getText(element);
    }
}

