/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.preferences;

import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.robotics.ros2.preferences.Activator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Ros2CodeGenPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public Ros2CodeGenPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("This preferences page allows to customize ROS2 C++ code generation/reverse");
    }

    public void addTextField(String name, String label, Document currentDoc) {
        Group txtGroup = new Group(this.getFieldEditorParent(), 16);
        txtGroup.setLayout((Layout)new FillLayout());
        txtGroup.setText(label);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        txtGroup.setLayoutData((Object)gd);
        SourceViewer txtViewer = new SourceViewer((Composite)txtGroup, null, 2818);
        txtViewer.setDocument((IDocument)currentDoc);
        String content = this.getPreferenceStore().getString(name);
        currentDoc.set(content);
    }

    public void createFieldEditors() {
        String[][] distributions = new String[][]{{"eloquent", "eloquent"}, {"foxy", "foxy"}};
        Composite parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new ComboFieldEditor("rosDistro", "ROS2 distribution", distributions, parent));
        this.addField((FieldEditor)new PathEditor("rosSetupPath", "List of paths (that must contain a setup.bash file) to source", "select a directory with a ROS2 setup.bash", parent));
        this.addField((FieldEditor)new StringFieldEditor("colcon-options", "colcon build options", parent));
        this.addField((FieldEditor)new StringFieldEditor("colcon-packages", "colcon switch to select a certain package (or set thereof)", parent));
        this.addField((FieldEditor)new StringFieldEditor("author-name", "author name, if no information in model", parent));
        this.addField((FieldEditor)new StringFieldEditor("author-mail", "author mail, if no information in model", parent));
        this.addField((FieldEditor)new StringFieldEditor("maintainer-name", "maintainer name, if no information in model", parent));
        this.addField((FieldEditor)new StringFieldEditor("maintainer-mail", "maintainer mail, if no information in model", parent));
    }

    public void init(IWorkbench workbench) {
    }
}

