/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportFMUDialog
extends Dialog {
    protected String selectedDir = "";
    protected String selectedPlatform = "";
    protected boolean embedJre = false;
    protected String selectedJrePath = "";
    protected Button selectTargetDirButton;
    protected Text selectedDirText;
    protected Combo combo;
    protected Button isJreEmbedded;
    protected Button selectJREButton;
    protected Text selectedJrePathText;
    private String fmuName;
    private Text setNameText;

    public ExportFMUDialog(Shell parentShell, String defaultName) {
        super(parentShell);
        this.fmuName = defaultName;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        final Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createSetName(container);
        this.createSelectDir(container);
        this.createSelectPlatform(container);
        this.createEmbbedJRE(container);
        this.createSelectJRE(container);
        this.selectTargetDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = container.getShell();
                DirectoryDialog dirDialog = new DirectoryDialog(shell);
                dirDialog.setText("Select target directory");
                ExportFMUDialog.this.selectedDir = dirDialog.open();
                if (ExportFMUDialog.this.selectedDir != null) {
                    ExportFMUDialog.this.selectedDirText.setText(ExportFMUDialog.this.selectedDir);
                } else {
                    ExportFMUDialog.this.selectedDir = "";
                }
                ExportFMUDialog.this.checkInformation();
            }
        });
        this.setNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportFMUDialog.this.fmuName = ExportFMUDialog.this.setNameText.getText();
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportFMUDialog.this.selectedPlatform = ExportFMUDialog.this.combo.getText();
                ExportFMUDialog.this.checkInformation();
            }
        });
        this.isJreEmbedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bl = ExportFMUDialog.this.embedJre = !ExportFMUDialog.this.embedJre;
                if (ExportFMUDialog.this.embedJre) {
                    ExportFMUDialog.this.selectJREButton.setEnabled(true);
                    ExportFMUDialog.this.selectedJrePathText.setEnabled(true);
                } else {
                    ExportFMUDialog.this.selectJREButton.setEnabled(false);
                    ExportFMUDialog.this.selectedJrePathText.setEnabled(false);
                }
                ExportFMUDialog.this.checkInformation();
            }
        });
        this.selectJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = container.getShell();
                DirectoryDialog dirDialog = new DirectoryDialog(shell);
                dirDialog.setText("Select JRE path");
                ExportFMUDialog.this.selectedJrePath = dirDialog.open();
                if (ExportFMUDialog.this.selectedJrePath != null) {
                    ExportFMUDialog.this.selectedJrePathText.setText(ExportFMUDialog.this.selectedJrePath);
                } else {
                    ExportFMUDialog.this.selectedJrePath = "";
                }
                ExportFMUDialog.this.checkInformation();
            }
        });
        return container;
    }

    private void createSelectDir(Composite container) {
        this.selectTargetDirButton = new Button(container, 8);
        this.selectTargetDirButton.setText("Select target directory");
        GridData dataDirText = new GridData();
        dataDirText.grabExcessHorizontalSpace = true;
        dataDirText.horizontalAlignment = 4;
        this.selectedDirText = new Text(container, 2056);
        this.selectedDirText.setText(this.selectedDir);
        this.selectedDirText.setLayoutData((Object)dataDirText);
    }

    private void createSetName(Composite container) {
        Label label = new Label(container, 0);
        label.setText("FMU name: ");
        this.setNameText = new Text(container, 2052);
        GridData dataDirText = new GridData();
        dataDirText.grabExcessHorizontalSpace = true;
        dataDirText.horizontalAlignment = 4;
        this.setNameText.setText(this.fmuName);
        this.setNameText.setLayoutData((Object)dataDirText);
    }

    private void createSelectPlatform(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Target platform:");
        this.combo = new Combo(container, 12);
        this.combo.setItems(new String[]{"linux32", "linux64", "win64"});
        this.combo.setText("linux64");
        this.selectedPlatform = "linux64";
    }

    private void createEmbbedJRE(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Include JRE:");
        this.isJreEmbedded = new Button(container, 32);
        this.isJreEmbedded.setText("");
    }

    private void createSelectJRE(Composite container) {
        this.selectJREButton = new Button(container, 8);
        this.selectJREButton.setText("Select JRE path");
        this.selectJREButton.setEnabled(false);
        GridData dataJREText = new GridData();
        dataJREText.grabExcessHorizontalSpace = true;
        dataJREText.horizontalAlignment = 4;
        this.selectedJrePathText = new Text(container, 2056);
        this.selectedJrePathText.setText(this.selectedJrePath);
        this.selectedJrePathText.setLayoutData((Object)dataJREText);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Export FMU");
    }

    protected Point getInitialSize() {
        return new Point(550, 300);
    }

    protected void checkInformation() {
        boolean validJre;
        boolean validSelectedDir;
        boolean bl = validSelectedDir = !"".equals(this.selectedDir);
        boolean bl2 = this.embedJre ? !"".equals(this.selectedJrePath) : (validJre = true);
        if (validSelectedDir && validJre) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getSelectedDir() {
        return this.selectedDir;
    }

    public String getSelectedPlatform() {
        return this.selectedPlatform;
    }

    public boolean isEmbedJre() {
        return this.embedJre;
    }

    public String getSelectedJrePath() {
        return this.selectedJrePath;
    }

    public String getFmuName() {
        return this.fmuName;
    }
}

