/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmiprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BaseUnit implements Enumerator
{
    A(0, "a", "a"),
    CD(1, "cd", "cd"),
    FACTOR(2, "factor", "factor"),
    K(3, "k", "k"),
    KG(4, "kg", "kg"),
    M(5, "m", "m"),
    MOL(6, "mol", "mol"),
    OFFSET(7, "offset", "offset"),
    RAD(8, "rad", "rad"),
    S(9, "s", "s");

    public static final int A_VALUE = 0;
    public static final int CD_VALUE = 1;
    public static final int FACTOR_VALUE = 2;
    public static final int K_VALUE = 3;
    public static final int KG_VALUE = 4;
    public static final int M_VALUE = 5;
    public static final int MOL_VALUE = 6;
    public static final int OFFSET_VALUE = 7;
    public static final int RAD_VALUE = 8;
    public static final int S_VALUE = 9;
    private static final BaseUnit[] VALUES_ARRAY;
    public static final List<BaseUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BaseUnit[]{A, CD, FACTOR, K, KG, M, MOL, OFFSET, RAD, S};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BaseUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BaseUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BaseUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BaseUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BaseUnit get(int value) {
        switch (value) {
            case 0: {
                return A;
            }
            case 1: {
                return CD;
            }
            case 2: {
                return FACTOR;
            }
            case 3: {
                return K;
            }
            case 4: {
                return KG;
            }
            case 5: {
                return M;
            }
            case 6: {
                return MOL;
            }
            case 7: {
                return OFFSET;
            }
            case 8: {
                return RAD;
            }
            case 9: {
                return S;
            }
        }
        return null;
    }

    private BaseUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

