/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmi2uml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.moka.fmi.fmiprofile.CS_FMU;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FMUBundle;
import org.eclipse.papyrus.moka.fmi.modeldescription.CausalityType;
import org.eclipse.papyrus.moka.fmi.modeldescription.CoSimulationType;
import org.eclipse.papyrus.moka.fmi.modeldescription.Fmi2ScalarVariable;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiModelDescriptionType;
import org.eclipse.papyrus.moka.fmi.modeldescription.UnknownType;
import org.eclipse.papyrus.moka.fmi.modeldescription.UnknownType1;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fmi.util.FMIUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FMU2UMLTransformation {
    public static final String PRIMITIVE_TYPE_URI = "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml";
    public static final String REAL_NAME = "Real";
    public static final String BOOLEAN_NAME = "Boolean";
    public static final String INTEGER_NAME = "Integer";
    public static final String STRING_NAME = "String";
    Package receivingPackage;
    FmiModelDescriptionType modelDescription;
    Package dependencyPackage;
    Class fmuClass;
    Stereotype outputDepStereo;
    Stereotype initialUnknownDepStereo;
    Stereotype derivativeDepStereo;
    Stereotype calculatedParameterStereo;
    Stereotype independentStereo;
    Stereotype inputStereo;
    Stereotype outputStereo;
    Stereotype localStereo;
    Stereotype parameterStereo;
    private FMUBundle fmuBundle;

    public FMU2UMLTransformation(FMUBundle fmuBundle, Package receivingPackage) {
        this.receivingPackage = receivingPackage;
        this.fmuBundle = fmuBundle;
        this.modelDescription = fmuBundle.getModelDescription();
        this.outputDepStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.OUTPUT_DEPENDENCY_STEREO_NAME);
        this.initialUnknownDepStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.INITIAL_UNKNWOWN_STEREO_NAME);
        this.derivativeDepStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.DERIVATIVE_DEPENDENCY_STEREO_NAME);
        this.calculatedParameterStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.CALCULATED_PARAMETER_STEREO_NAME);
        this.independentStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.INDEPENDENT_STEREO_NAME);
        this.inputStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.PORT_STEREO_NAME);
        this.outputStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.PORT_STEREO_NAME);
        this.localStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.LOCAL_STEREO_NAME);
        this.parameterStereo = FMIProfileUtil.getStereotype((EObject)receivingPackage, (String)FMIProfileUtil.PARAMETER_STEREO_NAME);
    }

    public Class transform() {
        if (this.receivingPackage != null && this.modelDescription != null && !this.modelDescription.getCoSimulation().isEmpty()) {
            CoSimulationType cosim = (CoSimulationType)this.modelDescription.getCoSimulation().get(0);
            FMIProfileUtil.applyFMIProfileIfNeeded((Package)this.receivingPackage);
            this.fmuClass = this.receivingPackage.createOwnedClass(cosim.getModelIdentifier(), false);
            this.dependencyPackage = this.receivingPackage.createNestedPackage(String.valueOf(cosim.getModelIdentifier()) + "Dependencies");
            CS_FMU csFMU = (CS_FMU)this.fmuClass.applyStereotype(FMIProfileUtil.getStereotype((EObject)this.receivingPackage, (String)FMIProfileUtil.CS_FMU_STEREO_NAME));
            csFMU.setFmuBundle(this.fmuBundle);
            if (this.modelDescription.getModelVariables() != null) {
                for (Fmi2ScalarVariable variable : this.modelDescription.getModelVariables().getScalarVariable()) {
                    this.createProperty(variable);
                }
            }
            if (this.modelDescription.getModelStructure() != null) {
                if (this.modelDescription.getModelStructure().getDerivatives() != null) {
                    for (UnknownType1 unknown : this.modelDescription.getModelStructure().getDerivatives().getUnknown()) {
                        this.createDerivativeDependency(unknown);
                    }
                }
                if (this.modelDescription.getModelStructure().getInitialUnknowns() != null) {
                    for (UnknownType1 unknown : this.modelDescription.getModelStructure().getInitialUnknowns().getUnknown()) {
                        this.createInitialUnknwonDependency((UnknownType)unknown);
                    }
                }
                if (this.modelDescription.getModelStructure().getOutputs() != null) {
                    for (UnknownType1 unknown : this.modelDescription.getModelStructure().getOutputs().getUnknown()) {
                        this.createOutputsDependency(unknown);
                    }
                }
            }
        }
        return this.fmuClass;
    }

    private void createOutputsDependency(UnknownType1 unknown) {
        this.createDependency(unknown.getIndex(), unknown.getDependencies(), this.outputDepStereo);
    }

    private void createInitialUnknwonDependency(UnknownType unknown) {
        this.createDependency(unknown.getIndex(), unknown.getDependencies(), this.initialUnknownDepStereo);
    }

    private void createDerivativeDependency(UnknownType1 unknown) {
        this.createDependency(unknown.getIndex(), unknown.getDependencies(), this.derivativeDepStereo);
    }

    private void createDependency(long clientIndex, List<Long> suppliersIndexes, Stereotype setereoToApply) {
        if (clientIndex <= (long)this.fmuClass.getOwnedAttributes().size() && suppliersIndexes != null) {
            Property client = (Property)this.fmuClass.getOwnedAttributes().get(this.getInt(clientIndex) - 1);
            ArrayList<NamedElement> suppliers = new ArrayList<NamedElement>();
            if (client != null) {
                for (long dep : suppliersIndexes) {
                    if (dep > (long)this.fmuClass.getOwnedAttributes().size()) continue;
                    suppliers.add((NamedElement)this.fmuClass.getOwnedAttributes().get(this.getInt(dep) - 1));
                }
                if (!suppliers.isEmpty()) {
                    Dependency dependency = UMLFactory.eINSTANCE.createDependency();
                    this.dependencyPackage.getPackagedElements().add((Object)dependency);
                    dependency.applyStereotype(setereoToApply);
                    dependency.getClients().add((Object)client);
                    dependency.getSuppliers().addAll(suppliers);
                }
            }
        }
    }

    private int getInt(long longValue) {
        return new Long(longValue).intValue();
    }

    private void createProperty(Fmi2ScalarVariable variable) {
        Type propType = this.getUMLType(variable);
        Object prop = FMIUtil.isPort((Fmi2ScalarVariable)variable) ? UMLFactory.eINSTANCE.createPort() : UMLFactory.eINSTANCE.createProperty();
        this.fmuClass.getOwnedAttributes().add(prop);
        prop.setName(variable.getName());
        prop.setType(propType);
        prop.setUpper(1);
        prop.setLower(1);
        prop.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        this.setDefaultValue((Property)prop, variable);
        Stereotype stereo = this.getPropertyStereotype(variable.getCausality());
        if (stereo != null) {
            prop.applyStereotype(stereo);
        }
    }

    private Stereotype getPropertyStereotype(CausalityType causality) {
        switch (causality) {
            case CALCULATED_PARAMETER: {
                return this.calculatedParameterStereo;
            }
            case INDEPENDENT: {
                return this.independentStereo;
            }
            case INPUT: {
                return this.inputStereo;
            }
            case OUTPUT: {
                return this.outputStereo;
            }
            case LOCAL: {
                return this.localStereo;
            }
            case PARAMETER: {
                return this.parameterStereo;
            }
        }
        return null;
    }

    private void setDefaultValue(Property prop, Fmi2ScalarVariable variable) {
        LiteralReal valSpec = null;
        if (variable.getReal() != null) {
            if (variable.getReal().isSetStart()) {
                valSpec = UMLFactory.eINSTANCE.createLiteralReal();
                valSpec.setValue(variable.getReal().getStart());
            }
        } else if (variable.getBoolean() != null) {
            if (variable.getBoolean().isSetStart()) {
                valSpec = UMLFactory.eINSTANCE.createLiteralBoolean();
                ((LiteralBoolean)valSpec).setValue(variable.getBoolean().isStart());
            }
        } else if (variable.getInteger() != null) {
            if (variable.getInteger().isSetStart()) {
                valSpec = UMLFactory.eINSTANCE.createLiteralInteger();
                ((LiteralInteger)valSpec).setValue(variable.getInteger().getStart());
            }
        } else if (variable.getString() != null) {
            if (variable.getString().getStart() != null) {
                valSpec = UMLFactory.eINSTANCE.createLiteralString();
                ((LiteralString)valSpec).setValue(variable.getString().getStart());
            }
        } else if (variable.getEnumeration() != null && variable.getEnumeration().isSetStart()) {
            valSpec = UMLFactory.eINSTANCE.createLiteralString();
            ((LiteralString)valSpec).setValue(Integer.toString(variable.getEnumeration().getStart()));
        }
        if (valSpec != null) {
            prop.setDefaultValue((ValueSpecification)valSpec);
        }
    }

    private Type getUMLType(Fmi2ScalarVariable variable) {
        if (variable.getReal() != null) {
            return this.getUMLPrimitiveType(REAL_NAME);
        }
        if (variable.getBoolean() != null) {
            return this.getUMLPrimitiveType(BOOLEAN_NAME);
        }
        if (variable.getInteger() != null) {
            return this.getUMLPrimitiveType(INTEGER_NAME);
        }
        return this.getUMLPrimitiveType(STRING_NAME);
    }

    private PrimitiveType getUMLPrimitiveType(String typeName) {
        ResourceSet resSet = UMLUtil.getResourceSet((EObject)this.receivingPackage);
        if (resSet == null) {
            resSet = new ResourceSetImpl();
        }
        return (PrimitiveType)resSet.getEObject(URI.createURI((String)PRIMITIVE_TYPE_URI).appendFragment(typeName), true);
    }
}

