/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.moka.externalcontrol.controller.ControlledVisitorStep;
import org.eclipse.papyrus.moka.externalcontrol.controller.IControlledVisitorPushPullStrategy;
import org.eclipse.papyrus.moka.externalcontrol.controller.IExternallyControlledVisitor;
import org.eclipse.papyrus.moka.externalcontrol.util.PushPullStrategyUtil;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;

public class NodeEdgeAlternatePushPullStrategy
implements IControlledVisitorPushPullStrategy {
    private List<IExternallyControlledVisitor<? extends ISemanticVisitor>> startingOthers = new ArrayList<IExternallyControlledVisitor<? extends ISemanticVisitor>>();
    private List<IExternallyControlledVisitor<? extends ISemanticVisitor>> startingActionVisitors = new ArrayList<IExternallyControlledVisitor<? extends ISemanticVisitor>>();
    private List<IExternallyControlledVisitor<? extends ISemanticVisitor>> finishingOthers = new ArrayList<IExternallyControlledVisitor<? extends ISemanticVisitor>>();
    private List<IExternallyControlledVisitor<? extends ISemanticVisitor>> finishingActionVisitors = new ArrayList<IExternallyControlledVisitor<? extends ISemanticVisitor>>();
    private boolean pullingActions = true;

    @Override
    public IExternallyControlledVisitor<? extends ISemanticVisitor> pullEnabledVisitor() {
        IExternallyControlledVisitor<? extends ISemanticVisitor> result = null;
        if (this.pullingActions) {
            result = this.pullAction();
            if (result == null) {
                this.pullingActions = false;
                result = this.pullOthers();
            }
        } else {
            result = this.pullOthers();
            if (result == null) {
                this.pullingActions = true;
                result = this.pullAction();
            }
        }
        return result;
    }

    private IExternallyControlledVisitor<? extends ISemanticVisitor> pullOthers() {
        IExternallyControlledVisitor<? extends ISemanticVisitor> result = PushPullStrategyUtil.pullFirstEnabledVisitor(this.finishingOthers);
        if (result == null) {
            result = PushPullStrategyUtil.pullFirstEnabledVisitor(this.startingOthers);
        }
        return result;
    }

    private IExternallyControlledVisitor<? extends ISemanticVisitor> pullAction() {
        IExternallyControlledVisitor<? extends ISemanticVisitor> result = PushPullStrategyUtil.pullFirstEnabledVisitor(this.finishingActionVisitors);
        if (result == null) {
            result = PushPullStrategyUtil.pullFirstEnabledVisitor(this.startingActionVisitors);
        }
        return result;
    }

    @Override
    public void pushVisitor(IExternallyControlledVisitor<? extends ISemanticVisitor> visitor) {
        if (visitor instanceof IActionActivation) {
            if (visitor.getState() == ControlledVisitorStep.STARTING) {
                this.startingActionVisitors.add(visitor);
            } else {
                this.finishingActionVisitors.add(visitor);
            }
        } else if (visitor.getState() == ControlledVisitorStep.STARTING) {
            this.startingOthers.add(0, visitor);
        } else {
            this.finishingOthers.add(0, visitor);
        }
    }

    @Override
    public boolean hasEnabledVisitors() {
        Iterator<IExternallyControlledVisitor<? extends ISemanticVisitor>> visitorIterator = this.startingActionVisitors.iterator();
        while (visitorIterator.hasNext()) {
            if (!visitorIterator.next().isExecutionAllowed()) continue;
            return true;
        }
        visitorIterator = this.finishingActionVisitors.iterator();
        while (visitorIterator.hasNext()) {
            if (!visitorIterator.next().isExecutionAllowed()) continue;
            return true;
        }
        visitorIterator = this.startingOthers.iterator();
        while (visitorIterator.hasNext()) {
            if (!visitorIterator.next().isExecutionAllowed()) continue;
            return true;
        }
        visitorIterator = this.finishingOthers.iterator();
        while (visitorIterator.hasNext()) {
            if (!visitorIterator.next().isExecutionAllowed()) continue;
            return true;
        }
        return false;
    }
}

