/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.values;

import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ActivityEdgeInstanceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ActivityNodeActivationValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.EventOccurrenceValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.NullValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ObjectTokenValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.ObjectValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.PrimitiveValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.StructuredValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.TokenValueAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IForkedToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IObjectToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IPrimitiveValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStructuredValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;

public class MokaValueAdapterFactory {
    protected static MokaValueAdapterFactory INSTANCE;

    private MokaValueAdapterFactory() {
    }

    public static MokaValueAdapterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MokaValueAdapterFactory();
        }
        return INSTANCE;
    }

    public MokaValueAdapter instantiate(Object value, MokaDebugTarget debugTarget) {
        MokaValueAdapter adapter = null;
        if (value != null) {
            if (value instanceof IEventOccurrence) {
                adapter = new EventOccurrenceValueAdapter(debugTarget, (IEventOccurrence)value);
            } else if (value instanceof IToken) {
                adapter = value instanceof IObjectToken ? new ObjectTokenValueAdapter(debugTarget, (IToken)((IObjectToken)value)) : (value instanceof IForkedToken ? this.instantiate(((IForkedToken)value).getBaseToken(), debugTarget) : new TokenValueAdapter(debugTarget, (IToken)value));
            } else if (value instanceof IValue) {
                if (value instanceof IObject_) {
                    adapter = new ObjectValueAdapter(debugTarget, (IObject_)value);
                } else if (value instanceof IStructuredValue) {
                    adapter = new StructuredValueAdapter(debugTarget, (IStructuredValue)value);
                } else if (value instanceof IPrimitiveValue) {
                    adapter = new PrimitiveValueAdapter(debugTarget, (IPrimitiveValue)value);
                }
            } else if (value instanceof ISemanticVisitor) {
                if (value instanceof IActivityNodeActivation) {
                    adapter = new ActivityNodeActivationValueAdapter(debugTarget, (IActivityNodeActivation)value);
                } else if (value instanceof IActivityEdgeInstance) {
                    adapter = new ActivityEdgeInstanceValueAdapter(debugTarget, (ISemanticVisitor)((IActivityEdgeInstance)value));
                }
            }
        }
        if (adapter == null) {
            adapter = new NullValueAdapter(debugTarget);
        }
        return adapter;
    }
}

