/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.codegen.ui.handlers;

import io.adminshell.aas.v3.model.Identifier;
import io.adminshell.aas.v3.model.impl.DefaultIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.aas.api.aas.parts.ConceptDictionary;
import org.eclipse.aas.api.reference.IReference;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.IOperationVariable;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.OperationVariable;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.valuetypes.ValueType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.aas.AASEndpoint;
import org.eclipse.papyrus.aas.Asset;
import org.eclipse.papyrus.aas.AssetAdministrationShell;
import org.eclipse.papyrus.aas.AssetKind;
import org.eclipse.papyrus.aas.ConceptDescription;
import org.eclipse.papyrus.aas.Endpoint;
import org.eclipse.papyrus.aas.File;
import org.eclipse.papyrus.aas.IdType;
import org.eclipse.papyrus.aas.Identifiable;
import org.eclipse.papyrus.aas.IdentifierType;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.KeyElements;
import org.eclipse.papyrus.aas.KeyType;
import org.eclipse.papyrus.aas.LangString;
import org.eclipse.papyrus.aas.MimeType;
import org.eclipse.papyrus.aas.ModelingKind;
import org.eclipse.papyrus.aas.MultiLanguageProperty;
import org.eclipse.papyrus.aas.NodeId;
import org.eclipse.papyrus.aas.Operation;
import org.eclipse.papyrus.aas.Property;
import org.eclipse.papyrus.aas.ProtocolKind;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.papyrus.aas.Submodel;
import org.eclipse.papyrus.aas.SubmodelElement;
import org.eclipse.papyrus.aas.SubmodelElementCollection;
import org.eclipse.papyrus.aas.impl.AssetAdministrationShellImpl;
import org.eclipse.papyrus.aas.impl.MultiLanguagePropertyImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class GenerateAASCodeHelper {
    public static org.eclipse.aas.api.aas.AssetAdministrationShell getAAS(Class aasClass) throws Exception {
        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)aasClass, AssetAdministrationShell.class);
        if (aas != null) {
            org.eclipse.aas.api.aas.AssetAdministrationShell basyxAAS = new org.eclipse.aas.api.aas.AssetAdministrationShell(aas.getIdShort() != null ? aas.getIdShort() : "aas");
            AASEndpoint endpoint = aas.getEndpoint();
            org.eclipse.aas.api.communications.AASEndpoint aasEndpoint = new org.eclipse.aas.api.communications.AASEndpoint("AASServer", 1503);
            if (endpoint != null) {
                aasEndpoint = new org.eclipse.aas.api.communications.AASEndpoint(endpoint.getAddress(), endpoint.getPort());
            }
            basyxAAS.setEndpoint(aasEndpoint);
            List<Object> basyxSubmodels = new ArrayList();
            basyxSubmodels = GenerateAASCodeHelper.getSubmodels(aasClass);
            try {
                if (basyxSubmodels != null && !basyxSubmodels.isEmpty()) {
                    basyxAAS.setSubModels(basyxSubmodels);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            GenerateAASCodeHelper.generateIdentification(aas, basyxAAS);
            org.eclipse.aas.api.asset.Asset basyxAsset = new org.eclipse.aas.api.asset.Asset("basyxAsset");
            basyxAsset = GenerateAASCodeHelper.getAsset(aasClass);
            try {
                if (basyxAsset != null) {
                    basyxAAS.setAsset(basyxAsset);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)GenerateAASCodeHelper.getShell(), (String)"Error", (String)"You have to set an asset for the AAS before code generation");
            }
            ConceptDictionary conceptDic = GenerateAASCodeHelper.getConceptDictionary(aasClass);
            basyxAAS.setConceptDictionary(conceptDic);
            return basyxAAS;
        }
        return null;
    }

    public static List<org.eclipse.aas.api.communications.Endpoint> getAssetEndpoints(Class aasClass) {
        ArrayList<org.eclipse.aas.api.communications.Endpoint> endpoints = new ArrayList<org.eclipse.aas.api.communications.Endpoint>();
        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)aasClass, AssetAdministrationShell.class);
        if (aas != null && aas.getAsset() != null) {
            Asset asset = ((AssetAdministrationShellImpl)aasClass).getAsset();
            for (Endpoint endpoint : asset.getEndpoint()) {
                org.eclipse.aas.api.communications.Endpoint assetEndpoint = new org.eclipse.aas.api.communications.Endpoint(endpoint.getName(), GenerateAASCodeHelper.convertProtocol(endpoint.getProtocol()), endpoint.getAddress());
                endpoints.add(assetEndpoint);
            }
        }
        return endpoints;
    }

    public static org.eclipse.aas.api.asset.Asset getAsset(Class aasClass) throws Exception {
        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)aasClass, AssetAdministrationShell.class);
        if (aas != null) {
            if (aas.getAsset() != null) {
                Asset asset = ((AssetAdministrationShellImpl)aas).getAsset();
                org.eclipse.aas.api.asset.Asset basyxAsset = new org.eclipse.aas.api.asset.Asset(asset.getIdShort());
                if (asset.getKind() != null) {
                    basyxAsset.setKind(GenerateAASCodeHelper.convertAssetKind(asset.getKind()));
                }
                GenerateAASCodeHelper.generateIdentification(asset, basyxAsset);
                if (asset.getEndpoint() != null && !asset.getEndpoint().isEmpty()) {
                    for (Endpoint endpoint : asset.getEndpoint()) {
                        org.eclipse.aas.api.communications.Endpoint assetEndpoint = new org.eclipse.aas.api.communications.Endpoint(endpoint.getName(), GenerateAASCodeHelper.convertProtocol(endpoint.getProtocol()), endpoint.getAddress());
                        basyxAsset.setEndpoint(assetEndpoint);
                    }
                }
                return basyxAsset;
            }
            throw new Exception("Set an asset for the AAS before code generation");
        }
        throw new Exception("Code generator has to be  executed on an AAS!");
    }

    public static List<SubModel> getSubmodels(Class aasClass) throws Exception {
        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)aasClass, AssetAdministrationShell.class);
        if (aas != null) {
            ArrayList<SubModel> submodels = new ArrayList<SubModel>();
            if (aas.getSubmodel() != null) {
                for (Submodel submodel : aas.getSubmodel()) {
                    Reference ref;
                    org.eclipse.aas.api.reference.Reference basyxRef;
                    Class submodelClass = submodel.getBase_Class();
                    if (submodelClass == null) continue;
                    String submodelName = submodelClass.getName();
                    SubModel basyxSubmodel = new SubModel(submodelName);
                    GenerateAASCodeHelper.generateIdentification(submodel, basyxSubmodel);
                    if (submodel.getSemanticId() != null && (basyxRef = GenerateAASCodeHelper.convertReference(ref = submodel.getSemanticId())) != null) {
                        basyxSubmodel.setSemanticIdentifier((IReference)basyxRef);
                    }
                    if (submodel.getKind() != null) {
                        basyxSubmodel.setKind(GenerateAASCodeHelper.convertModelingKind(submodel.getKind()));
                    }
                    GenerateAASCodeHelper.generateSubmodelElementsFromClassAttributes(submodelClass, basyxSubmodel, null);
                    GenerateAASCodeHelper.generateSubmodelOperations(submodelClass, basyxSubmodel, null);
                    if (submodelClass.getNestedClassifiers() != null && submodelClass.getNestedClassifiers().size() > 0) {
                        for (Classifier sec : submodelClass.getNestedClassifiers()) {
                            if (!(sec instanceof Class)) continue;
                            GenerateAASCodeHelper.generateSubmodelElementCollection((Class)sec, basyxSubmodel, null);
                        }
                    }
                    submodels.add(basyxSubmodel);
                }
            }
            return submodels;
        }
        return null;
    }

    public static List<Class> getUMLSubmodels(Class aasClass) {
        AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)aasClass, AssetAdministrationShell.class);
        ArrayList<Class> umlSubmodels = new ArrayList<Class>();
        if (aas != null) {
            for (Submodel submodel : aas.getSubmodel()) {
                Class submodelClass = submodel.getBase_Class();
                if (submodelClass == null) continue;
                umlSubmodels.add(submodelClass);
            }
        }
        return umlSubmodels;
    }

    public static ConceptDictionary getConceptDictionary(Class aasClass) {
        Model rootModel = aasClass.getModel();
        EList modelPackages = new ArrayList();
        modelPackages = rootModel.getNestedPackages();
        ConceptDictionary conceptDict = new ConceptDictionary();
        if (modelPackages != null) {
            for (Package pk : modelPackages) {
                if (pk.getOwnedElements() == null) continue;
                for (Element child : pk.getOwnedElements()) {
                    ConceptDescription stConceptDescription = (ConceptDescription)UMLUtil.getStereotypeApplication((Element)child, ConceptDescription.class);
                    if (stConceptDescription == null) continue;
                    String conceptName = ((NamedElement)child).getName();
                    String conceptIdShort = "";
                    conceptIdShort = stConceptDescription.getIdShort() != null && !stConceptDescription.getIdShort().isEmpty() ? stConceptDescription.getIdShort() : conceptName.replaceAll("\\s+", "");
                    org.eclipse.aas.api.submodel.parts.ConceptDescription basyxCD = new org.eclipse.aas.api.submodel.parts.ConceptDescription(conceptIdShort);
                    GenerateAASCodeHelper.generateIdentification(stConceptDescription, basyxCD);
                    if (stConceptDescription.getCategory() != null) {
                        basyxCD.setCategory(stConceptDescription.getCategory());
                    }
                    if (stConceptDescription.getIsCaseOf() != null) {
                        ArrayList<org.eclipse.aas.api.reference.Reference> iscaseOfList = new ArrayList<org.eclipse.aas.api.reference.Reference>();
                        for (Reference reference : stConceptDescription.getIsCaseOf()) {
                            org.eclipse.aas.api.reference.Reference basyxRef = GenerateAASCodeHelper.convertReference(reference);
                            if (basyxRef == null) continue;
                            iscaseOfList.add(basyxRef);
                        }
                        for (org.eclipse.aas.api.reference.Reference reference : iscaseOfList) {
                            basyxCD.setIsCaseOf((IReference)reference);
                        }
                    }
                    conceptDict.setConceptDescription(basyxCD);
                }
            }
        }
        return conceptDict;
    }

    public static void generateSubmodelElementCollection(Class umlClass, SubModel basyxSubmodel, SubModelElementCollection parentSEC) {
        SubmodelElementCollection stSEC = (SubmodelElementCollection)UMLUtil.getStereotypeApplication((Element)umlClass, SubmodelElementCollection.class);
        if (stSEC != null) {
            Reference ref;
            org.eclipse.aas.api.reference.Reference basyxRef;
            SubModelElementCollection basyxSEC = new SubModelElementCollection(umlClass.getName());
            basyxSEC.setAllowDuplicates(stSEC.isAllowDuplicates());
            basyxSEC.setOrdered(stSEC.isOrdered());
            basyxSEC.setDynamic(stSEC.isDynamic());
            GenerateAASCodeHelper.generateSubmodelElementAttributes(stSEC, (NamedElement)umlClass, basyxSEC);
            if (stSEC.getSemanticId() != null && (basyxRef = GenerateAASCodeHelper.convertReference(ref = stSEC.getSemanticId())) != null) {
                basyxSEC.setSemanticIdentifier((IReference)basyxRef);
            }
            GenerateAASCodeHelper.generateSubmodelElementsFromClassAttributes(umlClass, null, basyxSEC);
            GenerateAASCodeHelper.generateSubmodelOperations(umlClass, null, basyxSEC);
            for (Classifier secChild : umlClass.getNestedClassifiers()) {
                if (!(secChild instanceof Class)) continue;
                GenerateAASCodeHelper.generateSubmodelElementCollection((Class)secChild, null, basyxSEC);
            }
            if (basyxSubmodel != null) {
                basyxSubmodel.setSubModelElementCollection(basyxSEC);
            }
            if (parentSEC != null) {
                parentSEC.setSubModelElementCollection(basyxSEC);
            }
        }
    }

    public static void generateSubmodelElementsFromClassAttributes(Class submodelClass, SubModel basyxSubmodel, SubModelElementCollection basyxSEC) {
        if (submodelClass.getAllAttributes() != null && !submodelClass.getAllAttributes().isEmpty()) {
            int j = 0;
            while (j < submodelClass.getAllAttributes().size()) {
                org.eclipse.uml2.uml.Property submodelElement = (org.eclipse.uml2.uml.Property)submodelClass.getAllAttributes().get(j);
                String attName = submodelElement.getName();
                if (submodelElement.getAppliedStereotypes() == null || submodelElement.getAppliedStereotypes().size() == 0) {
                    String attValue;
                    org.eclipse.aas.api.submodel.submodelelement.dataelement.Property submodelProperty = new org.eclipse.aas.api.submodel.submodelelement.dataelement.Property(attName);
                    if (submodelElement.getType() != null && submodelElement.getType().getName() != null) {
                        submodelProperty.setValueType(GenerateAASCodeHelper.convertType(submodelElement.getType().toString()));
                    }
                    if (submodelElement.getDefaultValue() != null && (attValue = submodelElement.getDefaultValue().stringValue()) != null) {
                        submodelProperty.setValue(attValue);
                    }
                    if (basyxSubmodel != null) {
                        basyxSubmodel.setProperty(submodelProperty);
                    }
                    if (basyxSEC != null) {
                        basyxSEC.setProperty(submodelProperty);
                    }
                } else {
                    GenerateAASCodeHelper.generateProperty(submodelElement, basyxSubmodel, basyxSEC);
                    GenerateAASCodeHelper.generateFile(submodelElement, basyxSubmodel, basyxSEC);
                    GenerateAASCodeHelper.generateMLP(submodelElement, basyxSubmodel, basyxSEC);
                }
                ++j;
            }
        }
    }

    public static void generateProperty(org.eclipse.uml2.uml.Property submodelElement, SubModel basyxSubmodel, SubModelElementCollection basyxSEC) {
        Property stProperty = (Property)UMLUtil.getStereotypeApplication((Element)submodelElement, Property.class);
        if (stProperty != null) {
            Reference ref;
            org.eclipse.aas.api.reference.Reference basyxRef;
            org.eclipse.aas.api.submodel.submodelelement.dataelement.Property submodelProperty = new org.eclipse.aas.api.submodel.submodelelement.dataelement.Property();
            GenerateAASCodeHelper.generateSubmodelElementAttributes(stProperty, (NamedElement)submodelElement, submodelProperty);
            if (stProperty.getSemanticId() != null && (basyxRef = GenerateAASCodeHelper.convertReference(ref = stProperty.getSemanticId())) != null) {
                submodelProperty.setSemanticIdentifier((IReference)basyxRef);
            }
            if (submodelElement.getType() != null) {
                submodelProperty.setValueType(GenerateAASCodeHelper.convertType(submodelElement.getType().getName()));
            }
            submodelProperty.setDynamic(stProperty.isDynamic());
            Boolean nodeidGenerated = false;
            NodeId nodeid = stProperty.getNodeId();
            if (nodeid != null) {
                submodelProperty.setNameSpaceIndex(nodeid.getNamespace());
                GenerateAASCodeHelper.generateNodeId(nodeid, submodelProperty, null);
                nodeidGenerated = true;
            }
            Endpoint endpoint = stProperty.getEndPoint();
            Boolean endpointGenerated = false;
            if (endpoint != null) {
                org.eclipse.aas.api.communications.Endpoint propEndpoint = new org.eclipse.aas.api.communications.Endpoint(endpoint.getName(), GenerateAASCodeHelper.convertProtocol(endpoint.getProtocol()), endpoint.getAddress());
                endpointGenerated = true;
                submodelProperty.setEndpoint(propEndpoint);
            }
            if (submodelElement.getDefaultValue() != null) {
                if (!stProperty.isDynamic()) {
                    submodelProperty.setValue(GenerateAASCodeHelper.getPropertyValue(submodelElement));
                } else if (!endpointGenerated.booleanValue()) {
                    submodelProperty.setValue(GenerateAASCodeHelper.getPropertyValue(submodelElement));
                }
            }
            if (basyxSubmodel != null) {
                basyxSubmodel.setProperty(submodelProperty);
            }
            if (basyxSEC != null) {
                basyxSEC.setProperty(submodelProperty);
            }
        }
    }

    public static void generateFile(org.eclipse.uml2.uml.Property submodelElement, SubModel basyxSubmodel, SubModelElementCollection basyxSEC) {
        File stFile = (File)UMLUtil.getStereotypeApplication((Element)submodelElement, File.class);
        if (stFile != null) {
            Endpoint endpoint;
            NodeId nodeid;
            Reference ref;
            org.eclipse.aas.api.reference.Reference basyxRef;
            org.eclipse.aas.api.submodel.submodelelement.dataelement.File submodelFile = new org.eclipse.aas.api.submodel.submodelelement.dataelement.File();
            GenerateAASCodeHelper.generateSubmodelElementAttributes(stFile, (NamedElement)submodelElement, submodelFile);
            submodelFile.setDynamic(stFile.isDynamic());
            if (stFile.getSemanticId() != null && (basyxRef = GenerateAASCodeHelper.convertReference(ref = stFile.getSemanticId())) != null) {
                submodelFile.setSemanticIdentifier((IReference)basyxRef);
            }
            if ((nodeid = stFile.getNodeId()) != null) {
                submodelFile.setNameSpaceIndex(nodeid.getNamespace());
                GenerateAASCodeHelper.generateNodeId(nodeid, null, submodelFile);
            }
            if ((endpoint = stFile.getEndPoint()) != null) {
                org.eclipse.aas.api.communications.Endpoint propEndpoint = new org.eclipse.aas.api.communications.Endpoint(endpoint.getName(), GenerateAASCodeHelper.convertProtocol(endpoint.getProtocol()), endpoint.getAddress());
                submodelFile.setEndpoint(propEndpoint);
            }
            if (stFile.getMimeType() != null) {
                submodelFile.setMimeType(GenerateAASCodeHelper.convertMimeType(stFile.getMimeType()));
            }
            if (stFile.getPath() != null) {
                submodelFile.setValue(stFile.getPath());
            }
            if (basyxSubmodel != null) {
                basyxSubmodel.setFile(submodelFile);
            }
            if (basyxSEC != null) {
                basyxSEC.setFile(submodelFile);
            }
        }
    }

    public static void generateMLP(org.eclipse.uml2.uml.Property submodelElement, SubModel basyxSubmodel, SubModelElementCollection basyxSEC) {
        MultiLanguageProperty stMLP = (MultiLanguageProperty)UMLUtil.getStereotypeApplication((Element)submodelElement, MultiLanguageProperty.class);
        String[] langCodes = new String[]{};
        String[] langPropValues = new String[]{};
        if (stMLP != null) {
            Reference ref;
            org.eclipse.aas.api.reference.Reference basyxRef;
            EList values = ((MultiLanguagePropertyImpl)stMLP).getValue();
            if (values != null && values.size() > 0) {
                langPropValues = new String[values.size()];
                langCodes = new String[values.size()];
                int i = 0;
                while (i < values.size()) {
                    langPropValues[i] = ((LangString)values.get(i)).getValue();
                    langCodes[i] = ((LangString)values.get(i)).getLang().toString();
                    ++i;
                }
            }
            org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty submodelMLP = new org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty();
            GenerateAASCodeHelper.generateSubmodelElementAttributes(stMLP, (NamedElement)submodelElement, submodelMLP);
            if (stMLP.getSemanticId() != null && (basyxRef = GenerateAASCodeHelper.convertReference(ref = stMLP.getSemanticId())) != null) {
                submodelMLP.setSemanticIdentifier((IReference)basyxRef);
            }
            if (stMLP.getValue() != null && !stMLP.getValue().isEmpty()) {
                for (LangString desc : stMLP.getValue()) {
                    submodelMLP.setValue(desc.getLang() != null ? desc.getLang().getLiteral() : "en", desc.getValue());
                }
            }
            if (basyxSubmodel != null) {
                basyxSubmodel.setMultiLanguageProperty(submodelMLP);
            }
            if (basyxSEC != null) {
                basyxSEC.setMultiLanguageProperty(submodelMLP);
            }
        }
    }

    public static <T1 extends SubmodelElement, T2 extends io.adminshell.aas.v3.model.SubmodelElement> void generateSubmodelElementAttributes(T1 stSubmodelElement, NamedElement umlSubmodelElement, T2 submodelElement) {
        if (stSubmodelElement.getIdShort() != null) {
            submodelElement.setIdShort(stSubmodelElement.getIdShort());
        } else {
            String idShort = "setIdShort";
            if (umlSubmodelElement.getName() != null) {
                idShort = umlSubmodelElement.getName();
            }
            submodelElement.setIdShort(idShort.replaceAll("\\s+", ""));
        }
        if (stSubmodelElement.getDescription() != null && !stSubmodelElement.getDescription().isEmpty()) {
            submodelElement.setDescriptions(GenerateAASCodeHelper.convertDescriptions((List<LangString>)stSubmodelElement.getDescription()));
        }
        if (stSubmodelElement.getKind() != null) {
            submodelElement.setKind(GenerateAASCodeHelper.convertModelingKind(stSubmodelElement.getKind()));
        }
        if (umlSubmodelElement.getName() != null) {
            ArrayList<io.adminshell.aas.v3.model.LangString> dNames = new ArrayList<io.adminshell.aas.v3.model.LangString>();
            io.adminshell.aas.v3.model.LangString dName = new io.adminshell.aas.v3.model.LangString(umlSubmodelElement.getName(), "en");
            dNames.add(dName);
            submodelElement.setDisplayNames(dNames);
        }
        if (stSubmodelElement.getCategory() != null) {
            submodelElement.setCategory(stSubmodelElement.getCategory());
        }
    }

    public static <T1 extends Identifiable, T2 extends io.adminshell.aas.v3.model.Identifiable> void generateIdentification(T1 stIdentifiable, T2 basyxIdentifiable) {
        if (stIdentifiable.getIdentification() != null) {
            DefaultIdentifier idAAS = new DefaultIdentifier();
            if (stIdentifiable.getIdentification().getIdType() != null) {
                idAAS.setIdType(GenerateAASCodeHelper.convertIdentifierType(stIdentifiable.getIdentification().getIdType()));
            }
            if (stIdentifiable.getIdentification().getId() != null) {
                idAAS.setIdentifier(stIdentifiable.getIdentification().getId().toString());
            }
            basyxIdentifiable.setIdentification((Identifier)idAAS);
        } else {
            DefaultIdentifier idAAS = new DefaultIdentifier();
            idAAS.setIdType(io.adminshell.aas.v3.model.IdentifierType.IRI);
            idAAS.setIdentifier("https://institution.com/aas/aasid");
            basyxIdentifiable.setIdentification((Identifier)idAAS);
        }
    }

    public static void generateSubmodelOperations(Class submodelClass, SubModel basyxSubmodel, SubModelElementCollection basyxSEC) {
        if (submodelClass.getAllOperations() != null && !submodelClass.getAllOperations().isEmpty()) {
            int index = 0;
            for (org.eclipse.uml2.uml.Operation op : submodelClass.getAllOperations()) {
                List<OperationVariable> op_output;
                List<OperationVariable> op_inoutput;
                List<OperationVariable> op_input;
                Reference ref;
                org.eclipse.aas.api.reference.Reference basyxRef;
                ++index;
                org.eclipse.aas.api.submodel.submodelelement.Operation basyxOperation = new org.eclipse.aas.api.submodel.submodelelement.Operation();
                Operation stOperation = (Operation)UMLUtil.getStereotypeApplication((Element)op, Operation.class);
                if (stOperation == null) continue;
                GenerateAASCodeHelper.generateSubmodelElementAttributes(stOperation, (NamedElement)op, basyxOperation);
                if (stOperation.getSemanticId() != null && (basyxRef = GenerateAASCodeHelper.convertReference(ref = stOperation.getSemanticId())) != null) {
                    basyxOperation.setSemanticIdentifier((IReference)basyxRef);
                }
                if ((op_input = GenerateAASCodeHelper.getOperationParameters(op, 0)).size() > 0) {
                    basyxOperation.setInputVariables((IOperationVariable[])op_input.toArray(new OperationVariable[op_input.size()]));
                }
                if ((op_inoutput = GenerateAASCodeHelper.getOperationParameters(op, 1)).size() > 0) {
                    basyxOperation.setInputVariables((IOperationVariable[])op_inoutput.toArray(new OperationVariable[op_inoutput.size()]));
                }
                if ((op_output = GenerateAASCodeHelper.getOperationParameters(op, 2)).size() > 0) {
                    basyxOperation.setOutputVariable((IOperationVariable)op_output.get(0));
                }
                if (basyxSubmodel != null) {
                    basyxSubmodel.setOperation(basyxOperation);
                }
                if (basyxSEC == null) continue;
                basyxSEC.setOperation(basyxOperation);
            }
        }
    }

    public static List<OperationVariable> getOperationParameters(org.eclipse.uml2.uml.Operation op, int direction) {
        ArrayList<OperationVariable> paramaters = new ArrayList<OperationVariable>();
        if (op.getOwnedParameters() != null && !op.getOwnedParameters().isEmpty()) {
            int index = 0;
            for (Parameter param : op.getOwnedParameters()) {
                String paramName = "param" + ++index;
                String paramType = "String";
                if (param == null || param.getName() == null) continue;
                paramName = param.getName();
                if (param.getDirection().getValue() != direction) continue;
                System.err.println("found parameter for direction " + direction + "\n");
                if (param.getType() != null && param.getType().getName() != null) {
                    paramType = param.getType().getName();
                }
                OperationVariable basyxParam = new OperationVariable(paramName, GenerateAASCodeHelper.convertType(paramType));
                paramaters.add(basyxParam);
            }
        }
        return paramaters;
    }

    public static org.eclipse.aas.api.communications.ProtocolKind convertProtocol(ProtocolKind profileProtocol) {
        block19: {
            if (profileProtocol.getLiteral() == null) break block19;
            switch (profileProtocol.getLiteral()) {
                case "HTTP": {
                    return org.eclipse.aas.api.communications.ProtocolKind.HTTP;
                }
                case "MQTT": {
                    return org.eclipse.aas.api.communications.ProtocolKind.MQTT;
                }
                case "OPCUA": {
                    return org.eclipse.aas.api.communications.ProtocolKind.OPCUA;
                }
                case "CoAP": {
                    return org.eclipse.aas.api.communications.ProtocolKind.CoAP;
                }
                case "OTHER": {
                    return org.eclipse.aas.api.communications.ProtocolKind.OTHER;
                }
            }
        }
        return null;
    }

    public static io.adminshell.aas.v3.model.IdentifierType convertIdentifierType(IdentifierType idType) {
        block13: {
            if (idType.getLiteral() == null) break block13;
            switch (idType.getLiteral()) {
                case "Custom": {
                    return io.adminshell.aas.v3.model.IdentifierType.CUSTOM;
                }
                case "IRDI": {
                    return io.adminshell.aas.v3.model.IdentifierType.IRDI;
                }
                case "IRI": {
                    return io.adminshell.aas.v3.model.IdentifierType.IRI;
                }
            }
            return null;
        }
        return null;
    }

    public static io.adminshell.aas.v3.model.ModelingKind convertModelingKind(ModelingKind kind) {
        block10: {
            if (kind.getLiteral() == null) break block10;
            switch (kind.getLiteral()) {
                case "Template": {
                    return io.adminshell.aas.v3.model.ModelingKind.TEMPLATE;
                }
                case "Instance": {
                    return io.adminshell.aas.v3.model.ModelingKind.INSTANCE;
                }
            }
        }
        return io.adminshell.aas.v3.model.ModelingKind.INSTANCE;
    }

    public static io.adminshell.aas.v3.model.KeyType convertKeyType(KeyType keyType) {
        block19: {
            if (keyType.getLiteral() == null) break block19;
            switch (keyType.getLiteral()) {
                case "Custom": {
                    return io.adminshell.aas.v3.model.KeyType.CUSTOM;
                }
                case "IRDI": {
                    return io.adminshell.aas.v3.model.KeyType.IRDI;
                }
                case "IRI": {
                    return io.adminshell.aas.v3.model.KeyType.IRI;
                }
                case "IdShort": {
                    return io.adminshell.aas.v3.model.KeyType.ID_SHORT;
                }
                case "FragmentId": {
                    return io.adminshell.aas.v3.model.KeyType.FRAGMENT_ID;
                }
            }
        }
        return null;
    }

    public static io.adminshell.aas.v3.model.AssetKind convertAssetKind(AssetKind assetKind) {
        block10: {
            if (assetKind.getLiteral() == null) break block10;
            switch (assetKind.getLiteral()) {
                case "Type": {
                    return io.adminshell.aas.v3.model.AssetKind.TYPE;
                }
                case "Instance": {
                    return io.adminshell.aas.v3.model.AssetKind.INSTANCE;
                }
            }
        }
        return null;
    }

    public static io.adminshell.aas.v3.model.KeyElements convertKeyElements(KeyElements keyElements) {
        block10: {
            if (keyElements.getLiteral() == null) break block10;
            switch (keyElements.getLiteral()) {
                case "GlobalReference": {
                    return io.adminshell.aas.v3.model.KeyElements.GLOBAL_REFERENCE;
                }
                case "ConceptDescription": {
                    return io.adminshell.aas.v3.model.KeyElements.CONCEPT_DESCRIPTION;
                }
            }
        }
        return null;
    }

    public static String convertMimeType(MimeType mimeType) {
        block46: {
            if (mimeType.getLiteral() == null) break block46;
            switch (mimeType.getLiteral()) {
                case "applicationjson": {
                    return "application/json";
                }
                case "applicationxls": {
                    return "application/xls";
                }
                case "applicationpdf": {
                    return "application/pdf";
                }
                case "applicationzip": {
                    return "application/zip";
                }
                case "applicationstep": {
                    return "application/step";
                }
                case "imagebmp": {
                    return "image/bmp";
                }
                case "imagepng": {
                    return "image/png";
                }
                case "imagejpeg": {
                    return "image/jpeg";
                }
                case "imagegif": {
                    return "image/gif";
                }
                case "textxml": {
                    return "text/xml";
                }
                case "textplain": {
                    return "text/plain";
                }
                case "texthtml": {
                    return "text/html";
                }
                case "applicationxml": {
                    return "application/xml";
                }
                case "applicationiges": {
                    return "application/iges";
                }
            }
        }
        return "other";
    }

    public static org.eclipse.aas.api.reference.Reference convertReference(Reference ref) {
        Class refClass = ref.getBase_Class();
        if (refClass != null) {
            ArrayList<org.eclipse.aas.api.reference.Key> refKeys = new ArrayList<org.eclipse.aas.api.reference.Key>();
            for (Classifier cl : refClass.getNestedClassifiers()) {
                Key key = (Key)UMLUtil.getStereotypeApplication((Element)cl, Key.class);
                if (key == null) continue;
                org.eclipse.aas.api.reference.Key basyxKey = new org.eclipse.aas.api.reference.Key(GenerateAASCodeHelper.convertKeyElements(key.getType()), !key.getType().getLiteral().equals("GlobalReference"), key.getValue() != null ? key.getValue() : "", GenerateAASCodeHelper.convertKeyType(key.getIdType()));
                refKeys.add(basyxKey);
            }
            org.eclipse.aas.api.reference.Reference basyxRef = new org.eclipse.aas.api.reference.Reference();
            basyxRef.setKeys(refKeys);
            return basyxRef;
        }
        return null;
    }

    public static ValueType convertType(String umlType) {
        switch (umlType) {
            case "Boolean": {
                return ValueType.Boolean;
            }
            case "Integer": {
                return ValueType.Integer;
            }
            case "Real": {
                return ValueType.Float;
            }
            case "String": {
                return ValueType.String;
            }
            case "UnlimitedNatural": {
                return ValueType.PositiveInteger;
            }
            case "EString": {
                return ValueType.String;
            }
            case "EBoolean": {
                return ValueType.Boolean;
            }
            case "EDate": {
                return ValueType.DateTime;
            }
            case "EDouble": {
                return ValueType.Double;
            }
            case "EInt": {
                return ValueType.Integer;
            }
            case "EFloat": {
                return ValueType.Float;
            }
            case "DateTimeStamp": 
            case "Date": 
            case "Time": 
            case "DateTime": {
                return ValueType.DateTime;
            }
            case "AnySimpleType": {
                return ValueType.AnySimpleType;
            }
            case "IDREFS": {
                return ValueType.IDREF;
            }
            case "Base64Binary": {
                return ValueType.Base64Binary;
            }
            case "AnyURI": {
                return ValueType.AnyURI;
            }
            case "Double": {
                return ValueType.Double;
            }
            case "Duration": {
                return ValueType.Duration;
            }
            case "Float": {
                return ValueType.Float;
            }
            case "GDay": {
                return ValueType.GDay;
            }
            case "GMonthDay": {
                return ValueType.GMonthDay;
            }
            case "GMonth": {
                return ValueType.GMonth;
            }
            case "GYear": {
                return ValueType.GYear;
            }
            case "GYearMonth": {
                return ValueType.GYearMonth;
            }
            case "HexBinary": {
                return ValueType.HexBinary;
            }
            case "NOTATION": {
                return ValueType.NOTATION;
            }
            case "QName": {
                return ValueType.QName;
            }
            case "NonNegativeInteger": {
                return ValueType.NonNegativeInteger;
            }
            case "NonPositiveInteger": {
                return ValueType.NonPositiveInteger;
            }
            case "Int": {
                return ValueType.Int32;
            }
            case "Long": {
                return ValueType.Int64;
            }
            case "Short": {
                return ValueType.Int16;
            }
            case "Byte": {
                return ValueType.Int8;
            }
            case "NegativeInteger": {
                return ValueType.NegativeInteger;
            }
            case "PositiveInteger": {
                return ValueType.PositiveInteger;
            }
            case "UnsignedLong": {
                return ValueType.UInt64;
            }
            case "UnsignedByte": {
                return ValueType.UInt8;
            }
            case "UnsignedInt": {
                return ValueType.UInt32;
            }
            case "UnsignedShort": {
                return ValueType.UInt16;
            }
            case "ID": {
                return ValueType.ID;
            }
            case "IDREF": {
                return ValueType.IDREF;
            }
            case "ENTITY": {
                return ValueType.ENTITY;
            }
        }
        return ValueType.None;
    }

    public static List<io.adminshell.aas.v3.model.LangString> convertDescriptions(List<LangString> profileDescriptions) {
        if (profileDescriptions != null && !profileDescriptions.isEmpty()) {
            ArrayList<io.adminshell.aas.v3.model.LangString> descriptions = new ArrayList<io.adminshell.aas.v3.model.LangString>();
            for (LangString desc : profileDescriptions) {
                io.adminshell.aas.v3.model.LangString basyxDesc = new io.adminshell.aas.v3.model.LangString(desc.getValue(), desc.getLang() != null ? desc.getLang().getLiteral() : "en");
                descriptions.add(basyxDesc);
            }
            return descriptions;
        }
        return null;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static void generateNodeId(NodeId umlNodeid, org.eclipse.aas.api.submodel.submodelelement.dataelement.Property submodelproperty, org.eclipse.aas.api.submodel.submodelelement.dataelement.File submodelFile) {
        block30: {
            IdType idType = umlNodeid.getIdType();
            if (idType.getLiteral() == null) break block30;
            switch (idType.getLiteral()) {
                case "String": {
                    if (submodelproperty != null) {
                        submodelproperty.setIdentifier(umlNodeid.getIdentifier());
                    }
                    if (submodelFile == null) break;
                    submodelFile.setIdentifier(umlNodeid.getIdentifier());
                    break;
                }
                case "Integer": {
                    int idint;
                    try {
                        idint = Integer.parseInt(umlNodeid.getIdentifier());
                    }
                    catch (NumberFormatException e) {
                        idint = 0;
                    }
                    if (submodelproperty != null) {
                        submodelproperty.setIdentifier((long)idint);
                    }
                    if (submodelFile == null) break;
                    submodelFile.setIdentifier((long)idint);
                    break;
                }
                case "Long": {
                    long idlong;
                    try {
                        idlong = Long.parseLong(umlNodeid.getIdentifier());
                    }
                    catch (NumberFormatException e) {
                        idlong = 0L;
                    }
                    if (submodelproperty != null) {
                        submodelproperty.setIdentifier(idlong);
                    }
                    if (submodelFile == null) break;
                    submodelFile.setIdentifier(idlong);
                    break;
                }
                case "ByteArray": {
                    if (GenerateAASCodeHelper.convertStringtoByteArray(umlNodeid.getIdentifier()) == null) break;
                    if (submodelproperty != null) {
                        submodelproperty.setIdentifier(GenerateAASCodeHelper.convertStringtoByteArray(umlNodeid.getIdentifier()));
                    }
                    if (submodelFile == null) break;
                    submodelFile.setIdentifier(GenerateAASCodeHelper.convertStringtoByteArray(umlNodeid.getIdentifier()));
                    break;
                }
                case "UUID": {
                    UUID uid;
                    try {
                        uid = UUID.fromString(umlNodeid.getIdentifier());
                    }
                    catch (IllegalArgumentException e) {
                        uid = UUID.randomUUID();
                    }
                    if (submodelproperty != null) {
                        submodelproperty.setIdentifier(uid);
                    }
                    if (submodelFile == null) break;
                    submodelFile.setIdentifier(uid);
                }
            }
        }
    }

    public static byte[] convertStringtoByteArray(String input) {
        if (input != null && input.length() > 1) {
            String newString = input.substring(1, input.length() - 1);
            String[] stringArray = newString.split(", ");
            byte[] byte_array = new byte[stringArray.length];
            int i = 0;
            while (i < stringArray.length) {
                try {
                    byte_array[i] = (byte)Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException e) {
                    byte_array[i] = 0;
                }
                ++i;
            }
            return byte_array;
        }
        return null;
    }

    public static String getPropertyValue(org.eclipse.uml2.uml.Property property) {
        ValueSpecification vs = property.getDefaultValue();
        if (vs == null) {
            PrimitiveType pt;
            if (property.getType() instanceof PrimitiveType && (pt = (PrimitiveType)property.getType()).getName().equals("int")) {
                return "0";
            }
            return "null";
        }
        if (vs.getType() == null) {
            return vs.stringValue();
        }
        if (vs.getType().getName().equals("String")) {
            return vs.stringValue();
        }
        if (vs.getType().getName().equals("Integer")) {
            return String.valueOf(vs.integerValue());
        }
        if (vs.getType().getName().equals("Boolean")) {
            return String.valueOf(vs.booleanValue());
        }
        return vs.stringValue();
    }
}

