/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.aas.NodeId;
import org.eclipse.papyrus.aas.Submodel;
import org.eclipse.papyrus.aas.SubmodelElementCollection;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.ParameterUtils;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.ExternLibrary;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.External;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class JavaGenUtils {
    private static NamedElement currentNE;
    public static Map<NamedElement, EList<String>> imports;

    static {
        imports = new HashMap<NamedElement, EList<String>>();
    }

    public static String getJavaTypeFromUML(String umlTypeName) {
        switch (umlTypeName) {
            case "Boolean": {
                return "Boolean";
            }
            case "Integer": {
                return "Integer";
            }
            case "Real": {
                return "Float";
            }
            case "String": {
                return "String";
            }
            case "UnlimitedNatural": {
                return "BigInteger";
            }
            case "EString": {
                return "String";
            }
            case "EBoolean": {
                return "Boolean";
            }
            case "EDate": {
                return "XMLGregorianCalendar";
            }
            case "EDouble": {
                return "Double";
            }
            case "EInt": {
                return "Integer";
            }
            case "EFloat": {
                return "Float";
            }
            case "Date": {
                return "XMLGregorianCalendar";
            }
            case "AnySimpleType": {
                return "String";
            }
            case "IDREFS": {
                return "String";
            }
            case "Base64Binary": {
                return "Byte []";
            }
            case "AnyURI": {
                return "String";
            }
            case "Double": {
                return "Double";
            }
            case "Duration": {
                return "Duration";
            }
            case "Float": {
                return "Float";
            }
            case "GDay": {
                return "XMLGregorianCalendar";
            }
            case "GMonthDay": {
                return "XMLGregorianCalendar";
            }
            case "GMonth": {
                return "XMLGregorianCalendar";
            }
            case "GYear": {
                return "XMLGregorianCalendar";
            }
            case "GYearMonth": {
                return "XMLGregorianCalendar";
            }
            case "HexBinary": {
                return "Byte []";
            }
            case "NOTATION": {
                return "QName";
            }
            case "QName": {
                return "QName";
            }
            case "NonNegativeInteger": {
                return "BigInteger";
            }
            case "NonPositiveInteger": {
                return "BigInteger";
            }
            case "Int": {
                return "Integer";
            }
            case "Long": {
                return "Long";
            }
            case "Short": {
                return "Short";
            }
            case "Byte": {
                return "Byte";
            }
            case "NegativeInteger": {
                return "BigInteger";
            }
            case "PositiveInteger": {
                return "BigInteger";
            }
            case "UnsignedLong": {
                return "BigInteger";
            }
            case "UnsignedByte": {
                return "Short";
            }
            case "UnsignedInt": {
                return "Long";
            }
            case "UnsignedShort": {
                return "Integer";
            }
            case "ID": {
                return "String";
            }
            case "IDREF": {
                return "String";
            }
            case "ENTITY": {
                return "String";
            }
            case "int": {
                return "int";
            }
            case "boolean": {
                return "boolean";
            }
            case "long": {
                return "long";
            }
            case "short": {
                return "short";
            }
            case "byte": {
                return "byte";
            }
            case "float": {
                return "float";
            }
            case "double": {
                return "double";
            }
            case "char": {
                return "char";
            }
        }
        return "Object";
    }

    public static String getStdtypes(PrimitiveType type) {
        Element owner = type.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (owningPkgName.equals("PrimitiveTypes") || owningPkgName.equals("UMLPrimitiveTypes") || owningPkgName.equals("XMLPrimitiveTypes") || owningPkgName.equals("JavaPrimitiveTypes")) {
            String td = "";
            String name = type.getName();
            td = JavaGenUtils.getJavaTypeFromUML(name);
            return td;
        }
        return "";
    }

    public static String javaQualifiedName(NamedElement ne, Element ns) {
        EList<String> importsOfCurrentNs;
        if (ne == null) {
            return "undefined";
        }
        Element owner = ne.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (GenUtils.hasStereotype((Element)ne, External.class) || GenUtils.hasStereotypeTree((Element)ne, NoCodeGen.class) || GenUtils.hasStereotypeTree((Element)ne, ExternLibrary.class)) {
            return ne.getName();
        }
        if (ne instanceof PrimitiveType) {
            String stdType = JavaGenUtils.getStdtypes((PrimitiveType)ne);
            if (!stdType.isEmpty()) {
                return stdType;
            }
        } else {
            if (owner instanceof ClassifierTemplateParameter) {
                return ne.getName();
            }
            if (ne instanceof Classifier && !((Classifier)ne).getTemplateBindings().isEmpty()) {
                TemplateBinding templateBinding = (TemplateBinding)((Classifier)ne).getTemplateBindings().get(0);
                TemplateSignature signature = templateBinding.getSignature();
                String specializedTypeName = "";
                if (signature != null && signature.getTemplate() instanceof Classifier) {
                    specializedTypeName = JavaGenUtils.javaQualifiedName((NamedElement)((Classifier)signature.getTemplate()), (Element)ne);
                    EList templateParameters = signature.getOwnedParameters();
                    HashMap<TemplateParameter, NamedElement> parameterToClassMap = new HashMap<TemplateParameter, NamedElement>();
                    EList substitutions = templateBinding.getParameterSubstitutions();
                    for (TemplateParameterSubstitution substitution : substitutions) {
                        if (substitution.getFormal() == null || !templateParameters.contains(substitution.getFormal()) || !(substitution.getActual() instanceof NamedElement)) continue;
                        parameterToClassMap.put(substitution.getFormal(), (NamedElement)substitution.getActual());
                    }
                    if (parameterToClassMap.size() == templateParameters.size()) {
                        specializedTypeName = String.valueOf(specializedTypeName) + "<";
                        for (TemplateParameter templateParameter : templateParameters) {
                            NamedElement substitutionType = (NamedElement)parameterToClassMap.get(templateParameter);
                            specializedTypeName = String.valueOf(specializedTypeName) + JavaGenUtils.javaQualifiedName(substitutionType, (Element)ne) + ", ";
                        }
                        specializedTypeName = specializedTypeName.substring(0, specializedTypeName.length() - 2);
                        specializedTypeName = String.valueOf(specializedTypeName) + ">";
                    }
                    return specializedTypeName;
                }
            }
        }
        String qName = GenUtils.getFullName((NamedElement)ne, (String)".", (boolean)false);
        if (ns instanceof Classifier) {
            Classifier classifier = (Classifier)ns;
            for (Element directlyOwnedElement : classifier.getOwnedElements()) {
                if (!(directlyOwnedElement instanceof Enumeration) && !(directlyOwnedElement instanceof Interface) && !directlyOwnedElement.eClass().equals(UMLFactory.eINSTANCE.getUMLPackage().getClass_())) continue;
                if (((Classifier)directlyOwnedElement).getQualifiedName().equals(ne.getQualifiedName())) {
                    return ne.getName();
                }
                if (!((Classifier)directlyOwnedElement).getName().equals(ne.getName())) continue;
                return qName;
            }
        }
        if ((importsOfCurrentNs = imports.get(currentNE)) != null) {
            for (String importOfCurrentNs : importsOfCurrentNs) {
                if (!importOfCurrentNs.equals(qName)) continue;
                return ne.getName();
            }
        }
        return qName;
    }

    public static String getTemplateTypeName(TemplateParameter templateParam) {
        String name = "";
        ParameterableElement pElt = templateParam.getParameteredElement();
        name = pElt != null && pElt instanceof NamedElement ? ((NamedElement)pElt).getName() : "undefined";
        return name;
    }

    public static String getNamespace(NamedElement ne) {
        String namespace = "";
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null) continue;
            String nsName = ns.getName();
            if (!namespace.equals("")) {
                nsName = String.valueOf(nsName) + "::";
            }
            namespace = String.valueOf(nsName) + namespace;
        }
        if (!namespace.equals("")) {
            namespace = "\nusing namespace " + namespace + ";\n";
        }
        return namespace;
    }

    public static void openNS(NamedElement ne) {
        currentNE = ne;
    }

    public static String getFullPath(Classifier classe, IProject project, String separator, boolean withProjectName) {
        String qName = JavaGenUtils.getFullPath(classe, project, separator);
        return qName;
    }

    public static String getFullPath(Classifier classe, IProject project, String seperator) {
        return project.getName().toLowerCase().concat(".module.submodels");
    }

    public static Boolean isOperationExists(Classifier c, Property p) {
        for (Operation o : JavaGenUtils.getAllownedOperations(c)) {
            String name = String.valueOf(((NamedElement)p.getOwner()).getName()) + "_" + p.getName();
            if (!o.getName().equals("get_" + name)) continue;
            return true;
        }
        return false;
    }

    public static Boolean hasOpaqueBehavior(Operation o) {
        Boolean result = false;
        result = o.getMethods() != null ? !o.getMethods().isEmpty() : false;
        return result;
    }

    public static Boolean isOperationCreatedByUser(Operation o, Classifier c) {
        String name;
        for (Property p : JavaGenUtils.getAllownedAttributes(c)) {
            name = String.valueOf(((NamedElement)p.getOwner()).getName()) + "_" + p.getName();
            if (!o.getName().equals("get_" + name)) continue;
            return false;
        }
        for (Element inneclass : c.getOwnedElements()) {
            if (!(inneclass instanceof Classifier)) continue;
            name = String.valueOf(((Classifier)((Classifier)inneclass).getOwner()).getName()) + "_" + ((Classifier)inneclass).getName();
            if (!o.getName().equals("get_" + name)) continue;
            return false;
        }
        return true;
    }

    public static Boolean isOperationExists(Classifier c, Classifier p) {
        Classifier submodel = (Classifier)JavaGenUtils.getSubmodel(c);
        for (Operation o : JavaGenUtils.getAllownedOperations(submodel)) {
            String newname = String.valueOf(((Classifier)p.getOwner()).getName()) + "_" + p.getName();
            if (!o.getName().equals("get_" + newname)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static Element getSubmodel(Classifier c) {
        qualifiedName = "";
        owner = c;
        if (!JavaGenUtils.isSubmodel((Element)owner).booleanValue()) ** GOTO lbl6
        return c;
lbl-1000:
        // 1 sources

        {
            owner = owner.getOwner();
lbl6:
            // 2 sources

            ** while (!JavaGenUtils.isSubmodel((Element)owner).booleanValue())
        }
lbl7:
        // 1 sources

        return owner;
    }

    public static Boolean isSubmodel(Element c) {
        return GenUtils.hasStereotype((Element)c, Submodel.class);
    }

    public static Operation getOperation(Classifier c, Classifier sec) {
        String newName = "get_" + ((NamedElement)sec.getOwner()).getName() + "_" + sec.getName();
        for (Operation o : JavaGenUtils.getAllownedOperations(c)) {
            if (!o.getName().equals(newName)) continue;
            return o;
        }
        return null;
    }

    public static Operation getOperation(Classifier c, Property p) {
        String name = "get_" + ((NamedElement)p.getOwner()).getName() + "_" + p.getName();
        for (Operation o : JavaGenUtils.getAllownedOperations(c)) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public static Boolean isConnectProperty(Property property) {
        org.eclipse.papyrus.aas.Property aasProp;
        if (GenUtils.hasStereotype((Element)property, org.eclipse.papyrus.aas.Property.class) && (aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class)) != null) {
            return aasProp.isDynamic();
        }
        return false;
    }

    public static Boolean isConnectSEC(Classifier classifier) {
        SubmodelElementCollection sec;
        if (GenUtils.hasStereotype((Element)classifier, SubmodelElementCollection.class) && (sec = (SubmodelElementCollection)UMLUtil.getStereotypeApplication((Element)classifier, SubmodelElementCollection.class)) != null) {
            return sec.isDynamic();
        }
        return false;
    }

    public static Boolean hasNodeId(Property property) {
        org.eclipse.papyrus.aas.Property aasProp;
        if (GenUtils.hasStereotype((Element)property, org.eclipse.papyrus.aas.Property.class) && (aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class)) != null && aasProp.getNodeId() != null) {
            return true;
        }
        return false;
    }

    public static Boolean hasEndPoint(Property property) {
        org.eclipse.papyrus.aas.Property aasProp;
        if (GenUtils.hasStereotype((Element)property, org.eclipse.papyrus.aas.Property.class) && (aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class)) != null && aasProp.getEndPoint() != null) {
            return true;
        }
        return false;
    }

    public static Integer getNameSpace(Property property) {
        if (JavaGenUtils.hasNodeId(property).booleanValue()) {
            org.eclipse.papyrus.aas.Property aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class);
            return aasProp.getNodeId().getNamespace();
        }
        return 0;
    }

    public static String getIdentifier(Property property) {
        org.eclipse.papyrus.aas.Property aasProp;
        NodeId nodeid;
        if (JavaGenUtils.hasNodeId(property).booleanValue() && (nodeid = (aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class)).getNodeId()) != null) {
            if (nodeid.getIdType().getLiteral().equals("String")) {
                return "\"" + aasProp.getNodeId().getIdentifier() + "\"";
            }
            return aasProp.getNodeId().getIdentifier();
        }
        return "";
    }

    public static String getEndPointName(Property property) {
        if (JavaGenUtils.hasEndPoint(property).booleanValue()) {
            org.eclipse.papyrus.aas.Property aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class);
            return aasProp.getEndPoint().getName();
        }
        return "";
    }

    public static String getEndPointProtocol(Property property) {
        if (JavaGenUtils.hasEndPoint(property).booleanValue()) {
            org.eclipse.papyrus.aas.Property aasProp = (org.eclipse.papyrus.aas.Property)UMLUtil.getStereotypeApplication((Element)property, org.eclipse.papyrus.aas.Property.class);
            return aasProp.getEndPoint().getProtocol().getName();
        }
        return "";
    }

    public static String getBody(Operation operation, Pattern selectedLanguages) {
        for (Behavior behavior : operation.getMethods()) {
            if (!(behavior instanceof OpaqueBehavior)) continue;
            return GenUtils.getBodyFromOB((OpaqueBehavior)((OpaqueBehavior)behavior), (Pattern)selectedLanguages);
        }
        if (operation != null && GenUtils.hasStereotype((Element)operation, (String)"AAS::Operation") && ParameterUtils.getOutParameter((EList<Parameter>)operation.getOwnedParameters()) != null) {
            Parameter outparam = ParameterUtils.getOutParameter((EList<Parameter>)operation.getOwnedParameters());
            return "(" + outparam.getType().getName() + ")" + ((Classifier)operation.getOwner()).getName() + "." + outparam.getName() + "_" + operation.getName() + "_Output.getValue();";
        }
        return "";
    }

    public static List<Property> getAllownedAttributes(Classifier classifier) {
        ArrayList<Property> allattributes = new ArrayList<Property>();
        allattributes.addAll((Collection<Property>)classifier.allAttributes());
        for (Element el : classifier.allOwnedElements()) {
            if (!(el instanceof Classifier) || !GenUtils.hasStereotype((Element)classifier, SubmodelElementCollection.class) || JavaGenUtils.isConnectSEC((Classifier)el).booleanValue()) continue;
            allattributes.addAll((Collection<Property>)((Classifier)el).allAttributes());
        }
        return allattributes;
    }

    public static List<Operation> getAllownedOperations(Classifier classifier) {
        ArrayList<Operation> alloperations = new ArrayList<Operation>();
        alloperations.addAll((Collection<Operation>)classifier.getAllOperations());
        for (Element el : classifier.allOwnedElements()) {
            if (!(el instanceof Classifier)) continue;
            alloperations.addAll((Collection<Operation>)((Classifier)el).getAllOperations());
        }
        return alloperations;
    }

    public static String getXMLTypes(TypedElement element) {
        String td = "Object";
        String[] strings = element.getName().split("\\.");
        if (strings != null && strings.length > 1) {
            String type = strings[1];
            td = JavaGenUtils.getJavaTypeFromUML(type);
        }
        return td;
    }

    public static String removedot(String element) {
        String result = element;
        String[] strings = element.split("\\.");
        if (strings != null && strings.length > 1) {
            result = strings[1];
        }
        return result;
    }

    public static String getPropertyValue(Property property) {
        ValueSpecification vs = property.getDefaultValue();
        if (vs == null) {
            PrimitiveType pt;
            if (property.getType() instanceof PrimitiveType && (pt = (PrimitiveType)property.getType()).getName().equals("int")) {
                return "0";
            }
            return "null";
        }
        if (vs instanceof LiteralString && property.getType().getName().equals("String")) {
            return "\"" + vs.stringValue() + "\"";
        }
        if (vs instanceof LiteralInteger) {
            return String.valueOf(vs.integerValue());
        }
        if (vs instanceof LiteralBoolean) {
            return String.valueOf(vs.booleanValue());
        }
        if (vs instanceof LiteralReal) {
            return String.valueOf(vs.realValue());
        }
        return vs.stringValue();
    }
}

